/*
 * JournalArticleEditPanel.java:  an editor of an article in a journal to be used
 * as superclass of PublicationEditor Panel
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 *
 * $Id: JournalArticleEditPanel.java,v 1.3 2002/05/14 10:02:43 ryo Exp $
 * $Log: JournalArticleEditPanel.java,v $
 * Revision 1.3  2002/05/14 10:02:43  ryo
 * add updateView()
 *
 * Revision 1.2  2002/02/05 18:06:27  nozomi
 * Add constructor
 *
 * Revision 1.1  2002/02/05 06:47:46  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.GridBagConstraints;

import java.util.Vector;

import org.nomencurator.editor.model.PublicationEditModel;

/**
 * <code>Panel</code> to represent a <code>PublicationEditModel</code>
 *
 * @see org.nomencurator.editor.model.PublicationEditModel
 * @see org.nomencurator.Publication
 *
 * @version 	05 Feb 2002
 * @author 	Nozomi `James' Ytow
 */
public class JournalArticleEditPanel
    extends ArticleEditPanel
{
    /**
     * Title of <code>containerField</code>
     */
    protected static String containerFieldTitle = "Journal";

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public JournalArticleEditPanel(PublicationEditModel model)
    {
	super(model, true, false, null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public JournalArticleEditPanel(AbstractPublicationEditPanel panel)
    {
	super(panel.getPublicationEditModel(),
	      panel.isEditable(),
	      panel.isSummaryVisible(),
	      null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public JournalArticleEditPanel(PublicationEditModel model,
			       boolean editable,
			       boolean showSummary,
			       Vector authorEditors,
			       Vector appearanceEditors)
    {
	super(model, editable, showSummary, authorEditors, appearanceEditors);
    }

    /**
     * Layouts <code>Component</code>s representing container title of the publication
     */
    protected void layoutContainerField()
    {
	citationPanel.add(containerFieldTitle, containerField, GridBagConstraints.HORIZONTAL);
    }

    public void updateView() {
    }

}


