/*
 *
 * BookEditor.java:  an editor of a chapter in a book
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: MiscellaneousWorkEditor.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: MiscellaneousWorkEditor.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.TextListener;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.Checkbox;
import jp.kyasu.awt.CheckboxGroup;
import jp.kyasu.awt.Frame;
import java.awt.Window;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.Panel;
import jp.kyasu.awt.TextField;
import jp.kyasu.awt.TextArea;
import jp.kyasu.awt.ToolBar;

import jp.kyasu.graphics.Text;

import org.nomencurator.Publication;

import org.nomencurator.editor.PublicationEditor;

public class MiscellaneousWorkEditor extends PublicationEditor
    implements ActionListener
{
    protected static int miscWorkEditors = 0;
    private static String DEFAULT_TITLE = "Generic Work Editor";

    public MiscellaneousWorkEditor()
    {
	this(new Publication());
    }
    
    public MiscellaneousWorkEditor(Publication publication)
    {
	this(publication, null);
    }

    public MiscellaneousWorkEditor(Publication publication,
				   AuthorListEditor authorListEditor)
    {
	this(publication, authorListEditor, false);
    }
    
    public MiscellaneousWorkEditor(Publication publication,
				   AuthorListEditor authorListEditor,
				   boolean showAbstract)
    {
	super(MISC, publication, authorListEditor, showAbstract);
    }

    public MiscellaneousWorkEditor(PublicationEditor publicationEditor)
    {
	this(MISC, publicationEditor);
    }

    public MiscellaneousWorkEditor(int publicationType,
			 Publication publication,
			 AuthorListEditor authorListEditor,
			 boolean showAbstract)
    {
	this(publicationType, publication, authorListEditor, showAbstract, null);
    }

    public MiscellaneousWorkEditor(int publicationType,
			 Publication publication,
			 AuthorListEditor authorListEditor,
			 boolean showAbstract, 
			 AuthorListEditor editorListEditor)
    {
	super(publicationType, publication, authorListEditor, showAbstract);
    }

    public MiscellaneousWorkEditor(int publicationType, PublicationEditor publicationEditor)
    {
	super(publicationType, publicationEditor);
    }

    protected void createComponents()
    {
	super.createComponents();

	contentsTitle = new AcronymTextEditor(4, 45);
    }

    //    protected void addComponents()
    protected void delayedAddComponents()
    {
	//	super.addComponents();
	super.delayedAddComponents();
	constraints.gridy++;
	constraints.fill = GridBagConstraints.NONE;
	constraints.gridwidth = 1;
	
	constraints.fill      = GridBagConstraints.NONE;
	constraints.gridwidth = 1;
	add(new Label("Year:", Label.RIGHT), constraints);
	add(year, constraints);
	constraints.gridwidth = GridBagConstraints.REMAINDER;
	constraints.fill      = GridBagConstraints.HORIZONTAL;
	add(new Panel(), constraints);
	constraints.gridy++;
	constraints.gridwidth = 1;
	constraints.gridx = 0;

	add("Description:", contentsTitle);

	if(showSummary)
	    addSummary();
    }

    public Text getCitationTitleText()
    {
	//	if(publication == null)
	//	    return new Text("");
	return contentsTitle.getTEXT();
    }


    public void actionPerformed (ActionEvent e)
    {
	Object eventSource = e.getSource();
	super.actionPerformed(e);
	/*
	if(eventSource == tb){
	    pack();
	}
	*/
    }
    /*
      public void paint(Graphics g) {
      super.paint(g);
      pack();
      }
    */
    /*
      public void componentHidden(ComponentEvent e) {
      pack();
      }
      
      public void componentMoved(ComponentEvent e) {
      }
      
      public void  componentResized(ComponentEvent e) {
      pack();
      }
      
      public void componentShown(ComponentEvent e) {
      pack();
    }
    */

    public Text toText()
    {
	StringBuffer buffer = new StringBuffer("");
	Text text = new Text("");
	//	buffer.append(authors);
	buffer.append(" (");
	buffer.append(year.getText());
	buffer.append(") ");
	text.append(new Text(buffer.substring(0)));
	buffer.delete(0, buffer.length());
	buffer.append(citationTitle.getText());

	return text;
    }
}
