/*
 * NameSearchDialog.java:  a Dialg to search NameUsages
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 *
 * $Id: NameSearchDialog.java,v 1.2 2002/09/09 16:47:16 nozomi Exp $
 * $Log: NameSearchDialog.java,v $
 * Revision 1.2  2002/09/09 16:47:16  nozomi
 * trial implementation of focus control
 *
 * Revision 1.1  2002/09/06 03:11:13  nozomi
 * initial improt into CVS repository
 *
 */

package org.nomencurator.editor;

import java.awt.Frame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import java.util.Vector;

import jp.kyasu.graphics.Text;

import jp.kyasu.awt.Button;


import org.nomencurator.Annotation;
import org.nomencurator.NamedObject;

import org.nomencurator.awt.Dialog;

import org.nomencurator.editor.model.NamedObjectEditModel;
import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.AnnotationEditModel;


/**
 * <code>Dialog</code> to edit an <code>Annotation</code>
 *
 * @see org.nomencurator.editor.model.AnnotationEditModel
 * @see org.nomencurator.editor.AnnotationEditPanel
 * @see org.nomencurator.Annotation
 *
 * @version 	09 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameSearchDialog
    extends Dialog
    implements ActionListener
{
    protected SearchView searchPanel;

    protected Button okButton;
    protected Button cancelButton;

    protected boolean isOK;
    
    public NameSearchDialog(Frame frame)
    {
	this(frame, "NameSearch", true);
    }

    public NameSearchDialog(Frame frame, String title, boolean modal)
    {
	super(frame, title, modal);
	isOK = false;
	setSize(getPreferredSize());
    }

    protected void createButtons()
    {
	okButton = new Button("Add");
	okButton.addActionListener(this);
	cancelButton = new Button("Cancel");
	cancelButton.addActionListener(this);
    }

    protected void createPanels()
    {
	south = new Panel();
	searchPanel = new SearchView(false);
	center = searchPanel;
    }

    protected void addComponents()
    {
	south.add(okButton);
	south.add(cancelButton);
    }

    public void actionPerformed(ActionEvent e)
    {
	Object source = e.getSource();
	if(source == okButton) {
	    isOK = true;
	    dispose();
	}
	else if(source == cancelButton) {
	    isOK = false;
	    dispose();
	}
    }

    public boolean isOK()
    {
	return isOK;
    }

    /**
     * Get selected link type index.
     * @return selected link type index.
     */
    public Vector getSelectedNameUsages()
    {
	return searchPanel.getSelectedNameUsages();
    }

    /**
     * Get selected link type index.
     * @return selected link type index.
     */
    public Vector getSelectedNameUsageEditModels()
    {
	return searchPanel.getSelectedNameUsageEditModels();
    }

    public void show()
    {
	searchPanel.requestFocus();
	super.show();
    }
}


