/*
 * NameTree.java:  a Tree holding NameUsageNode
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameTree.java,v 1.7 2002/08/21 02:17:37 nozomi Exp $
 * $Log: NameTree.java,v $
 * Revision 1.7  2002/08/21 02:17:37  nozomi
 * NamePath import is commented out
 *
 * Revision 1.6  2002/08/05 23:53:25  nozomi
 * fix selection code in ItemEvent handling
 *
 * Revision 1.5  2002/08/05 07:56:43  nozomi
 * improve/increase interaction between NameUsageEditPanel and NameTree
 *
 * Revision 1.4  2002/04/16 23:43:51  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.3  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.2  2002/03/10 12:03:57  nozomi
 * NameRecordEditModel selection by NameTree
 *
 * Revision 1.1  2002/03/07 10:24:02  nozomi
 * initial import
 *
 */

package org.nomencurator.editor;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import java.util.Enumeration;


import jp.kyasu.awt.ScrollPanel;

import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.V3DBorder;
import jp.kyasu.graphics.VBorder;

import org.nomencurator.awt.tree.TreeNode;
import org.nomencurator.awt.tree.TextTreeModel;

//import org.nomencurator.editor.model.NamePath;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.editor.model.NameTreeModel;

import org.nomencurator.util.tree.TreePath;

/**
 * The model interface for an object that acts as a named object edit model
 *
 *
 * @version 	19 Aug 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameTree
    extends Tree
    implements ItemListener
{
    /**
     * Constructs a scrolling Tree with the specified model and number of rows.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     */
    public NameTree(NameTreeModel textTreeModel, int rows)
    {
	this(textTreeModel, rows, false);
    }

    /**
     * Constructs a scrolling Tree with the specified model, number of rows,
     * and multipleMode.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     * @param multipleMode  if <code>true</code>, then multiple selections
     *                      are allowed; otherwise, only one item can be
     */
    public NameTree(NameTreeModel textTreeModel, int rows, boolean multipleMode)
    {
	this(textTreeModel, rows, multipleMode, ScrollPanel.SCROLLBARS_BOTH);
    }

    /**
     * Constructs a scrolling Tree with the specified model, number of rows,
     * multipleMode, and scroll bar visibility.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     * @param multipleMode  if <code>true</code>, then multiple selections
     *                      are allowed; otherwise, only one item can be
     * @param scrollbars    a constant that determines what scrollbars are
     *                      created to view the list.
     */
    public NameTree(NameTreeModel textTreeModel, int rows, boolean multipleMode,
		int scrollbars)
    {
	this(textTreeModel, rows, multipleMode, scrollbars,
	     new V3DBorder(false));
    }

    /**
     * Constructs a scrolling Tree with the specified model, number of rows,
     * multipleMode, scroll bar visibility, and border visual.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     * @param multipleMode  if <code>true</code>, then multiple selections
     *                      are allowed; otherwise, only one item can be
     * @param scrollbars    a constant that determines what scrollbars are
     *                      created to view the list.
     * @param border        the border visual of the list.
     */
    public NameTree(NameTreeModel textTreeModel, int rows, boolean multipleMode,
		int scrollbars, VBorder border)
    {
	super(textTreeModel, rows, multipleMode, scrollbars, border);
    }

    /**
     * Constructs a scrolling Tree with the specified model.
     * This constructor is used by the subclasses only.
     */
    protected NameTree(NameTreeModel textTreeModel)
    {
	this(textTreeModel, 0);
    }

    /**
     * Returns refenrece to newly constructed Tree having specified <code>node</code> as
     * its root node.  Leaf nodes in the tree are defined as any node witout child node
     * by default.
     *
     * @param node TreeNode object to be the root of constructed Tree
     */
    public NameTree(NameUsageNode node)
    {
	this(node, false);
    }


    /**
     * Returns reference to newly constructed Tree having specified <code>node</code> as
     * its root node.  Leaf nodes in the tree are determined depeding on given
     * <code>asksAllowsChildren</code>.
     *
     * @param node TreeNode object to be the root of constructed Tree
     * @param askedAllowsChildren false if leaf node is any node without child node, 
     * true if leaf node is a node which prohibits having child node.
     */
    public NameTree(NameUsageNode node,
		boolean asksAllowsChildren)
    {
	this(new NameTreeModel(node, asksAllowsChildren));
    }

    public NameUsageEditModel getSelectedModel()
    {
	NameUsageNode node = getSelectedNode();
	return node == null? null:node.getNameUsageEditModel();
    }

    public NameUsageNode getSelectedNode()
    {
	int index = getSelectedIndex();
	return index == -1? null:(NameUsageNode)(((TextTreeModel)getModel()).getNodeForRow(getSelectedIndex()));
    }

    
    public NameUsageNode getNode(int index)
    {
	return (NameUsageNode)(((TextTreeModel)getModel()).getNodeForRow(index));
    }

    /**
     * Invoked when an item's state has been changed.
     * @see java.awt.event.ItemListener
     */
    public void itemStateChanged(ItemEvent e)
    {
	Object obj = e.getSource();
	if(!(obj instanceof NameUsageEditor)) {
	    super.itemStateChanged(e);
	    return;
	}

	NameUsageEditModel newSelection = 
	    (NameUsageEditModel)(((NameUsageEditor)obj).getModel());

	
	NameUsageEditModel currentSelection = getSelectedModel();
	//	TreePath currentPath = getSelectionPath();

	//	if(currentPath == null) {
	if(currentSelection == null) {
	    if(newSelection == null)
		select(0);
	    else {

	    }
	    return;
	}

	if(newSelection.getHigherModel() == currentSelection) {
	    int index = getSelectedIndex();
	    TreeNode tn = getTextTreeModel().getNodeForRow(index);

	    //TreeNode tn = (TreeNode)(currentPath.getLastPathComponent());
	    if(!tn.isExpanded())
		tn.setExpanded(true);
	    int count = tn.getChildCount();
	    for(index = 0;
		index < count && ((TreeNode)(tn.getChildAt(index))).getUserObject() != newSelection;
		index++) { ; }
	    if(index == count)
		index = count - 1;
	    select(getTextTreeModel().getRowForNode((tn.getChildAt(index))));
	    //	    setSelectionPath(new NamePath(currentPath, newSelection));
		/*
	    index++;
	    index += currentSelection.getLowerEditModels().indexOf(newSelection);
	    select(index);
		*/
	}

	else if(currentSelection.getHigherModel() == newSelection) {
	    int index = getSelectedIndex();
	    select(getTextTreeModel().getRowForNode(getTextTreeModel().getNodeForRow(index).getParent()));
	    //	    setSelectionPath(new NamePath(currentPath, newSelection));
	}

    }
}
