/*
 * NameUsageEditPanel.java:  a Panel of NameUsageEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameUsageEditPanel.java,v 1.106 2002/10/18 07:48:15 nozomi Exp $
 * $Log: NameUsageEditPanel.java,v $
 * Revision 1.106  2002/10/18 07:48:15  nozomi
 * remove debug infro printing line
 *
 * Revision 1.105  2002/10/18 04:56:39  nozomi
 * use getDummyModel()
 *
 * Revision 1.104  2002/10/17 06:19:36  nozomi
 * modify Annotation hanlding
 *
 * Revision 1.103  2002/10/16 08:06:43  nozomi
 * appearance may be nominal
 *
 * Revision 1.102  2002/10/10 20:32:55  nozomi
 * improve setModel(ObjectEditModel) to propagate model setting to AppearanceEditPanel
 *
 * Revision 1.101  2002/10/10 20:19:21  nozomi
 * support selection of NameUsageEditPanel by double click
 *
 * Revision 1.100  2002/10/10 04:27:23  nozomi
 * support double-click switch to AppearanceEditPanel
 *
 * Revision 1.99  2002/10/08 21:16:29  nozomi
 * modify NameTree.select() call
 *
 * Revision 1.98  2002/10/07 01:05:39  nozomi
 * improve user support when rank changed
 *
 * Revision 1.97  2002/10/02 06:58:30  nozomi
 * improve typeOfType handling
 *
 * Revision 1.96  2002/10/02 02:48:33  nozomi
 * fix and improve rank handling
 *
 * Revision 1.95  2002/10/01 11:12:21  nozomi
 * save Annotatoins whenever modified
 *
 * Revision 1.94  2002/10/01 11:11:25  nozomi
 * save Annotatoins when modified
 *
 * Revision 1.93  2002/09/28 03:14:45  nozomi
 * rank handling coping with save/loadAttributes()
 *
 * Revision 1.92  2002/09/26 11:55:03  ryo
 * fix bug about citation field
 *
 * Revision 1.91  2002/09/20 13:21:00  nozomi
 * remove debugging prinln()
 *
 * Revision 1.90  2002/09/20 13:15:49  nozomi
 * fix null rank handling
 *
 * Revision 1.89  2002/09/20 09:11:56  nozomi
 * fix null-rank handling in selectLowerTaxon()
 *
 * Revision 1.88  2002/09/19 07:14:55  nozomi
 * tentative fix multiple addition of poput menu
 *
 * Revision 1.87  2002/09/19 05:58:22  nozomi
 * fix Annotation addition
 *
 * Revision 1.86  2002/09/17 08:46:39  nozomi
 * re-organise initialisation
 *
 * Revision 1.85  2002/09/09 16:46:50  nozomi
 * use summaryTextModel to display appearance
 *
 * Revision 1.84  2002/09/07 17:15:12  nozomi
 * fix bug in unsaved object putting methods
 *
 * Revision 1.83  2002/09/07 04:45:09  nozomi
 * update annotation list
 *
 * Revision 1.82  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.81  2002/09/06 16:16:59  nozomi
 * automatic addition of itself to new Annotation
 *
 * Revision 1.80  2002/09/06 04:23:59  nozomi
 * put affected objects to be saved when AnnotationEditDialog closed
 * $Id: NameUsageEditPanel.java,v 1.106 2002/10/18 07:48:15 nozomi Exp $
 *
 * Revision 1.79  2002/09/06 02:03:19  nozomi
 * Annotation Dialog handling; invalidation in setModel()
 *
 * Revision 1.78  2002/09/03 02:53:09  nozomi
 * modify getViewName()
 *
 * Revision 1.77  2002/09/02 16:29:07  nozomi
 * note TextArea is also focuse controlled
 *
 * Revision 1.76  2002/08/23 06:20:18  t.okada
 * bug where the note column is not saved is corrected.
 *
 * Revision 1.75  2002/08/23 05:05:01  ryo
 * add menu item for deleting an annotation into the popup menu of annotationList
 *
 * Revision 1.74  2002/08/23 04:00:08  nozomi
 * support type
 *
 * Revision 1.73  2002/08/22 13:25:30  t.okada
 * It corrects for a locale colum addition.
 *
 * Revision 1.72  2002/08/22 10:53:09  nozomi
 * keep focus after choice of rank
 *
 * Revision 1.71  2002/08/22 08:24:34  nozomi
 * support type
 *
 * Revision 1.70  2002/08/22 02:43:14  nozomi
 * automatic naming for ranks lower than genus
 *
 * Revision 1.69  2002/08/14 05:02:51  ryo
 * move to NameUsageEditModel the process which generates authority string
 *
 * Revision 1.68  2002/08/13 07:42:38  ryo
 * add menu item for deleting a taxon into the popup menu of LowerList
 *
 * Revision 1.67  2002/08/13 02:44:11  t.okada
 * Size adjustment of TextField
 *
 * Revision 1.66  2002/08/05 08:00:44  t.okada
 * DummyModel addition processing is corrected.
 *
 * Revision 1.65  2002/08/05 07:56:43  nozomi
 * improve/increase interaction between NameUsageEditPanel and NameTree
 *
 * Revision 1.64  2002/08/05 03:12:28  nozomi
 * change annotation list arrangement
 *
 * Revision 1.63  2002/07/31 06:56:29  nozomi
 * use TextArea for note
 *
 * Revision 1.62  2002/07/18 14:38:04  t.okada
 * note item is added to nameusage
 *
 * Revision 1.61  2002/06/23 13:38:42  nozomi
 * aware of FocusController
 *
 * Revision 1.60  2002/06/11 12:25:42  ryo
 * modify the processing of authority dialog
 *
 * Revision 1.59  2002/06/10 12:59:02  ryo
 * set author and year to authority
 *
 * Revision 1.58  2002/06/10 12:35:56  ryo
 * set author to authority
 *
 * Revision 1.57  2002/06/09 12:42:05  nozomi
 * setHigherEditModel after rank set
 *
 * Revision 1.56  2002/06/04 13:46:28  ryo
 * open confirm dialog when lower taxons removed
 *
 * Revision 1.55  2002/06/03 12:19:36  t.okada
 * changes into NamedObjectBroker from SearchController.
 *
 * Revision 1.54  2002/05/31 21:26:41  nozomi
 * move notifyObserver() to NameUsageEditModel
 *
 * Revision 1.53  2002/05/28 22:06:26  nozomi
 * add deleteObserver
 *
 * Revision 1.52  2002/05/28 07:33:22  ryo
 * fix bug of no deleting taxons below the current taxon
 *
 * Revision 1.51  2002/05/27 22:46:33  nozomi
 * implement symmetric constraints on higher/lower
 *
 * Revision 1.50  2002/05/27 14:18:07  ryo
 * add menu item for deleting a taxon into the popup menu of NameTree
 *
 * Revision 1.49  2002/05/27 04:45:25  nozomi
 * fix cursor position after getting forcus
 *
 * Revision 1.48  2002/05/27 02:20:14  nozomi
 * move cursor at end of line when focus moved to name
 *
 * Revision 1.47  2002/05/26 21:16:25  nozomi
 * show scrollbar of name list always
 *
 * Revision 1.46  2002/05/26 21:03:46  nozomi
 * modify double click handling
 *
 * Revision 1.45  2002/05/25 17:19:25  nozomi
 * link when new child NameUsageEditModel created
 *
 * Revision 1.44  2002/05/25 16:55:19  nozomi
 * fix model selection bug
 *
 * Revision 1.43  2002/05/24 15:39:30  t.okada
 * Correction for a NameTree display
 *
 * Revision 1.42  2002/05/24 14:17:05  t.okada
 * Processing of HigherTaxon change is corrected.
 *
 * Revision 1.41  2002/05/24 08:15:59  ryo
 * add the processing when being double-clicked in lowerList
 *
 * Revision 1.40  2002/05/17 19:10:06  ryo
 * add popup menu to lowerList and annotationList
 *
 * Revision 1.39  2002/05/17 10:53:25  ryo
 * modify *ButtonClicked()
 *
 * Revision 1.38  2002/05/17 09:38:46  ryo
 * modify related to Annotation
 *
 * Revision 1.37  2002/05/16 12:56:46  t.okada
 * addition of higher taxon change processing
 *
 * Revision 1.36  2002/05/16 12:45:46  ryo
 * modify mouseDoubleClicked()
 *
 * Revision 1.35  2002/05/16 11:25:54  ryo
 * create instance of authority
 *
 * Revision 1.34  2002/05/16 09:08:34  ryo
 * add registration processing of Annotation
 *
 * Revision 1.33  2002/05/15 12:04:31  ryo
 * add reference processing of authority
 *
 * Revision 1.32  2002/05/14 10:02:43  ryo
 * add updateView()
 *
 * Revision 1.31  2002/05/10 13:42:37  ryo
 * add the processing which should be performed when double clicking a list
 *
 * Revision 1.30  2002/05/08 20:48:36  nozomi
 * add mouseDoiubleClicked to handle douible click
 *
 * Revision 1.29  2002/05/08 10:56:53  ryo
 * disable OK, Clear and Cancel button in *EditPanel
 *
 * Revision 1.28  2002/04/20 23:29:27  nozomi
 * improve mutual linkage between EditPanels
 *
 * Revision 1.27  2002/04/19 21:44:14  nozomi
 * mouse event handling modified
 *
 * Revision 1.26  2002/04/16 23:43:51  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.25  2002/04/16 08:08:55  nozomi
 * fix bug still using NameRecord
 *
 * Revision 1.24  2002/04/16 03:50:10  nozomi
 * retrofit Remove mousePressed() and add *ButtonClicked() by ryo
 *
 * Revision 1.23  2002/04/16 00:39:49  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.22  2002/04/10 07:47:58  nozomi
 * persistentID is misused in ParseNomXml and NameRecordEditPanel, but they'll be fixed later
 *
 * Revision 1.21  2002/04/08 02:04:03  nozomi
 * minor edtition in source code style
 *
 * Revision 1.20  2002/03/29 12:22:44  okawa
 * modify mousePressed()
 *
 * Revision 1.19  2002/03/29 08:04:35  okawa
 * override mousePressed()
 *
 * Revision 1.18  2002/03/26 03:56:38  nozomi
 * use RankChoice to handle additional ranks
 *
 * Revision 1.17  2002/03/11 13:29:15  okawa
 * observe NameRecordEditModel#Rank
 *
 * Revision 1.16  2002/03/10 22:00:18  nozomi
 * add authority relating methods
 *
 * Revision 1.15  2002/03/10 12:03:57  nozomi
 * NameRecordEditModel selection by NameTree
 *
 * Revision 1.14  2002/03/10 09:47:02  nozomi
 * panel design changed
 *
 * Revision 1.13  2002/03/10 08:53:56  nozomi
 * remvoed commented out lines
 *
 * Revision 1.12  2002/03/09 23:37:44  nozomi
 * add incertae sedis
 *
 * Revision 1.11  2002/03/06 00:08:18  nozomi
 * add constructors
 *
 * Revision 1.10  2002/03/05 01:46:42  nozomi
 * modify double click handling
 *
 * Revision 1.9  2002/03/03 23:48:53  nozomi
 * setModel() synchronized
 *
 * Revision 1.8  2002/02/27 23:53:55  nozomi
 * jump to other models by clicks
 *
 * Revision 1.7  2002/02/24 18:13:36  nozomi
 * re-implementation of setModel() to be used switching between models
 *
 * Revision 1.6  2002/02/24 03:51:29  nozomi
 * Implements ItemSelectable
 *
 * Revision 1.5  2002/02/23 21:51:45  nozomi
 * Enable climbing up hierarchy
 *
 * Revision 1.4  2002/02/23 19:18:12  nozomi
 * Rank can be selected by Choice
 * Remove setNameRecordEditModel()
 *
 * Revision 1.3  2002/02/16 21:54:08  nozomi
 * Rank names capitalised, fix inappropriate creation Choice for rank
 *
 * Revision 1.2  2002/02/14 01:51:20  okawa
 * modify getTitle() from static to instance method
 *
 * Revision 1.1  2002/02/07 20:54:17  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.PopupMenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Observer;
import java.util.Observable;
import java.util.StringTokenizer;

import jp.kyasu.awt.Checkbox;
import jp.kyasu.awt.CheckboxGroup;
import jp.kyasu.awt.Choice;
import jp.kyasu.awt.DefaultTextListModel;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextArea;
import jp.kyasu.awt.TextField;
import jp.kyasu.awt.text.TextListView;
import jp.kyasu.awt.TextListModel;

import jp.kyasu.editor.Editor;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.RichText;
import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.Annotation;
import org.nomencurator.NameUsage;
import org.nomencurator.Rank;

import org.nomencurator.broker.NamedObjectBroker;

import org.nomencurator.editor.model.AppearanceEditModel;
import org.nomencurator.editor.model.AnnotationEditModel;
import org.nomencurator.editor.model.AnnotationListModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.NameUsageListModel;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.editor.model.NameTreeModel;
import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.PublicationEditModel;

import org.nomencurator.editor.model.LocaleListModel;

import java.util.Locale;

/**
 * <CODE>Panel</CODE> to view and modify an <CODE>NameUsage</CODE>
 * accompanying to an <CODE>NameUsageEditModel</CODE>.
 *
 * @see org.nomencurator.editor.model.NameUsageEditModel
 * @see org.nomencurator.NameUsage
 *
 * @version 	18 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameUsageEditPanel
    extends NamedObjectEditPanel
    implements NameUsageEditor, 
	       ItemListener, 
	       ItemSelectable, 
	       Observer, 
	       ActionListener //, MouseListener, 
{
    /** Default row number of nameUsageList */
    protected int defaultNameUsageListRows = 5;

    /** <CODE>NameUsageEditModel</CODE> used by this <CODE>Panel</CODE> */
    protected NameUsageEditModel model;

    /** <CODE>Choice</CODE> for rank */
    protected RankChoice rankChoice;

    /** Title of annotation type <CODE>Choice</CODE> */
    protected static String rankTitle = "Rank";

    /** Default rank name */
    protected static String defaultRank = "species";

    /** <CODE>Panel</CODE> to hold name and appearance <CODE>Component</CODE>s */
    protected Panel nameUsagePanel;

    /** Title for the <CODE>Panel</CODE> to hold name <CODE>Component</CODE>s */
    protected static String nameTitle = "Name";


    /** <CODE>TextField</CODE> for name */
    protected TextField name;

    /** <CODE>TextField</CODE> for generic name */
    protected TextField epithet; 

    /** <CODE>Label</CODE> for epithet title */
    protected Label epithetLabel; 

    /** Title of <CODE>epithet</CODE> */
    protected static String epithetTitle = "epithet"; 

    /** <CODE>TextField</CODE> for variety name */
    protected TextField variety; 

    /** <CODE>Label</CODE> for variety title */
    protected Label varietyLabel; 


    /** Title of <CODE>variety</CODE> */
    protected static String varietyTitle = "var."; 

    /** <CODE>TextField</CODE> for form name */
    protected TextField form; 

    /** <CODE>Label</CODE> for form title */
    protected Label formLabel; 

    /** Title of <CODE>form</CODE> */
    protected static String formTitle = "f."; 

    /** <CODE>TextField</CODE> for higher NameUsage */
    protected TextField higher;

    /** Title of <CODE>TextField</CODE> for higher NameUsage */
    //    protected static String higherTitle = "Member of";
    protected static String higherTitle = "Assigned to";

    /** <CODE>Checkbox</CODE> represents isIncertaeSedis() of the model */
    protected Checkbox incertaeSedis;

    /** Title of <CODE>Checkbox</CODE> represents isIncertaeSedis() of the model */
    protected static String incertaeSedisTitle = "incertae sedis";

    /** <CODE>Checkbox</CODE> represents isType() of the model */
    protected Checkbox type;

    /**
     * <CODE>Choice</CODE> to select type of type.
     * It shouldn't be enabled if "rank" is not specimen.
     */
    protected Choice typeChoice;

    /** Title of <CODE>Checkbox</CODE> represents isType() of the model */
    protected static String typeTitle = "type";

    /** <CODE>TableList</CODE> for lower NameUsages */
    protected TableList lowerList;

    /** Title of <CODE>lowerList</CODE> */
    //    protected static String lowerListTitle = "Member Taxa";
    protected static String lowerListTitle = "Assigned";

    /** <CODE>TextField</CODE> for authority */
    protected TextField authority;

    /** Title of <CODE>authority</CODE> */
    protected static String authorityTitle = "Authority";

    /** <CODE>TableList</CODE> representing annotatioions */
    protected TableList annotation;

    /** <CODE>BorderedPanel</CODE> containing annotation table */
    protected BorderedPanel annotationPanel;

    /** Title of <CODE>BorderedPanel</CODE> containing annotation table */
    protected static String annotationPanelTitle = "Annotations";

    /** <CODE>Vector</CODE> of annotation editors */
    protected Vector annotationEditors;

    /** <CODE>AppearanceEditPanel</CODE> where the <CODE>NameUsage</CODE> appeared */
    protected AppearanceEditPanel appearanceEditPanel;

    /** <CODE>TextField</CODE> representing appearance */
    protected TextField appearance;

    /** Title of <CODE>TextField</CODE> representing appearance */
    //    protected static String appearanceTitle = "Appearance";
    protected static String appearanceTitle = "Citation";

    /** <CODE>TextArea</CODE> representing appearance */
    protected TextArea note;

    /** <CODE>Label</CODE> for note title */
    protected Label noteLabel; 

    /** Title of <CODE>TextField</CODE> representing note */
    protected static String noteTitle = "Note";


    /** Listeners of this <CODE>Component</CODE> */
    transient protected ItemListener itemListener;

    /** <CODE>MenuItem</CODE> */
    protected MenuItem changeHigherTaxon;

	/**
	 * 
	 */
	protected MenuItem createNewLowerMenuItem;

	/**
	 * 
	 */
    protected static String createNewLowerTitle = "create new lower taxon";

	/**
	 * 
	 */
	protected MenuItem createNewAnnotationMenuItem;

	/**
	 * 
	 */
    protected static String createNewAnnotationTitle = "create new annotation";

	/**
	 * 
	 */
	protected MenuItem deleteAnnotationMenuItem;

	/**
	 * 
	 */
    protected static String deleteAnnotationTitle = "delete annotation";

	/**
	 * 
	 */
	protected MenuItem deleteTaxonMenuItemForNameTree;

	/**
	 * 
	 */
	protected MenuItem deleteTaxonMenuItemForLowerList;

	/**
	 * 
	 */
    protected static String deleteTaxonTitle = "cut taxon";

	/**
	 * 
	 */
	protected MenuItem pasteTaxonMenuItemForNameTree;

	/**
	 * 
	 */
	protected MenuItem pasteTaxonMenuItemForLowerList;

	/**
	 * 
	 */
    protected static String pasteTaxonTitle = "paste taxon";

    /** cut buffer for lower taxon */
    protected NameUsageEditModel cutBuffer = null;

    /** <CODE>ItemEvent</CODE> to be passed to listeners */
    protected ItemEvent itemEvent;

    protected static NameUsageEditModel dummyModel;

    /** */
    protected NameTree nameTree;

    /** <CODE>Chexboxes</CODE> of name type */ 
    protected Checkbox              scientificName;
    protected static String         scientificNameTitle = "scientific";
    protected Checkbox              vernacularName; 
    protected static String         vernacularNameTitle = "vernacular";;

    /** <CODE>Choice</CODE> of locale type */ 
    protected Choice localeTypeSelector;

    /** <CODE>Label</CODE> string for type of locale */ 
    protected static String localeTypeSelectorTitle = "Code/Language";


    /**
     * Returns default rank name
     *
     * @return String representing name of default rank
     */
    public static String getDefaultRank()
    {
	return defaultRank;
    }

    /**
     * Sets default rank name
     *
     * @param rankName <CODE>String</CODE> representing name of default rank
     */
    public static void setDefaultRank(String rankName)
    {
	defaultRank = rankName;
    }

    /**
     * Creates an <CODE>NameUsageEditPanel</CODE> with new <CODE>NameUsageEditModel</CODE>
     */
    public NameUsageEditPanel()
    {
	this(new NameUsageEditModel(Rank.get(defaultRank)));
    }

    /**
     * Creates an <CODE>NameUsageEditPanel</CODE> associating with given <CODE>model</CODE>.
     *
     * @param model <CODE>NameUsageEditModel</CODE> to be edited by this model
     */
    public NameUsageEditPanel(NameUsageEditModel model)
    {
	this(model, true);
    }

    /**
     * Creates an <CODE>NameUsageEditPanel</CODE> associating with given <CODE>model</CODE>.
     *
     * @param model <CODE>NameUsageEditModel</CODE> to be edited by this model
     * @param editable boolean determining whether this object may modify model contents or not
     */
    public NameUsageEditPanel(NameUsageEditModel model, boolean editable)
    {
	//this(model, new AppearanceEditPanel(model.getAppearanceEditModel()), editable);
	this(model, null, editable);
    }

    /**
     * Creates an <CODE>NameUsageEditPanel</CODE> associating with given <CODE>model</CODE>.
     *
     * @param model <CODE>NameUsageEditModel</CODE> to be edited by this model
     */
    public NameUsageEditPanel(NameUsageEditModel model, 
			       AppearanceEditPanel appearance) 
    {
	this(model, appearance, true);
    }

    /**
     * Creates an <CODE>NameUsageEditPanel</CODE> associating with given <CODE>model</CODE>.
     *
     * @param model <CODE>NameUsageEditModel</CODE> to be edited by this model
     * @param editable boolean determining whether this object may modify model contents or not
     */
    public NameUsageEditPanel(NameUsageEditModel model, 
			       AppearanceEditPanel appearance,
			       boolean editable) 
    {
	super(model, editable);
	name.requestFocus();
    }

    /**
     * Adds components to this <CODE>Panel</CODE>
     *
     */
    protected void addModelComponents()
    {
	add(nameUsagePanel);
	//	add(annotationPanel);
    }

    /**
     * Removes components from this <CODE>Panel</CODE>
     *
     */
    protected void removeModelComponents()
    {
	remove(annotationPanel);
	remove(nameUsagePanel);
    }
    
    /**
     * Creates components corresponding to the model
     *
     */
    protected void createModelComponents()
    {
	model = (NameUsageEditModel)getModel();
	createAnnotationPanel();
	createNameComponents();
    }

    /**
     * Creates citation components corresponding to the model
     *
     */
    protected void createNameComponents()
    {
	//rankChoice = new Choice(model.getRankModel());
	rankChoice = new RankChoice();
	rankChoice.addItemListener(this);
	Rank rank =  model.getRank();
	if(rank != null)
	    rankChoice.select(rank.getName());
	else
	    rankChoice.select(defaultRank);

	name = new TextField(model.getNameModel(), 20);
	name.addTextListener(this);
	epithet = new TextField(model.getEpithetModel(), 10);
	epithet.setEnabled(false);
	epithetLabel = new Label(epithetTitle, Label.RIGHT);
	epithetLabel.setEnabled(false);
	variety = new TextField(model.getVariety(), 5);
	variety.setEnabled(false);
	varietyLabel = new Label(varietyTitle, Label.RIGHT);
	varietyLabel.setEnabled(false);
	form = new TextField(model.getForm(), 5);
	form.setEnabled(false);
	formLabel = new Label(formTitle, Label.RIGHT);
	formLabel.setEnabled(false);

	authority = new TextField(model.getAuthority(), 20);
	authority.addMouseListener(this);
	appearance = new TextField(model.getAppearanceEditModel().getPublicationTextModel(), 20);
//	appearance = new TextField(20);
	appearance.addMouseListener(this);

	note = new TextArea(model.getNoteModel(), 5, 20);
	note.addTextListener(this);

	//note = new TextArea(model.getNote());
	noteLabel = new Label(noteTitle, Label.RIGHT);
//	noteTitle.setEnabled(false);

	higher = new TextField(model.getHigher(), 20);
	higher.addMouseListener(this);
	PopupMenu pm = higher.getPopupMenu();
	pm.addSeparator();
	changeHigherTaxon = new MenuItem("Change Higher Taxon");
	changeHigherTaxon.addActionListener(this);
	pm.add(changeHigherTaxon);
	higher.setPopupMenu(pm);
	
	incertaeSedis = new Checkbox(incertaeSedisTitle, model.isIncertaeSedis());
	incertaeSedis.addItemListener(this);

	type = new Checkbox(typeTitle, model.isType());
	type.addItemListener(this);
	
	typeChoice = new Choice(model.getTypeListModel());
	typeChoice.addItemListener(this);
	typeChoice.setEnabled(false);

	lowerList = new TableList(model.getLower(),
				  5,
				  model.getLower().getTitle());
	lowerList.addMouseListener(this);
	lowerList.setScrollbarDisplayPolicy(jp.kyasu.awt.ScrollPanel.SCROLLBARS_ALWAYS);
	setLowerListPopupMenu();

	//localeTypeSelector = new Choice(new LocaleListModel());
	localeTypeSelector = new Choice();
	localeTypeSelector.getModel().replaceItems(0, 0, LocaleListModel.getLocaleNames());
	localeTypeSelector.addItemListener(this);
	localeTypeSelector.setSize(localeTypeSelector.getPreferredSize());
	TextListModel l = localeTypeSelector.getModel();
	l.replaceItems(0, l.getItemCount(), LocaleListModel.getCodeNames());
	//	localeTypeSelector.setModel(LocaleListModel.getCodes());

	scientificName = new Checkbox(scientificNameTitle);
	scientificName.setCheckboxGroup(new CheckboxGroup());
	vernacularName = new Checkbox(vernacularNameTitle);
	vernacularName.setCheckboxGroup(scientificName.getCheckboxGroup());
	vernacularName.addItemListener(this);
	scientificName.setState(true);
	scientificName.addItemListener(this);

	nameUsagePanel = new Panel();

	/*
	nameUsagePanel.add(new Label(localeTypeSelectorTitle),
			   localeTypeSelector,
			   GridBagConstraints.NONE);
	*/
	nameUsagePanel.add(new Label(localeTypeSelectorTitle),
			   new Component[]{
			       scientificName,
			       vernacularName,
			       localeTypeSelector,
			       new Panel()},
			   new int[]{GridBagConstraints.NONE,
				     GridBagConstraints.NONE,
				     GridBagConstraints.NONE,
				     GridBagConstraints.HORIZONTAL});

	nameUsagePanel.add(new Label(rankTitle), rankChoice, GridBagConstraints.NONE);

	nameUsagePanel.add(new Label(nameTitle, Label.RIGHT), 
			    name, 
			    GridBagConstraints.HORIZONTAL);
	nameUsagePanel.add(authorityTitle, authority, GridBagConstraints.HORIZONTAL);
	nameUsagePanel.add(appearanceTitle, appearance, GridBagConstraints.HORIZONTAL);
	
	nameUsagePanel.add(new Label(higherTitle), 
			    higher, GridBagConstraints.HORIZONTAL);
	/*
	nameUsagePanel.add(new Label(""), 
			   new Component[]{type, incertaeSedis, new Panel()},
			   new int[]{GridBagConstraints.NONE,
				     GridBagConstraints.NONE,
				     GridBagConstraints.HORIZONTAL});
	*/
	nameUsagePanel.add(new Label(""), 
			   new Component[]{type, typeChoice, incertaeSedis, new Panel()},
			   new int[]{GridBagConstraints.NONE,
				     GridBagConstraints.NONE,
				     GridBagConstraints.NONE,
				     GridBagConstraints.HORIZONTAL});

	nameUsagePanel.add(new Label(lowerListTitle, Label.NORTHEAST),
			   lowerList, GridBagConstraints.HORIZONTAL);

	nameUsagePanel.add(new Label(annotationPanelTitle),
			   annotation, GridBagConstraints.HORIZONTAL);
	nameUsagePanel.add(noteTitle, note, GridBagConstraints.HORIZONTAL);

	//this method may modify other components, so call at last
	setEnabledBy(Rank.get((String)rankChoice.getSelectedItem()));
    }

    /**
     * Creates annotator components corresponding to the model
     *
     */
    protected void createAnnotationPanel()
    {
	annotation = new TableList(model.getAnnotationList(),
				   5,
				   model.getAnnotationList().getTitle());
	annotation.addMouseListener(this);
	/*
	annotationPanel = new BorderedPanel(new VTitledPaneBorder(annotationPanelTitle));
	annotationPanel.add(annotation);
	*/
	createNewAnnotationMenuItem = new MenuItem(createNewAnnotationTitle);
	createNewAnnotationMenuItem.addActionListener(this);
	deleteAnnotationMenuItem = new MenuItem(deleteAnnotationTitle);
	deleteAnnotationMenuItem.addActionListener(this);
	PopupMenu pm = annotation.getPopupMenu();
	pm.addSeparator();
	pm.add(createNewAnnotationMenuItem);
	pm.add(deleteAnnotationMenuItem);
	annotation.setPopupMenu(pm);
    }

    /**
     * Sets <CODE>ed</CODE> as <CODE>Editor</CODE> of <CODE>TextComponent</CODE>s
     * to provide <CODE>Text</CODE> handling using GUI.
     *
     * @param ed <CODE>Editor</CODE> to be linked to <CODE>TextComponent</CODE>s
     * of this
     */
    public void setEditor(Editor ed)
    {
	if(focusedEditor == ed)
	    return;

	if(focusedEditor != null) {
	    focusedEditor.unlisten(name);
	    focusedEditor.unlisten(authority);
	    focusedEditor.unlisten(appearance);
	    focusedEditor.unlisten(note);
	}

	focusedEditor = ed;

	if(focusedEditor != null) {
	    focusedEditor.listen(name);
	    focusedEditor.listen(authority);
	    focusedEditor.listen(appearance);
	    focusedEditor.listen(note);
	}

    }



    /**
     * Gets <CODE>NameUsageEditModel</CODE> accompanying with this editor
     *
     * @return NameUsageEditModel accompanying with this editor
     */
    public NameUsageEditModel getNameUsageEditModel()
    {
	return (NameUsageEditModel)getModel();
    }

    /**
     * Setups components to use given <CODE>model</CODE>.
     * This method is called from setModel(ObjectEditModel)
     * internally.
     */
    protected void setComponents(ObjectEditModel objectEditModel)
    {
	model = (NameUsageEditModel)objectEditModel;

	boolean invalidated = false;

	Rank rank = model.getRank();

	if(rank != null) {
	    rankChoice.select(rank.getName());
	    setEnabledBy(rank);
	}
	name.setModel(model.getNameModel());
	epithet.setModel(model.getEpithetModel());
	variety.setModel(model.getVariety());
	form.setModel(model.getForm());
	authority.setModel(model.getAuthorityTextModel());
	appearance.setModel(model.getAppearanceEditModel().getPublicationTextModel());

	note.setModel(model.getNoteModel());
	//	note.invalidate();
	
	Locale localeObject = model.getLocale();
	String language = localeObject.getLanguage();
	String country = localeObject.getCountry();
   	String localeName = LocaleListModel.getLocaleName(language + country);
	this.localeTypeSelector.select(localeName);

	higher.setModel(model.getHigher());

	lowerList.setModel(model.getLower());

	if(lowerList.getItemCount() >= lowerList.getRows()) {
	    lowerList.invalidate();
	    invalidated = true;
	}

	incertaeSedis.setState(model.isIncertaeSedis());

	type.setState(model.isType());

	annotation.setModel(model.getAnnotationList());
	if(annotation.getItemCount() >= annotation.getRows()) {
	    annotation.invalidate();
	    invalidated = true;
	}

	if(invalidated) {
	    Container c = getParent();
	    if(c != null)
		getParent().validate();
	}

	if(itemListener != null) {
	    if(itemEvent == null)
		itemEvent = 
		    new ItemEvent(this, 
				  ItemEvent.ITEM_STATE_CHANGED,
				  this,
				  ItemEvent.ITEM_STATE_CHANGED
				  );
	    itemListener.itemStateChanged(itemEvent);
	}

    }

    /**
     * A utility method to get <CODE>NameUsage</CODE> under edition
     *
     * @return Annotation under edition
     */
    public NameUsage getNameUsage()
    {
	return (NameUsage)getObject();
    }

    /**
     * A utility method to set <CODE>annotation</CODE> as
     * target of edition by accompanying <CODE>NameUsageEditModel</CODE>
     *
     * @param annotation to be set as target <CODE>NameUsage</CODE>
     */
    public void setNameUsage(NameUsage nameUsage)
    {
	setObject(nameUsage);
    }

    /**
     * Creates an empty <CODE>NameUsageEditModel</CODE>.
     */
    protected ObjectEditModel createObjectEditModel()
    {
	if(appearanceEditPanel == null)
	    return new NameUsageEditModel();
	return new NameUsageEditModel(appearanceEditPanel.getAppearanceEditModel());
    }

    /**
     * Returns <CODE>AppearanceEditPanel</CODE> linked to this object
     *
     * @return <CODE>AppearanceEditPanel</CODE> being linked to this
     */
    public AppearanceEditPanel getAppearanceEditPanel()
    {
	if(appearanceEditPanel == null)
	    setAppearanceEditPanel(new AppearanceEditPanel(getNameUsageEditModel().getAppearanceEditModel()));

	return appearanceEditPanel;
    }

    /**
     * Sets <CODE>pane</CODE> as <CODE>AppearanceEditPanel</CODE>
     * linked to this object
     *
     * @param panel <CODE>AppearanceEditPanel</CODE> to be linked
     */
    public void setAppearanceEditPanel(AppearanceEditPanel panel)
    {
	if(appearanceEditPanel == panel)
	    return;

	if(appearanceEditPanel != null)
	    appearanceEditPanel.setNameUsageEditPanel(null);

	appearanceEditPanel = panel;
	if(appearanceEditPanel != null)
	    appearanceEditPanel.setNameUsageEditPanel(this);
    }

    /**
     * Clears contents
     */
    public void clear()
    {
    }

    /**
     * Returns clone of this object
     */
    public Object clone()
    {
	return new NameUsageEditPanel((NameUsageEditModel)model.clone(), editable);
    }

    /**
     * Invoked when an item's state has been changed.
     * @see java.awt.event.ItemListener
     */
    public void itemStateChanged(ItemEvent e)
    {
	Object source = e.getSource();
	if(source == rankChoice){
	    setModified(true);
	    Rank rank = Rank.get((String)rankChoice.getSelectedItem());
	    if(rank.equals(model.getRank()))
		return;

	    model.setRank(rank);
	    setEnabledBy(rank);
	    if(rank == Rank.SPECIMEN) {
		name.delete_to_start_of_line();
		String specimenType = model.getNameUsage().getTypeOfType();
		if(specimenType == null)
		    specimenType = NameUsage.HOLOTYPE;
		typeChoice.select(specimenType);
		model.setTypeOfType(specimenType);
	    }

	    if(focusedEditor != null)
		focusedEditor.setLastFocus();
	}
	else if(source == nameTree) {
	    NameUsageEditModel selection = nameTree.getSelectedModel();
	    if(selection != null) {
		setModel(selection);
		AppearanceEditPanel appearanceEditPanel = getAppearanceEditPanel();
		AppearanceEditModel appearanceEditModel = selection.getAppearanceEditModel();
		appearanceEditPanel.setModel(appearanceEditModel);
		PublicationEditPanel publicationEditPanel = appearanceEditPanel.getPublicationEditPanel();
		PublicationEditModel publicationEditModel = appearanceEditModel.getPublicationEditModel();
		publicationEditPanel.setModel(publicationEditModel);
		updateView();
	    }
	}
	else if(source == scientificName ||
		source == vernacularName) {
	    TextListModel l = localeTypeSelector.getModel();
	    if(scientificName.getState()) {
		l.replaceItems(0, l.getItemCount(), LocaleListModel.getCodeNames());
	    }
	    else {
		l.replaceItems(0, l.getItemCount(), LocaleListModel.getLocaleNames());
	    }
	}
	else if(source == localeTypeSelector) {
	    setModified(true);
	    NameUsageEditModel nuModel = (NameUsageEditModel)this.getModel();
		
	    if(scientificName.getState()) {
		nuModel.setLocale(new Locale((String)localeTypeSelector.getSelectedItem(), ""));
	    }
	    else {
		TextListModel localeListModel = localeTypeSelector.getModel();
		String language = LocaleListModel.getLanguage(localeTypeSelector.getSelectedIndex());
		String country = LocaleListModel.getCountry(localeTypeSelector.getSelectedIndex());
	    
		nuModel.setLocale(new Locale(language, country));
	    }
	    
	    //String ssss = LocaleListModel.getLocaleName(language + country);
	    //int a = 9; a++;
	}
	else if(source == incertaeSedis) {
	    setModified(true);
	    boolean state = incertaeSedis.getState();
	    if(state) {
		type.setState(false);
		model.setType(false);
	    }
	    model.setIncertaeSedis(state);
	}
	else if(source == type) {
	    setModified(true);
	    boolean state = type.getState();
	    if(state) {
		incertaeSedis.setState(false);
		model.setIncertaeSedis(false);
	    }
	    if(Rank.SPECIMEN == Rank.get((String)rankChoice.getSelectedItem()))
		typeChoice.setEnabled(state);
	    model.setType(state);
	    model.updateSummary();
	}
	else if(source == typeChoice) {
	    model.setTypeOfType((String)typeChoice.getSelectedItem());
	    setModified(true);
	}
    }

    /**
     * Enables/disables according to <CODE>rank</CODE>
     *
     * @param rank <CODE>Rank</CODE> of the <CODE>NameUsage</CODE>
     */
    protected void setEnabledBy(Rank rank)
    {
	if(rank == null)
	    return;

	epithet.setEnabled(false);
	epithetLabel.setEnabled(false);
	variety.setEnabled(false);
	varietyLabel.setEnabled(false);
	form.setEnabled(false);
	formLabel.setEnabled(false);
	typeChoice.setEnabled(false);
	incertaeSedis.setEnabled(true);

	if(Rank.GENUS.isHigher(rank)) {
	    epithet.setEnabled(true);
	    epithetLabel.setEnabled(true);
	    if(Rank.SPECIES.isHigher(rank)) {
		variety.setEnabled(true);
		varietyLabel.setEnabled(true);
		if(Rank.VARIETY.isHigher(rank)) {
		    form.setEnabled(true);
		    formLabel.setEnabled(true);
		}
	    }
	}

	if(rank == Rank.SPECIMEN) {
	    type.setState(true);
	    incertaeSedis.setState(false);
	    incertaeSedis.setEnabled(false);
	    typeChoice.setEnabled(true);
	}
    }

    public void mouseDoubleClicked(MouseEvent e)
    {
	Object source = e.getSource();
	if(source != higher &&
	   source != lowerList &&
	   source != authority &&
	   source != annotation &&
	   source != appearance)
	    return;
	   
	model.updateSummary();
	TextListView view = lowerList.getView();

	Rank rank = model.getRank();
	/*
	if(rank == null) {
	    model.setRank(Rank.SPECIMEN);
	    rank = Rank.SPECIMEN;
	}
	*/

	model.updateSummary();
	if(source == higher) {
	    NameUsageEditModel higherModel = model.getHigherModel();
	    if(higherModel != null) {
		higherModel.getLower().update(model);
	    }
	    else{
		higherModel = new NameUsageEditModel(((NameUsageEditModel)getModel()).getAppearanceEditModel());
		if(rank == Rank.SPECIMEN)
		    rank = Rank.SPECIES;
		else if (rank != null)		
		    rank = rank.getNonOptionalHigherRank();

		higherModel.setRank(rank);
		if(Rank.FAMILY.isHigher(rank)) {
		    int nameComponents = 0;
		    if(rank.isHigher(Rank.SPECIES))
			nameComponents = 1;
		    else if(rank.isHigher(Rank.VARIETY))
			nameComponents = 2;
		    else 
			nameComponents = 3;
		    StringTokenizer nameTokens = 
			new StringTokenizer(model.getNameText().toString());
		    if(nameTokens.countTokens() > 0) {
			if(nameTokens.countTokens() < nameComponents)
			    nameComponents = nameTokens.countTokens();
			Text nameText = higherModel.getNameText();
			for(int i = 0; i < nameComponents; i++) {
			    if(i > 0)
				nameText.append(' ');
			    nameText.append(nameTokens.nextToken());
			}
		    }
		}
		model.setHigherEditModel(higherModel);
		higherModel.saveAttributes();
	    }
	    setModel(higherModel);
	}
	else if(source == lowerList) {
	    selectLowerTaxon(isEditable()
			     && (lowerList.getSelectedModel() == lowerList.getDummyModel()
				 || e.getY() >= lowerList.getLastBaseLine()));
	}
	else if (source == authority) {
		// regist authority.
		NameUsageSearchDialog dialog = new NameUsageSearchDialog(this.getFrame(), "Search authority", true);
		dialog.show();
		String selectedOid = dialog.getSelectedOid();
		if (dialog.isOKButtonPressed() && selectedOid != null || dialog.isSelfButtonPressed()) {
			NameUsageEditModel nameUsageEditModel;
			if (dialog.isOKButtonPressed()) {
				// If the OK button is pressed,
				// set the selected NameUsageEditModel to authority.
				NamedObjectBroker broker = NamedObjectBroker.getInstance();
				NameUsage nameUsage = new NameUsage();
				nameUsage.setPersistentID(selectedOid);
				nameUsageEditModel =
					broker.getNamedObjectEditModelTree(nameUsage, 1, 1);
			} else {
				// If the self button is pressed, 
				// set the current NameUsageEditModel to authority.
				nameUsageEditModel = model;
			}
			model.setAuthorityEditModel(nameUsageEditModel);
			authority.setRichText(model.getAuthorityRichText());
		}
	} else if (source == annotation) {
		selectAnnotation(isEditable() &&
							(annotation.getSelectedModel() == annotation.getDummyModel() ||
							e.getY() >=  annotation.getLastBaseLine()));
	}
	else if (source == appearance) {
	    getTabbedPane().setSelectedComponent(appearanceEditPanel);
	}
	updateView();
    }

    // <ItemSelecatable implementation>
    /**
     * Adds the specified item listener to receive item events from this list.
     *
     * @param l the item listener.
     */
    public synchronized void addItemListener(ItemListener l)
    {
	itemListener = AWTEventMulticaster.add(itemListener, l);
	enableEvents(0); // mark newEventsOnly
    }

    /**
     * Removes the specified item listener so that it no longer receives
     * item events from this list.
     * @param l the item listener.
     */
    public synchronized void removeItemListener(ItemListener l)
    {
	itemListener = AWTEventMulticaster.remove(itemListener, l);
    }

    /**
     * Returns the selected items on the list in an array of Objects.
     * @see java.awt.ItemSelectable
     */
    public Object[] getSelectedObjects()
    {
	return new Object[]{model};
    }
    // </ItemSelecatable implementation>

    public void setNameTree(NameTree tree)
    {
	if(nameTree == tree)
	    return;

	if(nameTree != null) {
	    nameTree.removeItemListener(this);
	    removeItemListener(nameTree);
	}

	nameTree = tree;

	if(nameTree != null) {
	    nameTree.addItemListener(this);
	    addItemListener(nameTree);

	    int index = ((NameTreeModel)nameTree.getModel()).getRowForObject(this);
	    if(index == -1)
		index = 0;
	    nameTree.select(index);

	    //setNameTreePopupMenu();
	}
    }
    
    public void setNameTreeModel(NameTreeModel nameTreeModel) {
	// set model to NameTree.
	if (nameTreeModel != null) {
	    nameTree.invalidate();
	    nameTree.setModel(nameTreeModel);
	    nameTree.validate();
	}
	// add menu item.
	//setNameTreePopupMenu();
    }
    
    public void setNameTreePopupMenu() {
	PopupMenu pm = nameTree.getPopupMenu();
	// add delete lower taxon menu.
	pm.addSeparator();
	deleteTaxonMenuItemForNameTree = new MenuItem(deleteTaxonTitle);
	deleteTaxonMenuItemForNameTree.addActionListener(this);
	pm.add(deleteTaxonMenuItemForNameTree);
	nameTree.setPopupMenu(pm);
	// add paste lower taxon menu.
	pasteTaxonMenuItemForNameTree = new MenuItem(pasteTaxonTitle);
	pasteTaxonMenuItemForNameTree.addActionListener(this);
	pm.add(pasteTaxonMenuItemForNameTree);
	nameTree.setPopupMenu(pm);
    }
    
	public void setLowerListPopupMenu() {
		PopupMenu pm = lowerList.getPopupMenu();
		// add create new lower menu.
		pm.addSeparator();
		createNewLowerMenuItem = new MenuItem(createNewLowerTitle);
		createNewLowerMenuItem.addActionListener(this);
		pm.add(createNewLowerMenuItem);
		lowerList.setPopupMenu(pm);
		pm.addSeparator();
		// add delete lower taxon menu.
		deleteTaxonMenuItemForLowerList = new MenuItem(deleteTaxonTitle);
		deleteTaxonMenuItemForLowerList.addActionListener(this);
		pm.add(deleteTaxonMenuItemForLowerList);
		lowerList.setPopupMenu(pm);
		// add paste lower taxon menu.
		pasteTaxonMenuItemForLowerList = new MenuItem(pasteTaxonTitle);
		pasteTaxonMenuItemForLowerList.addActionListener(this);
		pm.add(pasteTaxonMenuItemForLowerList);
		lowerList.setPopupMenu(pm);
	}
    
    public NameTree getNameTree()
    {
	return nameTree;
    }

    public void update(Observable obs, Object arg)
    {
	if(arg instanceof Rank) {
	    rankChoice.select(((Rank)arg).getName());
	}
	else if(arg == model.getAppearanceEditModel()) {
	    appearance.setModel(model.getAppearanceEditModel().getSummaryTextModel());
	}
	super.update(obs, arg);
    }

    /**
     * Invoked when the mouse has been clicked on the OK button.
     */
//    public void okButtonClicked() {
//	super.okButtonClicked();
//	// link AppearanceEditModel to this
//	AppearanceEditModel appearanceEditModel = (AppearanceEditModel)this.getAppearanceEditPanel().getModel();
//	appearanceEditModel.addNameUsageEditModel(model);
//	// link higher NameUsageEditModel to this
//	NameUsageEditModel higherEditModel = this.model.getHigherModel();
//	if (higherEditModel != null) higherEditModel.addLowerEditModel(this.model);
//	// link lower NameUsageEditModel to this
//	Vector lowerEditModels = this.model.getLowerEditModels();
//	if (lowerEditModels != null) {
//	    for (int i=0; i<lowerEditModels.size(); i++) {
//		NameUsageEditModel lowerEditModel = (NameUsageEditModel)lowerEditModels.elementAt(i);
//		if (lowerEditModel != null) lowerEditModel.setHigherEditModel(this.model);
//	    }
//	}
//    }
	
    /**
     * Invoked when the mouse has been clicked on the New button.
     */
    public void newButtonClicked() {
	super.newButtonClicked();
	//	getNameTree().setModel(new NameTreeModel((NameUsageEditModel) objectEditModel));
	NameUsageEditModel currentEditModel = (NameUsageEditModel)objectEditModel;
	NameUsageEditModel previousEditModel = (NameUsageEditModel)previousModel;
	currentEditModel.setAppearanceEditModel(previousEditModel.getAppearanceEditModel());
	currentEditModel.getAppearanceEditModel().addNameUsageEditModel(currentEditModel);
	currentEditModel.setRank(rankChoice.getSelectedItem()); //?
	updateView();
    }
    
    /**
     * Invoked when the mouse has been clicked on the Cancel button.
     */
//    public void cancelButtonClicked()
//    {
//	NameUsageEditModel currentEditModel = (NameUsageEditModel)objectEditModel;
//	NameUsageEditModel previousEditModel = (NameUsageEditModel)previousModel;
//	previousEditModel.setAppearanceEditModel(currentEditModel.getAppearanceEditModel());
//	previousEditModel.setHigherEditModel(currentEditModel.getHigherModel());
//	previousEditModel.setLowerEditModels(currentEditModel.getLowerEditModels());
//	super.cancelButtonClicked();
//    }
    
    /**
     * Invoked when the mouse has been clicked on the Copy button.
     */
    public void copyButtonClicked() {
	super.copyButtonClicked();
	getNameTree().setModel(
			       new NameTreeModel((NameUsageEditModel) objectEditModel));
    }
    
    public void updateView() {
	getNameUsageEditModel().updateList();
	//		appearance.setModel(model.getCitationTextEditModel());
    }
	
    public void actionPerformed(ActionEvent event) {
	
	Object source = event.getSource();
	
	if(source == changeHigherTaxon) {
	    HigherNameUsageSearchDialog dialog = new HigherNameUsageSearchDialog(this.getFrame(), "Set HigherEditModel", true);
	    
	    PublicationEditModel publicationEditModel = this.getNameUsageEditModel().getAppearanceEditModel().getPublicationEditModel();
	    int appNum = publicationEditModel.getAppearanceEditModels().size();
	    for(int i = 0; i < appNum; i++) {
		AppearanceEditModel appearanceEditModel = (AppearanceEditModel)publicationEditModel.getAppearanceEditModels().elementAt(i);
		int nameNum = appearanceEditModel.getNameUsageEditModels().size();
		for(int j = 0; j < nameNum; j++) {
		    if(this.getNamedObjectEditModel() != (NameUsageEditModel)appearanceEditModel.getNameUsageEditModels().elementAt(j)) {
			dialog.addModel((NameUsageEditModel)appearanceEditModel.getNameUsageEditModels().elementAt(j));
		    }
		}
	    }
	    
	    dialog.show();
	    
	    NameUsageEditModel selectedEditModel = dialog.getSelectedModel();
	    NameUsageEditModel currentEditModel = this.getNameUsageEditModel();
	    if(dialog.isOK() && selectedEditModel != null) {
		
		NameUsageEditModel currentHigherEditModel = currentEditModel.getHigherModel();
		if(currentHigherEditModel != null && currentHigherEditModel.getLowerEditModels() != null) {
		    currentHigherEditModel.getLowerEditModels().remove(currentEditModel);
		    currentHigherEditModel.getLower().removeModel(currentEditModel);
		}
		if(selectedEditModel.getLowerEditModels() == null) {
		    selectedEditModel.setLowerEditModels(new Vector());
		}
		
		selectedEditModel.getLowerEditModels().add(currentEditModel);
		currentEditModel.setHigherEditModel(selectedEditModel);
		this.setModel(currentEditModel);
		
		setNameTreeModel(new NameTreeModel(nameTree.getNode(0)));
	    }
	} else if (source == createNewLowerMenuItem) {
	    selectLowerTaxon(true);
	} else if (source == createNewAnnotationMenuItem) {
	    selectAnnotation();
	} else if (source == deleteAnnotationMenuItem) {
	    AnnotationListModel annotationListModel = (AnnotationListModel) annotation.getModel();
	    AnnotationEditModel annotationEditModel = (AnnotationEditModel)annotationListModel.getSelectedModel();
	    getNameUsageEditModel().removeAnnotation(annotationEditModel);
	    if(annotation.getRows() == annotationListModel.getItemCount() + 1) {
		annotation.invalidate();
		annotation.enableDummyModel(isEditable());
		annotation.validate();
	    }
	} else if (source == deleteTaxonMenuItemForNameTree || source == deleteTaxonMenuItemForLowerList) {
	    if (jp.kyasu.awt.Dialog.confirm(getFrame(), "Do you really cut taxons below the current taxon?")) {
				// remove link from higher NameUsageEditModel.
		NameUsageEditModel nameUsageEditModel = null;
		if (source == deleteTaxonMenuItemForNameTree) {
		    nameUsageEditModel = nameTree.getSelectedModel();
		} else if (source == deleteTaxonMenuItemForLowerList) {
		    nameUsageEditModel = (NameUsageEditModel)lowerList.getSelectedModel();
		}
		if(nameUsageEditModel == null)
		    return; //TBD: right?
		NameUsageEditModel higher = nameUsageEditModel.getHigherModel();
		if (higher != null) {
		    setModel(higher);
		    higher.removeLower(nameUsageEditModel);
		}
				// remove link from Appearance.
		Vector lowers = nameUsageEditModel.getLowerEditModelsBelowCurrent();
		AppearanceEditModel appearanceEditModel = nameUsageEditModel.getAppearanceEditModel();
		if (appearanceEditModel != null) {
		    appearanceEditModel.removeNameUsageEditModel(nameUsageEditModel);
		    if (lowers != null && lowers.size() > 0)
			for (Enumeration e = lowers.elements(); e.hasMoreElements(); )
			    appearanceEditModel.removeNameUsageEditModel((NameUsageEditModel)e.nextElement());
		}
				// save to cut buffer
		cutBuffer = nameUsageEditModel;
		setNameTreeModel(new NameTreeModel(nameTree.getNode(0)));
	    }
	} else if (source == pasteTaxonMenuItemForNameTree || source == pasteTaxonMenuItemForLowerList) {
	    if (cutBuffer != null) {
		NameUsageEditModel nameUsageEditModel = null;
		if (source == pasteTaxonMenuItemForNameTree) {
		    nameUsageEditModel = nameTree.getSelectedModel();
		} else if (source == pasteTaxonMenuItemForLowerList) {
		    nameUsageEditModel = (NameUsageEditModel)getModel();
		}
		if (nameUsageEditModel != null) {
		    nameUsageEditModel.addLower(cutBuffer);
		}
		Vector lowers = cutBuffer.getLowerEditModelsBelowCurrent();
		if (lowers == null)
		    lowers = new Vector();
		lowers.addElement(cutBuffer);
		AppearanceEditModel appearanceEditModel = nameUsageEditModel.getAppearanceEditModel();
		if (lowers != null && lowers.size() > 0)
		    for (Enumeration e = lowers.elements(); e.hasMoreElements(); )
			appearanceEditModel.addNameUsageEditModel((NameUsageEditModel)e.nextElement());
		cutBuffer = null;
		setNameTreeModel(new NameTreeModel(nameTree.getNode(0)));
	    }
	}
    }
    
    /**
     * 
     */
    protected void selectLowerTaxon() {
	selectLowerTaxon(false);
    }
    
    /**
     * 
     */
    protected void selectLowerTaxon(boolean forceNewCreate) {
	Rank rank = model.getRank();
	NameUsageListModel lowerListModel = (NameUsageListModel) lowerList.getModel();
	NameUsageEditModel lowerModel =
	    (NameUsageEditModel) (lowerListModel.getSelectedModel());
	NameUsageEditModel sourceModel = null;
	if (lowerModel == null || forceNewCreate) {
	    // create new taxon.
	    lowerList.deselect(lowerList.getSelectedIndex());
	    sourceModel = model;
	    
	    lowerModel =
		new NameUsageEditModel(getNameUsageEditModel().getAppearanceEditModel());
	    
	    lowerModel.setEditable(true);
	    
	    if(rank != null) {
		if(rank.equals(Rank.GENUS) || rank.isLower(Rank.GENUS)) {
		    lowerModel.getNameText().append(model.getNameText());
		    lowerModel.getNameText().append(" ");
		}
		
		lowerModel.setRank(rank.getNonOptionalLowerRank());
		lowerModel.saveAttributes();
	    }
	    
	    lowerModel.setHigherEditModel(getNameUsageEditModel());
	    
	    if(lowerList.getRows() == lowerListModel.getItemCount() + 1) {
		/*
		  lowerList.invalidate();
		  lowerListModel.enableDummyModel(isEditable());
		  lowerList.validate();
		*/
	    }
	} else {
	    // jump to selected taxon.
	    lowerListModel.update(lowerModel);
	}
	
	setModel(lowerModel);
    }
    
    protected void selectAnnotation() {
    	selectAnnotation(false);
    }

    protected void selectAnnotation(boolean forceNewCreate)
    {
	boolean newCreation = false;
	// regist annotation.
	//		AnnotationDialog dialog = new AnnotationDialog(this.getFrame());
	AnnotationEditModel annotationEditModel = (AnnotationEditModel)annotation.getSelectedModel();
	Annotation ann = null;
	if (annotationEditModel == annotation.getDummyModel() ||
	    annotationEditModel == null)
	    forceNewCreate = true;

	if (forceNewCreate) {
	    newCreation = true;
	    annotation.deselect(annotation.getSelectedIndex());
	    ann = new org.nomencurator.Annotation();
	    ann.addAnnotator(model.getNameUsage());
	    ann.setAppearance(model.getAppearanceEditModel().getAppearance());
	    annotationEditModel = new AnnotationEditModel(ann);
	}
	else
	    ann = annotationEditModel.getAnnotation();

	//	AnnotationEditDialog dialog = new AnnotationEditDialog(this.getFrame());
	AnnotationEditDialog dialog = new AnnotationEditDialog(annotationEditModel, getFrame());
	dialog.setNameUsageEditPanel(this);
	
	dialog.pack();
	dialog.show();

	if (dialog.isOK()) {
	    if(forceNewCreate) {
		annotation.addModel(annotationEditModel);
		annotationEditModel.setAppearanceEditModel(model.getAppearanceEditModel());
	    }
	    annotationEditModel.setModified(true);
	    annotationEditModel.saveAttributes();
	    NamedObjectBroker.getInstance().putUnsavedObject(ann);
	    model.setAnnotationsModified(true);
	    setModified(true);
	    /*
	    NamedObjectBroker.getInstance().putUnsavedObject(ann);
	    */
	    //	    annotation.update();
	}

	/*
	  String selectedOid = dialog.getSelectedOid();
	  int selectedLinkTypeIndex = dialog.getSelectedLinkTypeIndex();
	  if (dialog.isOK() && selectedOid != null && selectedLinkTypeIndex >= 0) {
	  annotationEditModel.addAnnotatorNameUsageEditModel(this.getNameUsageEditModel());
	  NamedObjectBroker broker = NamedObjectBroker.getInstance();
	  NameUsage nameUsage = (NameUsage)broker.getNamedObject(selectedOid);
	  NameUsageEditModel newNameUsageEditModel = new NameUsageEditModel(nameUsage);
	  annotationEditModel.addAnnotatedNameUsageEditModel(newNameUsageEditModel);
	  annotationEditModel.setAppearanceEditModel(this.getNameUsageEditModel().getAppearanceEditModel());
	  annotationEditModel.setAnnotationTypeIndex(selectedLinkTypeIndex);
	  annotationEditModel.saveAttributes();
	  this.getNameUsageEditModel().getAppearanceEditModel().addAnnotationEditModel(annotationEditModel);
	  this.getNameUsageEditModel().addAnnotation(annotationEditModel);
	  
	  AnnotationListModel annotationListModel = (AnnotationListModel) annotation.getModel();
	  if(annotation.getRows() == annotationListModel.getItemCount() + 1) {
	  annotation.invalidate();
	  annotation.enableDummyModel(isEditable());
	  annotation.validate();
	  }
	  }
	*/
	}

    public void putUnsavedObject()
    {
	if(isModified()) {
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    broker.putUnsavedObject(getNameUsage().getAppearance());
	    broker.putUnsavedObjects(getNameUsage().getAnnotations());
	}
	super.putUnsavedObject();
    }

    /**
     * Sets given <code>model</code> to be edited by this editor
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @param model <code>ObjectEditModel</code> to be edited
     *
     * @see org.nomencurator.editor.ObjectEditor.setModel()
     */
    public void setModel(ObjectEditModel model)
    {
	super.setModel(model);
	name.requestFocus();
	if(name.getText().length() > 0) {
	    name.end_of_line();
	    name.forward_character();
	}
	setNameTreeModel(NamedObjectBroker.getInstance().getTree(((NameUsageEditModel)model).getName()));
	if(appearanceEditPanel == null)
	    return;

	AppearanceEditModel aem = 
	    getNameUsageEditModel().getAppearanceEditModel();
	if(aem.getNamedObject().getEntity() != 
	   appearanceEditPanel.getAppearanceEditModel().getNamedObject().getEntity())
	    appearanceEditPanel.setModel(aem);
    }
}
