/*
 * NameUsageEditor.java:  an interface of NameUsageEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameUsageEditor.java,v 1.4 2002/04/16 00:39:03 nozomi Exp $
 * $Log: NameUsageEditor.java,v $
 * Revision 1.4  2002/04/16 00:39:03  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.3  2002/02/23 19:17:02  nozomi
 * Remove set*EditModel() methods
 *
 * Revision 1.2  2002/01/31 04:32:35  nozomi
 * Remove .. type
 *
 * Revision 1.1  2002/01/29 06:55:54  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import org.nomencurator.NameUsage;

import org.nomencurator.editor.model.NameUsageEditModel;

/**
 * Interface for graphical component wrapping
 * <code>NameUsageEditModel</code>.
 *
 * @see org.nomencurator.editor.model.NameUsageEditModel
 * @see org.nomencurator.NameUsage
 *
 * @version 	16 Apr 2002
 * @author 	Nozomi `James' Ytow
 */
public interface NameUsageEditor
    extends NamedObjectEditor
{
    /**
     * Gets <code>NameUsageEditModel</code> accompanying with this editor
     *
     * @return NameUsageEditModel accompanying with this editor
     */
    public NameUsageEditModel getNameUsageEditModel();

    /**
     * A utility method to get <code>NameUsage</code> under edition
     *
     * @return NameUsage under edition
     */
    public NameUsage getNameUsage();

    /**
     * A utility method to set <code>nameUsage</code> as
     * target of edition by accompanying <code>NameUsageEditModel</code>
     *
     * @param nameUsage to be set as target <code>NameUsage</code>
     */
    public void setNameUsage(NameUsage nameUsage);
}
