/**
 * NameUsageListRow.java
 *
 * @version 0.00, 2002/01/09
 * @author	Hcc-Network Hiroyuki Ohkawa
 * $Id: NameUsageListRow.java,v 1.1 2002/02/14 01:59:15 okawa Exp $
 * $Log: NameUsageListRow.java,v $
 * Revision 1.1  2002/02/14 01:59:15  okawa
 * initial import into CVS
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

public class NameUsageListRow
{
    private String objectId = "";
    private String name = "";
    private String author = "";
    private String year = "";

	/**
	 * Constractor
	 */
    public NameUsageListRow() {
        super();
    }

	/**
	 * Constractor
	 * @param String object id
	 * @param String name
	 * @param String author
	 * @param String year
	 */
    public NameUsageListRow(String objectId, String name, String author, String year) {
        this.objectId = objectId;
        this.name = name;
        this.author = author;
        this.year = year;
    }

	/**
	 * @return String object id
	 */
	public String getObjectId() {
	    return objectId;
    }

	/**
	 * @return String name
	 */
	public String getName() {
	    return name;
    }

	/**
	 * @return String author
	 */
	public String getAuthor() {
	    return author;
    }

	/**
	 * @return String year
	 */
	public String getYear() {
	    return year;
    }

   	/**
	 * @param String object id
	 */
	public void setObjectId(String objectId) {
	    this.objectId = objectId;
    }

   	/**
	 * @param String object id
	 */
	public void setName(String name) {
	    this.name = name;
    }

   	/**
	 * @param String author
	 */
	public void setAuthor(String author) {
	    this.author = author;
    }

   	/**
	 * @param String year
	 */
	public void setYear(String year) {
	    this.year = year;
    }

   	/**
	 * @return String[] string array to set TableList
	 */
	public String[] toStringArray() {
	    return new String[]{this.name, this.author, this.year};
    }

}
