/*
 * NameUsageSearchDialog.java: 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameUsageSearchDialog.java,v 1.6 2002/09/09 16:43:08 nozomi Exp $
 * $Log: NameUsageSearchDialog.java,v $
 * Revision 1.6  2002/09/09 16:43:08  nozomi
 * trial implementation of focus control
 *
 * Revision 1.5  2002/06/11 12:26:02  ryo
 * add self button
 *
 * Revision 1.4  2002/06/05 06:32:14  ryo
 * Set selected data when the window closing button is pressed
 *
 * Revision 1.3  2002/05/16 11:25:08  ryo
 * add getSelectedName() and some functions
 *
 * Revision 1.2  2002/05/16 09:06:32  ryo
 * add isOK()
 *
 * Revision 1.1  2002/05/15 11:57:55  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.BorderedPanel;
import jp.kyasu.awt.Button;
import jp.kyasu.awt.SplitPanel;
import jp.kyasu.graphics.VTitledPaneBorder;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public class NameUsageSearchDialog
extends Dialog
implements ActionListener {

	protected Frame frame;
	static protected final String L_TITLE = "NameUsage Search";
	static protected final String L_OK = "OK";
	static protected final String L_SELF = "Self";
	static protected final String L_CANCEL = "Cancel";
	protected Button okButton;
	protected Button selfButton;
	protected Button cancelButton;
	protected Button pressedButton;
	protected SearchView _searchView;
	protected BorderedPanel borderedPanel;
	protected Panel buttonPanel;
	protected SplitPanel splitPanel;
	protected String selectedOid = null;

	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 */
	public NameUsageSearchDialog(Frame frame) {
		this(frame, L_TITLE);
	}

	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 * @param title the title of the dialog
	 */
	public NameUsageSearchDialog(Frame frame, String title) {
		super(frame, title);
		this.frame = frame;
		init();
	}

	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 * @param title the title of the dialog
	 * @param modal if true, dialog blocks input to other app windows when shown
	 */
	public NameUsageSearchDialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		this.frame = frame;
		init();
	}

	/**
	 * Initialize this dialog
	 */
	protected void init() {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);

		_searchView = new SearchView();
		borderedPanel =
			new BorderedPanel(new VTitledPaneBorder(L_TITLE));
		borderedPanel.add(_searchView);

		buttonPanel = new Panel();
		okButton = new Button(L_OK);
		buttonPanel.add(okButton);
		okButton.addActionListener(this);
		selfButton = new Button(L_SELF);
		buttonPanel.add(selfButton);
		selfButton.addActionListener(this);
		cancelButton = new Button(L_CANCEL);
		buttonPanel.add(cancelButton);
		cancelButton.addActionListener(this);
		
		splitPanel = new SplitPanel(SplitPanel.VERTICAL, 3);
		add(splitPanel, BorderLayout.CENTER);
		splitPanel.add(borderedPanel);
		splitPanel.add(buttonPanel);

		// setBounds(0, 0, 550, 400);
		pack();
	}

	/**
	 * Invoked when an action occurs.
	 * @param e action event.
	 */
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		if (source instanceof Button)
			pressedButton = (Button)source;
		if (source == cancelButton || source == selfButton) {
			selectedOid = null;
		} else if (e.getSource() == okButton) {
			selectedOid = _searchView.getSelectedOid();
		}
		this.dispose();
	}
	
	/**
	 * Get selected object id.
	 * @return selected object id.
	 */
	public String getSelectedOid() {
		return selectedOid;
	}
	
	/**
	 * 
	 */
	public boolean isOK() {
		return (pressedButton == okButton);
	}

	/**
	 * 
	 */
	public boolean isOKButtonPressed() {
		return isOK();
	}
	
	/**
	 * 
	 */
	public boolean isSelfButtonPressed() {
		return (pressedButton == selfButton);
	}

	/**
	 * Get name string.
	 * @return name
	 */
	public String getSelectedName() {
		return _searchView.getSelectedName();
	}

	/**
	 * Get author string
	 * @return author
	 */
	public String getSelectedAuthor() {
		return _searchView.getSelectedAuthor();
	}

	/**
	 * Get year string.
	 * @return year
	 */
	public String getSelectedYear() {
		return _searchView.getSelectedYear();
	}

	/**
     * Invoked when the mouse has been clicked on the window closing button.
	 */
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			selectedOid = _searchView.getSelectedOid();
			if (selectedOid != null && selectedOid.length() > 0) {
				pressedButton = okButton;
			} else {
				pressedButton = null;
			}
			this.dispose();
		}
	}

//	public static void main(String[] args) {
//		Frame frame = new Frame();
//		NameUsageSearchDialog dialog = new NameUsageSearchDialog(frame);
//		dialog.show();
//	}


    public void show()
    {
	_searchView.requestFocus();
	super.show();
    }

}
