/*
 * NameUsageSearchListModel.java: 
 *
 * Copyright (c) 2001, 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameUsageSearchListModel.java,v 1.3 2002/03/28 06:32:03 okawa Exp $
 * $Log: NameUsageSearchListModel.java,v $
 * Revision 1.3  2002/03/28 06:32:03  okawa
 * add copyright
 *
 * Revision 1.2  2002/02/28 23:57:23  okawa
 * add removeAll()
 *
 * Revision 1.1  2002/02/14 01:59:15  okawa
 * initial import into CVS
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import jp.kyasu.awt.DefaultTextListModel;
import java.util.Vector;

public class NameUsageSearchListModel extends DefaultTextListModel
{
    private Vector/*<String>*/ objectIdList = new Vector();

	/**
	 * Constractor
	 */
    public NameUsageSearchListModel() {
        super();
    }

	/**
	 * Constractor
	 * @param int columns
	 * @param int colWidths[]
	 */
    public NameUsageSearchListModel(int columns, int colWidths[]) {
        super(columns, colWidths);
    }

    /**
     * add row data
     * @param String object id
     * @param String name
     * @param String author
     * @param String year
     */
    public void addRow(String oid, String name, String author, String year) {
        objectIdList.addElement(oid);
    	int itemCount = getItemCount();
        replaceItems(itemCount, itemCount, new String[][]{new String[]{name, author, year}});
    }

	/**
     * get the object id of the specified row
	 * @param  int row index
	 * @return String object id
	 */
	public String getOid(int index) {
	    return (String)objectIdList.elementAt(index);
    }

	/**
     * set object id of the specified row
	 * @param int row index
	 * @param String object id
	 */
	public void setOid(int index, String oid) {
	    String p = (String)objectIdList.elementAt(index);
	    p = oid;
    }

	/**
     * add object id
	 * @param String object id
	 */
	public void addOid(String oid) {
	    objectIdList.addElement(oid);
    }

	/**
     * remove all object Ids
	 */
	public void removeAll() {
	    objectIdList.removeAllElements();
	    replaceItems(0, getItemCount(),
			 new String[0][getColumnCount()]);
    }

}
