/*
 * NameUsageTreeView.java: 
 *
 * Copyright (c) 2001, 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameUsageTreeView.java,v 1.5 2002/04/16 00:40:38 nozomi Exp $
 * $Log: NameUsageTreeView.java,v $
 * Revision 1.5  2002/04/16 00:40:38  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.4  2002/03/28 06:32:03  okawa
 * add copyright
 *
 * Revision 1.3  2002/03/06 13:39:36  okawa
 * add setModel()
 *
 * Revision 1.2  2002/03/06 02:39:49  okawa
 * extends from TreeView
 *
 * Revision 1.1  2002/02/14 01:59:15  okawa
 * initial import into CVS
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.util.Vector;
import java.util.Enumeration;

import jp.kyasu.awt.Panel;

import org.nomencurator.awt.tree.TextTreeModel;
import org.nomencurator.awt.tree.TreeView;

import org.nomencurator.NameUsage;

public class NameUsageTreeView extends TreeView implements ItemListener
{
    protected TextTreeModel textTreeModel;

    protected Vector/*<ItemListener>*/ itemListeners = new Vector();

    protected static final int V_COLUMN_NAME = 0;

	/**
	 * Constractor
	 * @param TextTreeModel tree model
	 */
    public NameUsageTreeView(TextTreeModel treeModel) {
        super(treeModel);
        getController().addItemListener(this);
    }

	/**
	 * set tree model from the specified NameUsage
	 * @param NameUsage
	 */
    public void setModel(NameUsage nameUsage) {
	//        getController().setModel(((NameUsageUtility)nameUsage.getUtilityInstance()).getTextTreeModel(nameUsage));
    }

	
	/**
	 * add ItemLisetener
	 * @param ItemListener 
	 */
    public void addItemListener(ItemListener l) {
        itemListeners.addElement(l);
    }

	/**
	 * remove ItemLisetener
	 * @param ItemListener 
	 */
    public void removeItemListener(ItemListener l) {
        itemListeners.removeElement(l);
    }

	/**
	 * @param ItemEvent
	 */
    public void itemStateChanged(ItemEvent event) {
        for (Enumeration e = itemListeners.elements(); e.hasMoreElements();) {
            ItemListener listener = (ItemListener)e.nextElement();
            listener.itemStateChanged(event);
        }
    }        

	/**
	 * get the displayed name String of the specified row in the TreeView
	 * @param int row
	 */
    public Object getNameString(int row) {
        return getController().getItem(row, V_COLUMN_NAME); 
    }

}
