/*
 * NamedObjectEditPanel.java:  an editor of Object
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NamedObjectEditPanel.java,v 1.18 2002/10/16 22:54:40 nozomi Exp $
 * $Log: NamedObjectEditPanel.java,v $
 * Revision 1.18  2002/10/16 22:54:40  nozomi
 * removed unused setModel() code
 *
 * Revision 1.17  2002/09/17 08:46:39  nozomi
 * re-organise initialisation
 *
 * Revision 1.16  2002/09/08 19:51:14  nozomi
 * comment out newButtonClicked()
 *
 * Revision 1.15  2002/09/07 17:16:34  nozomi
 * fix bug in unsaved object putting methods
 *
 * Revision 1.14  2002/09/07 03:21:20  nozomi
 * save unsaved objects using NamedObjectBroker
 *
 * Revision 1.13  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.12  2002/06/03 09:38:09  ryo
 * call saveAttributes() of old objectEditModel when new button is pressed
 *
 * Revision 1.11  2002/06/03 01:43:37  nozomi
 * add Vector to hold not-yet-saved models
 *
 * Revision 1.10  2002/05/28 12:59:35  nozomi
 * deleteObserver() call in new button clicked
 *
 * Revision 1.9  2002/05/21 12:41:05  nozomi
 * remove Summarizble relating code
 *
 * Revision 1.8  2002/05/14 10:02:43  ryo
 * add updateView()
 *
 * Revision 1.7  2002/05/08 10:56:53  ryo
 * disable OK, Clear and Cancel button in *EditPanel
 *
 * Revision 1.6  2002/04/11 11:09:42  ryo
 * Add *ButtonClicked()
 *
 * Revision 1.5  2002/03/06 00:48:17  okawa
 * add getModifiedNamedObject()
 *
 * Revision 1.4  2002/02/26 15:43:53  nozomi
 * Add getSummaryTextArray() and getSummaryArray() to models
 *
 * Revision 1.3  2002/02/23 19:17:02  nozomi
 * Remove set*EditModel() methods
 *
 * Revision 1.2  2002/01/29 06:36:35  nozomi
 * Reoganised and some methodes were removed
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.editor;

import jp.kyasu.graphics.Text;

import org.nomencurator.NamedObject;

import org.nomencurator.editor.NamedObjectEditor;
import org.nomencurator.editor.ObjectEditPanel;

import org.nomencurator.editor.model.NamedObjectEditModel;

import org.nomencurator.broker.NamedObjectBroker;

import java.util.Observable;

/**
 * A <code>Panel</code> providing graphical component wrapping
 * <code>NamedObjectEditModel</code>.
 *
 * @see org.nomencurator.editor.model.NamedObjectEditModel
 *
 * @version 	16 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public abstract class NamedObjectEditPanel 
    extends ObjectEditPanel
    implements NamedObjectEditor
{
    /**
     * Constructor of <code>NamedObjectEditPanel</code> can be called
     * by only subclasses.
     * 
     * @param model <code>NamedObject</code> to be edited by this model
     * @param editable boolean indicating whether this editor is allowed to 
     * manipulate the <code>NamedObject</code>
     */
    protected NamedObjectEditPanel(NamedObjectEditModel model, boolean editable)
    {
	super(model, editable);
    }

    /**
     * Gets <code>NamedObjectEditModel</code> accompanying with this editor
     * It is part of <code>NamedObjectEditor</code> interface.
     *
     * @return NamedObjectEditModel accompanying with this editor
     *
     * @see org.nomencurator.editor.NamedObjectEditor.getModel()
     * @see org.nomencurator.editor.ObjectEditor.getModel()
     */
    public NamedObjectEditModel getNamedObjectEditModel()
    {
	return (NamedObjectEditModel)getModel();
    }

    /**
     * A utility method to get <code>NamedObject</code> under edition.
     * It is part of <code>NamedObjectEditor</code> interface.
     *
     * @return NamedObject under edition
     *
     * @see org.nomencurator.editor.NamedObjectEditor.getNamedObject()
     * @see org.nomencurator.editor.model.NamedObjectEditModel.getNamedObject()
     */
    public NamedObject getNamedObject()
    {
	return getNamedObjectEditModel().getNamedObject();
    }

    /**
     * A utility method to get <code>NamedObject</code> under edition.
     * If the <code>NamedObject</code> is not modified, return null.
     *
     * @return NamedObject under edition
     */
    public NamedObject getModifiedNamedObject()
    {
	if(modified)
	    return getNamedObject();
	else
	    return null;
    }

    /**
     * A utility method to set <code>namedObject</code> as
     * target of edition by accompanying <code>NamedObjectEditModel</code>.
     * It is part of <code>NamedObjectEditor</code> interface.
     *
     * @param namedObject to be set as target <code>NamedObject</code>
     *
     * @see org.nomencurator.editor.NamedObjectEditor.setNamedObject()
     * @see org.nomencurator.editor.model.NamedObjectEditModel.setNamedObject()
     */
    /*
    public void setNamedObject(NamedObject namedObject)
    {
	getNamedObjectEditModel().setNamedObject(namedObject);
    }
    */

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public String getSummary()
    {
	return getNamedObjectEditModel().getSummary();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public String[] getSummaryArray()
    {
	return getNamedObjectEditModel().getSummaryArray();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public Text getSummaryText()
    {
	return getNamedObjectEditModel().getSummaryText();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public Text[] getSummaryTextArray()
    {
	return getNamedObjectEditModel().getSummaryTextArray();
    }

    /**
     * Invoked when the mouse has been clicked on the Copy button.
     */
    public void copyButtonClicked() {
	super.copyButtonClicked();
	NamedObject namedObject = ((NamedObjectEditModel)objectEditModel).getNamedObject();
//		namedObject.string = namedObject.getUtilityInstance().createObjectId();
	setModel(objectEditModel);
	//	objectEditModel.addObserver(this);
	modified = true;
    }
    
    /**
     * Invoked when the mouse has been clicked on the Clear button.
     */
    //	public void clearButtonClicked() {
    //		super.clearButtonClicked();
    //        setModel(objectEditModel);
    //        objectEditModel.addObserver(this);
    //	}
    
    /**
     * Invoked when the mouse has been clicked on the Cancel button.
     */
    //	public void cancelButtonClicked() {
    //		super.cancelButtonClicked();
    //        setModel(objectEditModel);
    //        objectEditModel.addObserver(this);
    //	}
    
    public abstract void updateView();

    public void putUnsavedObject()
    {
	if(isModified()) {
	    saveAttributes();
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    broker.putUnsavedObject(getNamedObject());
	    setModified(false);
	}
    }
}
