/*
 * NamedObjectEditor.java:  an editor interface of NamedObject
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000, 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NamedObjectEditor.java,v 1.4 2002/09/17 08:46:39 nozomi Exp $
 * $Log: NamedObjectEditor.java,v $
 * Revision 1.4  2002/09/17 08:46:39  nozomi
 * re-organise initialisation
 *
 * Revision 1.3  2002/02/23 19:17:02  nozomi
 * Remove set*EditModel() methods
 *
 * Revision 1.2  2002/01/29 10:01:29  nozomi
 * Modified to provide summaries
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.editor;

import jp.kyasu.graphics.Text;

import org.nomencurator.NamedObject;

import org.nomencurator.editor.ObjectEditor;

import org.nomencurator.editor.model.NamedObjectEditModel;

/**
 * Interface for graphical component wrapping
 * <code>NamedObjectEditModel</code>.
 *
 * @see org.nomencurator.editor.model.NamedObjectEditModel
 * @see org.nomencurator.editor.ObjectEditor
 * @see org.nomencurator.NamedObject
 *
 * @version 	17 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public interface NamedObjectEditor
    extends ObjectEditor
{
    /**
     * Gets <code>NamedObjectEditModel</code> accompanying with this editor
     *
     * @return NamedObjectEditModel accompanying with this editor
     */
    public NamedObjectEditModel getNamedObjectEditModel();

    /**
     * A utility method to get <code>NamedObject</code> under edition
     *
     * @return NamedObject under edition
     */
    public NamedObject getNamedObject();


    /**
     * A utility method to set <code>namedObject</code> as
     * target of edition by accompanying <code>NamedObjectEditModel</code>
     *
     * @param namedObject to be set as target <code>NamedObject</code>
     */
    //    public void setNamedObject(NamedObject namedObject);

    
    /**
     * A utility method to load attributes of <code>Object</code>
     * to the model
     *
     * @see ObjectEditModel.loadAttributes()
     */
    public void loadAttributes();


    /**
     * A utility method to save attributes to <code>Object</code>
     * from the model
     *
     * @see ObjectEditModel.saveAttributes()
     */
    public void saveAttributes();

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public String getSummary();

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public String[] getSummaryArray();

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public Text getSummaryText();

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public Text[] getSummaryTextArray();

}
