/*
 * ObjectEditor.java:  an editor interface of Object
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ObjectEditor.java,v 1.3 2002/09/07 03:09:27 nozomi Exp $
 * $Log: ObjectEditor.java,v $
 * Revision 1.3  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.2  2002/06/23 13:38:42  nozomi
 * aware of FocusController
 *
 * Revision 1.1  2002/01/29 06:48:21  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import java.util.Observer;

import org.nomencurator.editor.model.ObjectEditModel;

/**
 * Interface for graphical component wrapping
 * <code>ObjectEditModel</code>.
 *
 * @see org.nomencurator.editor.model.ObjectEditModel
 *
 * @version 	06 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public interface ObjectEditor
    extends Observer
{
    /**
     * Returns true if this editor allows modification of
     * accompanying model
     *
     * @return true if this editor allows modification of
     * accompanying model, or false if not
     */
    public boolean isEditable();


    /**
     * Sets this editor editable according to given parameter <code>editable</code> 
     *
     * @param editable true to allow modification of
     * accompanying model by this edior, or false to disable
     */
    public void setEditable(boolean editable);


    /**
     * Returns <code>ObjectEditModel</code> under edition
     * by this editor
     *
     * @return ObjectEditModel under edition
     */
    public ObjectEditModel getModel();


    /**
     * Sets given <code>model</code> to be edited by this editor
     *
     * @param model <code>ObjectEditModel</code> to be edited
     */
    public void setModel(ObjectEditModel model);

    /**
     * Adds a <code>listener</code> as <code>ForcusListener</code>
     * to this.
     *
     * @param listener <code>FocusListener</code> to be added
     */
    //    public void addFocusdListener(FocusListener listener);

    /**
     * Removes a <code>listener</code> as <code>ForcusListener</code>
     * to this.
     *
     * @param listener <code>FocusListener</code> to be removed
     */
    //    public void removeFocusdListener(FocusListener listener);

}
