/*
 * PublicationEditPanel.java:  a PublicationEditor Panel
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2000, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: PublicationEditPanel.java,v 1.44 2002/10/18 08:57:19 nozomi Exp $
 * $Log: PublicationEditPanel.java,v $
 * Revision 1.44  2002/10/18 08:57:19  nozomi
 * tentative workaround against mouseListener control of List
 *
 * Revision 1.43  2002/10/18 04:56:39  nozomi
 * use getDummyModel()
 *
 * Revision 1.42  2002/10/16 22:55:33  nozomi
 * fix newButtonClicked()
 *
 * Revision 1.41  2002/09/17 08:46:39  nozomi
 * re-organise initialisation
 *
 * Revision 1.40  2002/09/07 17:15:12  nozomi
 * fix bug in unsaved object putting methods
 *
 * Revision 1.39  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.38  2002/09/03 02:51:47  nozomi
 * use CardLayout to switch editors
 *
 * Revision 1.37  2002/09/03 00:24:21  nozomi
 * tentative fix of editor selection
 *
 * Revision 1.36  2002/08/26 05:12:01  t.okada
 * change dialog design
 *
 * Revision 1.35  2002/08/22 08:00:28  nozomi
 * call setEditor() in editor style slection
 *
 * Revision 1.34  2002/08/05 13:12:36  t.okada
 * When AuthorList of the PublicationEditPanel is double-clicked, the bug which does not change to the AuthorEditPanel is corrected.
 *
 * Revision 1.33  2002/08/05 08:01:17  t.okada
 * DummyModel addition processing is corrected.
 *
 * Revision 1.32  2002/07/16 08:14:49  ryo
 * call updateView() in AppearanceEditPanel when setModel() called
 *
 * Revision 1.31  2002/07/02 08:25:06  nozomi
 * modify comment style to single line
 *
 * Revision 1.30  2002/06/23 13:38:42  nozomi
 * aware of FocusController
 *
 * Revision 1.29  2002/06/06 05:46:36  t.okada
 * modify newButtonClicked()
 *
 * Revision 1.28  2002/06/04 14:01:26  t.okada
 * new button processing is modified
 *
 * Revision 1.27  2002/05/28 22:07:56  nozomi
 * rcursive creation of relating model
 *
 * Revision 1.26  2002/05/28 12:57:41  nozomi
 * set brand-new mode when new button clicked
 *
 * Revision 1.25  2002/05/26 21:03:46  nozomi
 * modify double click handling
 *
 * Revision 1.24  2002/05/23 02:50:17  nozomi
 * simplify related model selection
 *
 * Revision 1.23  2002/05/23 00:03:14  nozomi
 * use isEditable to enable/disable dummy model addition
 *
 * Revision 1.22  2002/05/21 08:34:40  nozomi
 * use getDummyModel() to determine mouse position
 *
 * Revision 1.21  2002/05/21 08:07:56  nozomi
 * enable dummy model addition when appearance entries in the TableList exceeds number of presented rows
 *
 * Revision 1.20  2002/05/21 04:40:59  nozomi
 * enble/disable dummy model addition dynamically for authoList
 *
 * Revision 1.19  2002/05/17 19:10:41  ryo
 * add popup menu to authorList and appearanceList
 *
 * Revision 1.18  2002/05/14 10:04:40  ryo
 * add updateView() and add the processing which should be performed when double clicking a list
 *
 * Revision 1.17  2002/05/10 13:42:37  ryo
 * add the processing which should be performed when double clicking a list
 *
 * Revision 1.16  2002/05/08 10:56:53  ryo
 * disable OK, Clear and Cancel button in *EditPanel
 *
 * Revision 1.15  2002/04/20 23:29:27  nozomi
 * improve mutual linkage between EditPanels
 *
 * Revision 1.14  2002/04/16 23:43:51  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.13  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.12  2002/03/06 00:08:42  nozomi
 * add constructors
 *
 * Revision 1.11  2002/03/03 23:48:53  nozomi
 * setModel() synchronized
 *
 * Revision 1.10  2002/02/24 23:48:36  nozomi
 * implements ItemSelectable
 *
 * Revision 1.9  2002/02/24 18:13:36  nozomi
 * re-implementation of setModel() to be used switching between models
 *
 * Revision 1.8  2002/02/19 19:27:39  nozomi
 * add BookSectionEditPanel
 *
 * Revision 1.7  2002/02/18 23:10:13  nozomi
 * accepts EditedBook
 *
 * Revision 1.6  2002/02/17 21:09:01  nozomi
 * Accepts BookEditPanel
 *
 * Revision 1.5  2002/02/16 22:32:26  nozomi
 * Fix PublicationEditPanel related issues
 *
 * Revision 1.4  2002/02/07 08:39:22  nozomi
 * Accepts Journal Article
 *
 * Revision 1.3  2002/02/04 07:48:32  nozomi
 * correction of maximumTypeIndex's initial value
 *
 * Revision 1.2  2002/02/04 07:43:57  nozomi
 * More EndNotize, i.e. add more reference types
 *
 * Revision 1.1  2002/02/01 01:07:16  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.AWTEventMulticaster;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.PopupMenu;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import java.util.Enumeration;
import java.util.Vector;

import jp.kyasu.awt.TextListModel;
import jp.kyasu.awt.Choice;
import jp.kyasu.awt.DefaultTextListModel;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.SplitPanel;
import jp.kyasu.awt.Dialog;

import jp.kyasu.editor.Editor;

import org.nomencurator.Publication;

import org.nomencurator.broker.NamedObjectBroker;

import org.nomencurator.editor.NamedObjectEditPanel;
import org.nomencurator.editor.PublicationNewMenuDialog;

import org.nomencurator.editor.model.AuthorEditModel;
import org.nomencurator.editor.model.AppearanceEditModel;
import org.nomencurator.editor.model.NamedObjectListModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.PublicationEditModel;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.editor.model.NameTreeModel;

/**
 * <code>Panel</code> to represent a <code>PublicationEditModel</code>
 * via an <code>AbstractPublicationEditPanel</code>.
 *
 * @see org.nomencurator.editor.model.PublicationEditModel
 * @see org.nomencurator.Publication
 *
 * @version 	18 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class PublicationEditPanel
    extends NamedObjectEditPanel
    implements PublicationEditor, ItemListener, ItemSelectable, ActionListener//, KeyListener
{
    /** <code>TextListModel</code> of publication type <code>Choice</code> */
    protected static TextListModel publicationTypeModel
	= new DefaultTextListModel();

    /**
     * Default contents of <code>pulicationTypeModel</code>
     */
    protected static String[][]  defaultPublicationTypeTitles = {
	{"Journal Article"},
	{"Book"},
	{"Book Section"},
	{"Manuscript"},
	{"Edited Book"},
	{"Magazine Article"},
	{"Newspaper Article"},
	{"Conference Proceedings"},
	{"Thesis"},
	{"Report"},
	{"Personal Communication"},
	{"Book Series"}, 
	{"Journal"}, 
	{"Magazine"}, 
	{"Computer Program"},
	{"Electronic Source"},
	{"Audiovisual Material"},
	{"Film or Broadcast"},
	{"Artwork"},
	{"Patent"},
	{"Map"},
	{"Hearing"},
	{"Bill"},
	{"Statute"},
	{"Case"},
	{"Generic"},
	{"other"}
    };

    static {
	publicationTypeModel.replaceItems(0, 0, defaultPublicationTypeTitles);
    }

    //indices of publication types
    /** Index of journal article type */
    static public final int JOURNAL_ARTICLE = 0;

    /** Index of book type */
    static public final int BOOK = JOURNAL_ARTICLE + 1;

    /** Index of book section type */
    static public final int BOOK_SECTION = BOOK + 1;

    /** Index of manuscript type */
    static public final int MANUSCRIPT = BOOK_SECTION + 1;

    /** Index of edited book type */
    static public final int EDITED_BOOK = MANUSCRIPT + 1;

    /** Index of magazine article type */
    static public final int MAGAZINE_ARTICLE = EDITED_BOOK + 1;

    /** Index of newspaper articletype */
    static public final int NEWSPAPER_ARTICLE = MAGAZINE_ARTICLE + 1;

    /** Index of conference proceedings type */
    static public final int CONFERENCE_PROCEEDINGS = NEWSPAPER_ARTICLE + 1;

    /** Index of thesis type */
    static public final int THESIS = CONFERENCE_PROCEEDINGS + 1;

    /** Index of report type */
    static public final int REPORT = THESIS + 1;

    /** Index of personal communication type */
    static public final int PERSONAL_COMMUNICATION = REPORT + 1;

    /** Index of book series type */
    static public final int BOOK_SERIES = PERSONAL_COMMUNICATION + 1;

    /** Index of journal type */
    static public final int JOURNAL = BOOK_SERIES + 1;

    /** Index of magazine type */
    static public final int MAGAZINE = JOURNAL + 1;

    /** Index of computer program type */
    static public final int COMPUTER_PROGRAM = MAGAZINE + 1;

    /** Index of map type */
    static public final int ELECTRONIC_SOURCE = COMPUTER_PROGRAM + 1;

    /** Index of audiovisual material type */
    static public final int AUDIOVISUAL_MATERIAL = ELECTRONIC_SOURCE + 1;

    /** Index of film or broadcast */
    static public final int FILM_OR_BROADCAST = AUDIOVISUAL_MATERIAL + 1;

    /** Index of artwork type */
    static public final int ARTWORK = FILM_OR_BROADCAST + 1;

    /** Index of patent type */
    static public final int PATENT = ARTWORK + 1;

    /** Index of map type */
    static public final int MAP = PATENT + 1;

    /** Index of hearing type */
    static public final int HEARING = MAP + 1;

    /** Index of bill type */
    static public final int BILL = HEARING + 1;

    /** Index of statute type */
    static public final int STATUTE = BILL + 1;

    /** Index of case type */
    static public final int CASE = STATUTE + 1;

    /** Index of generic type */
    static public final int GENERIC = CASE + 1;

    /** Index of last type */
    static public int maximumTypeIndex = GENERIC;

    /** default publiaction style */ 
    protected static int defaultPublicationType = JOURNAL_ARTICLE;

    /** style of publiaction */ 
    protected int                publicationStyle;



    //publication style IDs
    /** Publication style ID for articles in journal, magazine or newspaper */
    public static final int JOURNAL_ARTICLE_STYLE = 0;

    /** Publication style ID for articles in journal, magazine or newspaper */
    public static final int ARTICLE_STYLE = JOURNAL_ARTICLE_STYLE + 1;

    /** Publication style ID for book section */
    public static final int BOOK_SECTION_STYLE = ARTICLE_STYLE + 1;

    /** Publication style ID for book section */
    public static final int MANUSCRIPT_STYLE = BOOK_SECTION_STYLE + 1;

    /** Publication style ID for book */
    public static final int BOOK_STYLE = MANUSCRIPT_STYLE + 1;
    
    /** Publication style ID for edited book */
    public static final int EDITED_BOOK_STYLE = BOOK_STYLE + 1;

    /** Publication style ID for conference proceedings */
    public static final int PROCEEDINGS_STYLE = EDITED_BOOK_STYLE + 1;

    /** Publication style ID for thesis */
    public static final int THESIS_STYLE = PROCEEDINGS_STYLE + 1;

    /** Publication style ID for report */
    public static final int REPORT_STYLE = THESIS_STYLE  + 1;

    /** Publication style ID for personal communication */
    public static final int PERSONAL_COMMUNICATION_STYLE = REPORT_STYLE + 1;

    /** Publication style ID for book series, journal, magazine */
    public static final int PERIODICAL_STYLE = PERSONAL_COMMUNICATION_STYLE + 1;

    /** Publication style ID for computer program */
    public static final int COMPUTER_PROGRAM_STYLE = PERIODICAL_STYLE + 1;

    /** Publication style ID for electronic sources */
    public static final int ELECTRONIC_SOURCE_STYLE = COMPUTER_PROGRAM_STYLE + 1;

    /** Publication style ID for audiovisual material */
    public static final int AUDIOVISUAL_STYLE = ELECTRONIC_SOURCE_STYLE  + 1;

    /** Publication style ID for Audiovisual Material */
    public static final int FILM_OR_BROADCAST_STYLE = AUDIOVISUAL_STYLE + 1;

    /** Publication style ID for artwork */
    public static final int ARTWORK_STYLE = FILM_OR_BROADCAST_STYLE + 1;

    /** Publication style ID for patent */
    public static final int PATENT_STYLE = ARTWORK_STYLE + 1;

    /** Publication style ID for map */
    public static final int  MAP_STYLE = PATENT_STYLE + 1;

    /** Publication style ID for hearing */
    public static final int  HEARING_STYLE = MAP_STYLE + 1;

    /** Publication style ID for bill */
    public static final int  BILL_STYLE = HEARING_STYLE + 1;

    /** Publication style ID for statute */
    public static final int STATUTE_STYLE = BILL_STYLE + 1;

    /** Publication style ID for case */
    public static final int CASE_STYLE = STATUTE_STYLE + 1;

    /** Publication style ID for generic */
    public static final int GENERIC_STYLE = CASE_STYLE + 1;

    /** Default contents of <code>pulicationTypeModel</code> */
    protected static int publicationStyleID[] = {
	JOURNAL_ARTICLE_STYLE, //Journal Article
	BOOK_STYLE,    //Book
	BOOK_SECTION_STYLE, //Book Section
	MANUSCRIPT_STYLE, //Manuscript
	EDITED_BOOK_STYLE, //Edited Book
	ARTICLE_STYLE, //Magazine Article
	ARTICLE_STYLE, //Newspaper Article
	PROCEEDINGS_STYLE, //Conference Proceedings
	THESIS_STYLE, //Thesis
	REPORT_STYLE, //Report
	PERSONAL_COMMUNICATION_STYLE, //Personal Communication
	PERIODICAL_STYLE, //Book Series
	PERIODICAL_STYLE, //Journal
	PERIODICAL_STYLE, //Magazine
	COMPUTER_PROGRAM_STYLE, //Computer Program
	ELECTRONIC_SOURCE_STYLE, //Electronic Source
	AUDIOVISUAL_STYLE, //Audiovisual Material
	FILM_OR_BROADCAST_STYLE, //Film or Broadcast
	ARTWORK_STYLE, //Artwork
	PATENT_STYLE, //Patent
	MAP_STYLE, //Map
	HEARING_STYLE, //Hearing
	BILL_STYLE, //Bill
	STATUTE_STYLE, //Statute
	CASE_STYLE, //Case
	GENERIC_STYLE, //Generic
	GENERIC_STYLE, //other

    };


    /** <CODE>Choice</CODE> of publiaction type */ 
    protected Choice                publicationTypeSelector;

    /** <CODE>Label</CODE> string for type of publiaction */ 
    protected static String publicationTypeSelectorTitle = "Reference Type:";

    /**
     * <code>Panl</code> containing publication type selector
     */
    protected org.nomencurator.editor.Panel publicationTypePanel;

    /**
     * <code>PublicationEditor</code> wrapped by this editor
     */
    protected AbstractPublicationEditPanel        editor;

    protected AbstractPublicationEditPanel        bookEditPanel;
    protected AbstractPublicationEditPanel        bookSectionEditPanel;
    protected AbstractPublicationEditPanel        editedBookEditPanel;
    protected AbstractPublicationEditPanel        journalArticleEditPanel;

    protected Panel editorPanel;

    protected CardLayout editorLayout;

    /**
     * <code>SplitPanel</code> providing base of all components of this editor
     */
    protected SplitPanel basePanel;

    /**
     * Listeners of this <code>Component</code>
     */
    transient protected ItemListener itemListener;

    /**
     * <code>ItemEvent</code> to be passed to listeners
     */
    protected ItemEvent itemEvent;

    /**
     * <code>AppearanceEditPanel</code> where the <code>NameUsge</code> appeared
     */
    protected AppearanceEditPanel appearanceEditPanel;

    /**
     * <code>AuthorEditPanel</code> to edit authors
     */
    protected AuthorEditPanel authorEditPanel;

    /**
     * 
     */
    protected MenuItem createNewAuthorMenuItem;
    
    /**
     * 
     */
    protected static String createNewAuthorTitle = "create new author";
    
    /**
     * 
     */
    protected MenuItem createNewAppearanceMenuItem;
    
    /**
     * 
     */
    protected static String createNewAppearanceTitle = "create new appearance";

    Editor editAdaptor;

    /**
     * Creates <code>PublicationEditPanel</code>
     */
    public PublicationEditPanel()
    {
	this(new Publication());
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public PublicationEditPanel(Publication publication)
    {
	this(new PublicationEditModel(publication));
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public PublicationEditPanel(PublicationEditModel model)
    {
	this(model, true);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public PublicationEditPanel(PublicationEditModel model, boolean editable)
    {
	this(model, editable, null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public PublicationEditPanel(PublicationEditModel model,
				boolean editable,
				Vector authorEditModels,
				Vector appearanceEditModels)
    {
	super(model, editable);
    }

    /**
     * Adds components to this <code>Panel</code>
     *
     */
    protected void addModelComponents()
    {
	add(basePanel);
    }

    /**
     * Removes components from this <code>Panel</code>
     *
     */
    protected void removeModelComponents()
    {
	remove(basePanel);
    }
    
    /**
     * Creates components corresponding to the model
     */
    protected void createModelComponents()
    {
	createBasePanel();
	createAbstractPublicationEditPanel((PublicationEditModel)getModel());
	//addKeyListener(this); //?
	basePanel.add(editorPanel);
    }

    /**
     * Creates <code>Panel</code> representing <code>model</code>
     *
     * @param model <code>PublicationEditModel</code> to be represented
     */
    protected void createAbstractPublicationEditPanel(PublicationEditModel model)
    {
	bookEditPanel = new BookEditPanel(model);
	bookEditPanel.setName(defaultPublicationTypeTitles[1][0]);
	bookSectionEditPanel = new BookSectionEditPanel(model);
	bookSectionEditPanel.setName(defaultPublicationTypeTitles[2][0]);
	editedBookEditPanel = new EditedBookEditPanel(model);
	editedBookEditPanel.setName(defaultPublicationTypeTitles[3][0]);
	journalArticleEditPanel = new JournalArticleEditPanel(model);
	journalArticleEditPanel.setName(defaultPublicationTypeTitles[0][0]);
	editorLayout = new CardLayout();
	editorPanel = new Panel(editorLayout);
	editorPanel.add(journalArticleEditPanel, journalArticleEditPanel.getName());
	editorPanel.add(bookEditPanel, bookEditPanel.getName());
	editorPanel.add(bookSectionEditPanel, bookSectionEditPanel.getName());
	editorPanel.add(editedBookEditPanel, editedBookEditPanel.getName());
	selectEditor(defaultPublicationType);
    }


    public void selectEditor(int style)
    {
	if (style == -1)
	    style = defaultPublicationType;

	if(editor != null) {
	    editor.authorList.removeMouseListener(this);
	    editor.appearanceList.removeMouseListener(this);
	    editor.secondaryAuthorList.removeMouseListener(this);
	}
	switch(publicationStyleID[style]){
	case BOOK_STYLE:
	    editor = bookEditPanel;
	    break;
	case BOOK_SECTION_STYLE:
	    editor = bookSectionEditPanel;
	    break;
	case EDITED_BOOK_STYLE:
	    editor = editedBookEditPanel;
	    break;
	case JOURNAL_ARTICLE_STYLE:
	default:
	    editor = journalArticleEditPanel;
	    break;
	}

	editorLayout.show(editorPanel, editor.getName());

	editor.setEditor(editAdaptor);
	editor.authorList.addMouseListener(this);
	editor.appearanceList.addMouseListener(this);
	editor.secondaryAuthorList.addMouseListener(this);

	PopupMenu pm = editor.authorList.getPopupMenu();
	pm.addSeparator();
	createNewAuthorMenuItem = new MenuItem(createNewAuthorTitle);
	createNewAuthorMenuItem.addActionListener(this);
	pm.add(createNewAuthorMenuItem);
	editor.authorList.setPopupMenu(pm);
	
	pm = editor.appearanceList.getPopupMenu();
	pm.addSeparator();
	createNewAppearanceMenuItem = new MenuItem(createNewAppearanceTitle);
	createNewAppearanceMenuItem.addActionListener(this);
	pm.add(createNewAppearanceMenuItem);
	editor.appearanceList.setPopupMenu(pm);
	
	//	addKeyListener(this);
    }

    /**
     * Creates <code>Panel</code> representing <code>model</code>
     *
     * @param model <code>PublicationEditModel</code> to be represented
     */
    protected void createAbstractPublicationEditPanel(AbstractPublicationEditPanel panel)
    {
	createAbstractPublicationEditPanel(panel.getPublicationEditModel());
    }

    /**
     * Creates publication type selctor
     */
    protected void createBasePanel()
    {
	publicationTypeSelector = new Choice(publicationTypeModel);
	publicationTypeSelector.addItemListener(this);

	publicationTypePanel = new org.nomencurator.editor.Panel();
	publicationTypePanel.add(new Label(publicationTypeSelectorTitle), publicationTypeSelector);

	basePanel = new SplitPanel(SplitPanel.VERTICAL);
	basePanel.add(publicationTypePanel);
    }

    /**
     * Sets <CODE>ed</CODE> as <CODE>Editor</CODE> of <CODE>TextComponent</CODE>s
     * to provide <CODE>Text</CODE> handling using GUI.
     *
     * @param ed <CODE>Editor</CODE> to be linked to <CODE>TextComponent</CODE>s
     * of this
     */
    public void setEditor(Editor ed)
    {
	editAdaptor = ed;
	editor.setEditor(ed);
    }

    /**
     * Gets <code>PublicationEditModel</code> accompanying with this editor
     *
     * @return PublicationEditModel accompanying with this editor
     */
    public PublicationEditModel getPublicationEditModel()
    {
	return editor.getPublicationEditModel();
    }

    /**
     * Setups components to use given <CODE>model</CODE>.
     * This method is called from setModel(ObjectEditModel)
     * internally.
     */
    protected void setComponents(ObjectEditModel objectEditModel)
    {
	//it should be rewritten when List is fixed
	editor.authorList.removeMouseListener(this);

	//editor.setModel(objectEditModel);
	journalArticleEditPanel.setModel(objectEditModel);
	bookEditPanel.setModel(objectEditModel);
	objectEditModel.updateSummary();

	//it should be rewritten when List is fixed
	editor.authorList.addMouseListener(this);

	//	appearanceEditPanel.updateView();
	if(itemListener != null) {
	    if(itemEvent == null)
		itemEvent = 
		    new ItemEvent(this, 
				  ItemEvent.ITEM_STATE_CHANGED,
				  this,
				  ItemEvent.ITEM_STATE_CHANGED
				  );
	    itemListener.itemStateChanged(itemEvent);
	}
    }

    /**
     * A utility method to get <code>Publication</code> under edition
     *
     * @return Publication under edition
     */
    public Publication getPublication()
    {
	return editor.getPublication();
    }

    /**
     * A utility method to set <code>publication</code> as
     * target of edition by accompanying <code>PublicationEditModel</code>
     *
     * @param publication to be set as target <code>Publication</code>
     */
    public void setPublication(Publication publication)
    {
	editor.setPublication(publication);
    }
    
    /**
     * Creates an <code>ObjectEditModel</code> appropriate to 
     * the subclass of <code>ObjectEditPanel</code> which is used
     * in <code>Button</code> pressed event handling.
     *
     */
    protected ObjectEditModel createObjectEditModel()
    {
	return editor.createObjectEditModel();
    }

    /**
     * Returns boolean determining summary's visibility
     *
     * @return true if summary of the <code>Publication</code> is visible
     */
    public boolean isSummaryVisible()
    {
	return editor.isSummaryVisible();
    }

    /**
     * Sets <code>visibility</code> of summary
     *
     * @param visibility true to make summary of the <code>Publication</code> visible
     */
    public void setSummaryVisible(boolean visibility)
    {
	editor.setSummaryVisible(visibility);
    }

    /**
     * Returns <code>AppearanceEditPanel</code> linked to this
     * <code>PublicationEditPanel</code>
     */
    public AppearanceEditPanel getAppearanceEditPanel()
    {
	return appearanceEditPanel;
    }

    /**
     * Sets <code>pane</code> as <code>AppearanceEditPanel</code>
     * linked to this object
     *
     * @param panel <code>AppearanceEditPanel</code> to be linked
     */
    public void setAppearanceEditPanel(AppearanceEditPanel panel)
    {
	if(appearanceEditPanel == panel)
	    return;

	if(appearanceEditPanel != null)
	    appearanceEditPanel.setPublicationEditPanel(null);

	appearanceEditPanel = panel;
	if(appearanceEditPanel != null)
	    appearanceEditPanel.setPublicationEditPanel(this);
    }

    /**
     * Invoked when an item's state has been changed.
     * @see java.awt.event.ItemListener
     */
    public void itemStateChanged(ItemEvent e)
    {
	super.itemStateChanged(e);
	basePanel.invalidate();
	Graphics g = editor.getGraphics();
	Dimension d = editor.getSize();
	g.setColor(getBackground());
	g.fillRect(0, 0, d.width, d.height);
	g.setColor(getForeground());
	selectEditor(publicationTypeSelector.getSelectedIndex());
	/*
	basePanel.remove(editor);
	createAbstractPublicationEditPanel(editor);
	basePanel.add(editor);
	basePanel.validate();
	*/
	basePanel.validate();
    }

    /**
     * Adds the specified item listener to receive item events from this list.
     *
     * @param l the item listener.
     */
    public synchronized void addItemListener(ItemListener l)
    {
	itemListener = AWTEventMulticaster.add(itemListener, l);
	enableEvents(0); // mark newEventsOnly
    }

    /**
     * Removes the specified item listener so that it no longer receives
     * item events from this list.
     * @param l the item listener.
     */
    public synchronized void removeItemListener(ItemListener l)
    {
	itemListener = AWTEventMulticaster.remove(itemListener, l);
    }

    /**
     * Returns the selected items on the list in an array of Objects.
     * @see java.awt.ItemSelectable
     */
    public Object[] getSelectedObjects()
    {
	return new Object[]{getModel()};
    }

    /**
     * Invoked when the mouse has been clicked on the OK button.
     */
//    public void okButtonClicked()
//    {
//	super.okButtonClicked();
//	// link AuthorEditModel to this
//	PublicationEditModel publicationEditModel = (PublicationEditModel)objectEditModel;
//	AuthorEditModel authorEditModel = (AuthorEditModel)(this.getAuthorEditPanel().getModel());
//	publicationEditModel.addAuthor(authorEditModel);
//	authorEditModel.add(publicationEditModel);
//	// link AppearanceEditModel to this
//	AppearanceEditModel appearanceEditModel = (AppearanceEditModel)appearanceEditPanel.getModel();
//	appearanceEditModel.setPublicationEditModel(publicationEditModel);
//    }

    /**
     * Invoked when the mouse has been clicked on the New button.
     */
    public void newButtonClicked() {
    	PublicationNewMenuDialog dialog = new PublicationNewMenuDialog(this.getFrame(), "Enter New Publication", true);
	dialog.show();
	if (dialog.getPushedButton() == dialog.CURRENT_WINDOW) {
	    //taxoNote.saveDatabase();
	    
	    super.newButtonClicked();
	    PublicationEditModel currentEditModel = (PublicationEditModel)objectEditModel;
	    PublicationEditModel previousEditModel = (PublicationEditModel)previousModel;
	    
	    //setModel((PublicationEditModel)taxoNote.clearModels());
	    if(appearanceEditPanel != null) {
		AppearanceEditModel aem = 
		    new AppearanceEditModel();
		aem.setPublicationEditModel(currentEditModel);
		appearanceEditPanel.setModel(aem);
		NameUsageEditPanel nep =
		    appearanceEditPanel.getNameUsageEditPanel();
		if(nep != null) {
		    NameUsageEditModel nem =
			new NameUsageEditModel();
		    nem.setAppearanceEditModel(aem);
		    nep.setModel(nem);
		}
	    }

	    if(authorEditPanel != null) {
		AuthorEditModel aum =
		    new AuthorEditModel();
		currentEditModel.addAuthor(aum);
		authorEditPanel.setModel(aum);
	    }

	} else if(dialog.getPushedButton() == dialog.NEW_WINDOW) {
	    taxoNote.openNewWindow();
	} else {
	    //cancel
	}
   }
    
    /**
     * Invoked when the mouse has been clicked on the Copy button.
     */
    public void copyButtonClicked()
    {
	super.copyButtonClicked();
	PublicationEditModel currentEditModel = (PublicationEditModel)objectEditModel;
	PublicationEditModel previousEditModel = (PublicationEditModel)previousModel;
	currentEditModel.setAppearanceEditModels(previousEditModel.getAppearanceEditModels());
	Enumeration e = previousEditModel.getAuthorEditModels().elements();
	while(e.hasMoreElements()) {
	    currentEditModel.addAuthor((AuthorEditModel)e.nextElement());
	}
    }

    /**
     * Invoked when the mouse has been clicked on the Cancel button.
     */
//    public void cancelButtonClicked() {
//	PublicationEditModel currentEditModel = (PublicationEditModel)objectEditModel;
//	PublicationEditModel previousEditModel = (PublicationEditModel)previousModel;
//	previousEditModel.setAppearanceEditModels(currentEditModel.getAppearanceEditModels());
//	Enumeration e = currentEditModel.getAuthorEditModels().elements();
//	while(e.hasMoreElements()) {
//	    previousEditModel.addAuthor((AuthorEditModel)e.nextElement());
//	}
//	super.cancelButtonClicked();
//    }
    
    public void setAuthorEditPanel(AuthorEditPanel authorEditPanel)
    {
	if(this.authorEditPanel == authorEditPanel)
	    return;

	if(this.authorEditPanel != null)
	    this.authorEditPanel.setPublicationEditPanel(null);

	this.authorEditPanel = authorEditPanel;
	if(this.authorEditPanel != null)
	    this.authorEditPanel.setPublicationEditPanel(this);
    }
    
    public AuthorEditPanel getAuthorEditPanel()
    {
	return authorEditPanel;
    }

    public void mouseDoubleClicked(MouseEvent e)
    {
	Object source = e.getSource();
	if (source != editor.authorList && source != editor.appearanceList)
	    return;
	
	editor.model.updateSummary();
	if (source == editor.authorList)
	    selectAuthor(isEditable() && 
			 (editor.authorList.getSelectedModel() == editor.authorList.getDummyModel() ||
			  e.getY() >=  editor.authorList.getLastBaseLine()));
	else if (source == editor.appearanceList)
	    selectAppearance(isEditable() &&
			     (editor.appearanceList.getSelectedModel() == editor.appearanceList.getDummyModel() ||
			      e.getY() >=  editor.appearanceList.getLastBaseLine()));
    }
    
    public void updateView() {
	this.editor.updateView();
	getPublicationEditModel().updateList();
    }
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent event) {
	Object source = event.getSource();
	if(source == createNewAuthorMenuItem) {
	    selectAuthor(true);
	} else if (source == createNewAppearanceMenuItem) {
	    selectAppearance(true);
	}
    }
    
    protected void selectAuthor() {
	selectAuthor(false);
    }
    
    protected void selectAuthor(boolean forceNewCreate) {
	AuthorEditModel authorEditModel = (AuthorEditModel)editor.authorList.getSelectedModel();
	if (authorEditModel == editor.authorList.getDummyModel() ||
	    authorEditModel == null)
	    forceNewCreate = true;

	if (forceNewCreate) {
	    // create new record
	    editor.authorList.deselect(this.editor.authorList.getSelectedIndex());
	    authorEditModel = new AuthorEditModel();
	    NamedObjectListModel authorListModel = ((PublicationEditModel) getModel()).getAuthorList();
	    if(editor.getAuthorList().getRows() == authorListModel.getItemCount() + 1){
		editor.getAuthorList().invalidate();
		authorListModel.enableDummyModel(isEditable());
		editor.getAuthorList().validate();
	    }
	}
	((PublicationEditModel) getModel()).addAuthor(authorEditModel);
	authorEditModel.add((PublicationEditModel) getModel());
	authorEditPanel.setModel(authorEditModel);
	getTabbedPane().setSelectedIndex(TabbedPane.V_TABINDEX_AUTHOR);
    }
    
    protected void selectAppearance() {
	selectAppearance(false);
    }
    
    protected void selectAppearance(boolean forceNewCreate)
    {
	AppearanceEditModel appearanceEditModel = (AppearanceEditModel)editor.appearanceList.getSelectedModel();
	if (appearanceEditModel == editor.appearanceList.getDummyModel() ||
	    appearanceEditModel == null)
	    forceNewCreate = true;

	if (forceNewCreate) {
	    // create new record.
	    this.editor.appearanceList.deselect(this.editor.appearanceList.getSelectedIndex());
	    appearanceEditModel = new AppearanceEditModel((PublicationEditModel) getModel());
	    NamedObjectListModel appearanceListModel = ((PublicationEditModel) getModel()).getAppearanceTextListModel();
	    if(editor.getAppearanceList().getRows() == appearanceListModel.getItemCount() + 1){
		editor.appearanceList.invalidate();
		appearanceListModel.enableDummyModel(isEditable());
		editor.appearanceList.validate();
	    }
	}
	((PublicationEditModel) getModel()).addAppearance(appearanceEditModel);
	appearanceEditModel.setPublicationEditModel((PublicationEditModel) getModel());
	appearanceEditPanel.setModel(appearanceEditModel);
	getTabbedPane().setSelectedIndex(TabbedPane.V_TABINDEX_APPEARANCE);
    }

    /*
    public void keyPressed(KeyEvent e) {
    	int a = 9;
    }
	public void keyReleased(KeyEvent e) {
		int a = 8;
	}
	
	public void keyTyped(KeyEvent e) {
		int a = 7;
	}
    */

    public void putUnsavedObject()
    {
	if(isModified()) {
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    Publication p = getPublication();
	    broker.putUnsavedObjects(p.getAuthors());
	    broker.putUnsavedObjects(p.getAppearances());
	    broker.putUnsavedObjects(p.getContents());
	}
	super.putUnsavedObject();
    }
}
