/*
 * PublicationEditor.java:  an interface of PublicationEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2000, 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: PublicationEditor.java,v 1.4 2002/02/24 18:13:36 nozomi Exp $
 * $Log: PublicationEditor.java,v $
 * Revision 1.4  2002/02/24 18:13:36  nozomi
 * re-implementation of setModel() to be used switching between models
 *
 * Revision 1.3  2002/02/05 18:05:52  nozomi
 * Add summary's visibility accessor/modifier
 *
 * Revision 1.2  2002/01/29 06:59:21  nozomi
 * Changed from class to interface
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.editor;

import org.nomencurator.Publication;

import org.nomencurator.editor.model.PublicationEditModel;

/**
 * Interface for graphical component wrapping
 * <code>PublicationEditModel</code>.
 *
 * @see org.nomencurator.editor.model.PublicationEditModel
 * @see org.nomencurator.Publication
 *
 * @version 	24 Feb 2002
 * @author 	Nozomi `James' Ytow
 */
public interface PublicationEditor
    extends NamedObjectEditor
{
    /**
     * Gets <code>PublicationEditModel</code> accompanying with this editor
     *
     * @return PublicationEditModel accompanying with this editor
     */
    public PublicationEditModel getPublicationEditModel();

    /**
     * A utility method to get <code>Publication</code> under edition
     *
     * @return Publication under edition
     */
    public Publication getPublication();

    /**
     * A utility method to set <code>publication</code> as
     * target of edition by accompanying <code>PublicationEditModel</code>
     *
     * @param publication to be set as target <code>Publication</code>
     */
    public void setPublication(Publication publication);

    /**
     * Returns boolean determining summary's visibility
     *
     * @return true if summary of the <code>Publication</code> is visible
     */
    public boolean isSummaryVisible();

    /**
     * Sets <code>visibility</code> of summary
     *
     * @param visibility true to make summary of the <code>Publication</code> visible
     */
    public void setSummaryVisible(boolean visibility);

}

