/*
 * PublicationNewMenuDialog.java: 
 *
 * Copyright (c) 2002 t.okada
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: PublicationNewMenuDialog.java,v 1.2 2002/08/26 05:12:07 t.okada Exp $
 * $Log: PublicationNewMenuDialog.java,v $
 * Revision 1.2  2002/08/26 05:12:07  t.okada
 * change dialog design
 *
 * Revision 1.1  2002/06/04 13:58:37  t.okada
 * add PublicationNewMenuDialog
 *
 *
 */

package org.nomencurator.editor;

import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.Button;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

public class PublicationNewMenuDialog
extends Dialog
implements ActionListener {

	protected Frame frame;
	static protected final String L_TITLE = "Enter New Publication";
	static public final String CURRENT_WINDOW = "Clear Current Window";
	static public final String NEW_WINDOW = "Create New Window";
	static public final String OK = "Ok";
	static public final String CANCEL = "Cancel";

	protected Button okButton;
	protected Button cancelButton;
	protected BorderedPanel borderedPanel;
	protected Panel radioPanel;
	protected Panel buttonPanel;
	protected CheckboxGroup radios;
	protected Checkbox radio1;
	protected Checkbox radio2;
	protected String pushedButton = null;

	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 */
	public PublicationNewMenuDialog(Frame frame) {
		this(frame, L_TITLE);
	}

	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 * @param title the title of the dialog
	 */
	public PublicationNewMenuDialog(Frame frame, String title) {
		super(frame, title);
		this.frame = frame;
		init();
	}

	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 * @param title the title of the dialog
	 * @param modal if true, dialog blocks input to other app windows when shown
	 */
	public PublicationNewMenuDialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		this.frame = frame;
		init();
	}

	/**
	 * Initialize this dialog
	 */
	protected void init() {
		radioPanel = new Panel();
		radioPanel.setLayout(new GridLayout(3, 1));

		radios = new CheckboxGroup();
		
		radio1 = new Checkbox(CURRENT_WINDOW, true, radios);
		radioPanel.add(radio1);
		
		radio2 = new Checkbox(NEW_WINDOW, false, radios);
		radioPanel.add(radio2);
		
		buttonPanel = new Panel();
		buttonPanel.setLayout(new GridLayout(1, 2));

		okButton = new Button(OK);
		buttonPanel.add(okButton);
		okButton.addActionListener(this);

		cancelButton = new Button(CANCEL);
		buttonPanel.add(cancelButton);
		cancelButton.addActionListener(this);

		radioPanel.add(buttonPanel);
		
		add(radioPanel, BorderLayout.CENTER);

		//setBounds(0, 0, 550, 400);
		pack();
	}

	/**
	 * Invoked when an action occurs.
	 * @param e action event.
	 */
	public void actionPerformed(ActionEvent e) {
	    if(e.getSource() == okButton) {
	    	pushedButton = radios.getSelectedCheckbox().getLabel();
		} else {
			pushedButton = CANCEL;
		}
		this.dispose();
	}

	/**
	 * Get pushed button.
	 * @return pushedButton.
	 */
	public String getPushedButton() {
		return pushedButton;
	}
	
}