/*
 * SearchView.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: SearchView.java,v 1.23 2002/09/09 03:14:08 nozomi Exp $
 * $Log: SearchView.java,v $
 * Revision 1.23  2002/09/09 03:14:08  nozomi
 * support sorting and resorting of results
 *
 * Revision 1.22  2002/09/06 02:03:53  nozomi
 * change L&F
 *
 * Revision 1.21  2002/09/05 06:30:23  nozomi
 * fix null-button handling bug
 *
 * Revision 1.20  2002/09/05 05:20:40  nozomi
 * support multiple object get
 *
 * Revision 1.19  2002/09/05 03:43:50  nozomi
 * add methods to get selected NameUsages
 *
 * Revision 1.18  2002/09/03 17:06:36  nozomi
 * create Comparator Frame each time
 *
 * Revision 1.17  2002/09/02 15:43:05  nozomi
 * fix to use getName(), instead of getUsedName()
 *
 * Revision 1.16  2002/09/01 10:51:13  nozomi
 * change method name from set/setName to set/getUsedName
 *
 * Revision 1.15  2002/08/31 01:51:53  nozomi
 * update table at once
 *
 * Revision 1.14  2002/08/28 00:24:27  nozomi
 * support ComparatorPanel
 *
 * Revision 1.13  2002/08/25 20:55:27  nozomi
 * remove debugging println()
 *
 * Revision 1.12  2002/08/22 08:43:55  ryo
 * add focusedEditor member and setEditor()
 *
 * Revision 1.11  2002/08/14 15:24:25  nozomi
 * table-less construction with lines < 1
 *
 * Revision 1.10  2002/06/17 09:50:06  ryo
 * add null check for rowList
 *
 * Revision 1.9  2002/06/03 12:17:53  t.okada
 * changes into NamedObjectBroker from SearchController.
 *
 * Revision 1.8  2002/05/16 11:25:08  ryo
 * add getSelectedName() and some functions
 *
 * Revision 1.7  2002/05/15 12:02:43  ryo
 * add getSelectedOid()
 *
 * Revision 1.6  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.5  2002/03/28 06:32:03  okawa
 * add copyright
 *
 * Revision 1.4  2002/03/11 02:35:21  okawa
 * modify bug in adding multiple lines
 *
 * Revision 1.3  2002/03/10 11:02:51  nozomi
 * lines can be specified
 *
 * Revision 1.2  2002/02/28 23:56:56  okawa
 * modify bug in displaying table rows
 *
 * Revision 1.1  2002/02/14 01:59:15  okawa
 * initial import into CVS
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import jp.kyasu.awt.Panel;
import jp.kyasu.awt.Button;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextField;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.DefaultTextListModel;

import jp.kyasu.editor.Editor;

import jp.kyasu.util.Sorter;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;

import org.nomencurator.NameUsage;

import org.nomencurator.broker.NamedObjectBroker;

import org.nomencurator.controller.PreferenceManager;

import org.nomencurator.editor.NameUsageSearchListModel;

import org.nomencurator.editor.model.NameTreeModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.NameUsageNode;

import org.nomencurator.util.Comparer;

import java.util.Vector;
import java.util.Enumeration;

public class SearchView
    extends Panel
    implements ActionListener, ItemListener
{
    private TextField nameField;
    private TextField authorField;
    private TextField yearField;
    protected Button searchButton;
    protected Button compareButton;
    protected static String compareTitle = "compare";
    protected Button addToComparatorButton;
    protected static String addToComparatorTitle = "add to comparator";

    protected ComparatorPanel comparator;

    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private GridBagConstraints table_c;
    protected TableList table;
    protected Button[] tableButtons;

    /** <CODE>Editor</CODE> handling <CODE>TextComponent</CODE>s */
    protected Editor focusedEditor;

    protected Object[] result;

    protected Sorter sorter;

    static public final String L_NAME = "Name";
    static public final String L_AUTHOR = "Author";
    static public final String L_YEAR = "Year";
    static public final String[] L_COLUMNNAMES = new String[]{"Name", "Author", "Year"};

    /**
     * Constractor
     */
    public SearchView()
    {
	this(5);
    }

    /**
     * Constractor
     */
    public SearchView(boolean compare)
    {
	this(5, compare);
    }

    public SearchView(int lines)
    {
        this(lines, true);
    }

    public SearchView(int lines, boolean compare)
    {
        super();
        _init(lines, compare);
	sorter = new Sorter(new Comparer());
    }

    /**
     * Initialaize this panel
     */
    private void _init(int lines, boolean compare)
    {

        nameField   = new TextField(15);
        authorField = new TextField(10);
        yearField   = new TextField(5);
        searchButton = new Button("Search");
        searchButton.addActionListener(this);


	
	setLayout(gbl);
	
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 0.5;
	c.weighty = 0.1;
	c.gridwidth = 1;
	c.gridheight = 1;
	c.insets = new Insets(1, 1, 1, 1);
	c.fill = c.BOTH;
	c.anchor = c.NORTH;
        Label name = new Label(L_NAME);
        add(name, c);
	
        c.gridx++;
        Label author = new Label(L_AUTHOR);
	add(author, c);
	
        c.gridx++;
        Label year = new Label(L_YEAR);
	add(year, c);
	
	c.gridx = 0;
	c.gridy++;
	add(nameField, c);
	
	c.gridx++;
	add(authorField, c);
	
	c.gridx++;
	add(yearField, c);
	c.gridx++;
	/*
	c.gridx = 3;
	c.gridwidth = 1;
	c.gridy++;
	*/
	add(searchButton, c);
	
	if(lines < 1)
	    return;
	c.gridy++;
	c.gridx = 0;
	c.gridwidth = 4;
	add(createTableList(lines), c);
	table_c = (GridBagConstraints)c.clone();
	c.gridy++;

	if(!compare)
	    return;

	compareButton = new Button(compareTitle);
	compareButton.addActionListener(this);
	compareButton.setEnabled(false);
	c.gridx = 2;
	c.gridwidth = 1;
	add(compareButton, c);

	addToComparatorButton = new Button(addToComparatorTitle);
	addToComparatorButton.addActionListener(this);
	addToComparatorButton.setEnabled(false);
	c.gridx++;
	add(addToComparatorButton, c);

    }
    
    /**
     * Create Table List
     * @return TableList table
     */
    protected TableList createTableList(int lines)
    {
	/*
        table = new TableList(new NameUsageSearchListModel(3, new int[]{ 100, 80, 40 }), lines,
			      L_COLUMNNAMES);
	*/
	int[] width = TableList.columnWidths(L_COLUMNNAMES);
	width [0] *= 4;
	width [1] *= 2;
        table = 
	    new TableList(new NameUsageSearchListModel(3, width), 
			  lines,
			  L_COLUMNNAMES);
	table.setSelectionMode(TableList.SHIFT_MULTIPLE_SELECTIONS);
	table.addActionListener(this);
	table.addItemListener(this);
	tableButtons = table.getButtons();
	for(int i = 0; i < tableButtons.length; i++)
	    tableButtons[i].addActionListener(this);
	
	return table;
    }
    
    /**
     * @param ActionEvent e
     */
    public void actionPerformed(ActionEvent e) {
	Object source = e.getSource();
        if(source == table) {
    	} else if(source == searchButton) {
    	    search();
    	}
	else if(source == compareButton) {
	    /*
	    if(comparator == null) {
	    */
		comparator = new ComparatorPanel();
		jp.kyasu.awt.Frame f = new jp.kyasu.awt.Frame("Hierarchies/History viewer");
		f.add(comparator);
		//		f.pack();
		//f.setVisible(true);
		/*
	    }
	    else {
		comparator.removeAll();
		comparator.invalidate();
		comparator.validate();
	    }
		*/
	    comparator.getParent().setVisible(false);
	    addSelectedTree();
	    ((jp.kyasu.awt.Frame)comparator.getParent()).pack();
	    comparator.getParent().setVisible(true);
	}
	else if(source == addToComparatorButton) {
	    addSelectedTree();
	    comparator.invalidate();
	    comparator.validate();
	}
	else {
	    int i = 0;
	    for(i = 0; i < tableButtons.length; i++) {
		if(source == tableButtons[i])
		    break;
	    }
	    if(i < tableButtons.length) {
		Comparer c = (Comparer)sorter.getComparer();
		int current = c.getNameUsageListRowCompareMode();
		if(i == current)
		    c.flipSearchDirection();
		c.setNameUsageListRowCompareMode(i);
		redisplayResult();
	    }
	}
    }

    protected void addSelectedTree()
    {
	int[] selected = table.getSelectedIndexes();
	NameUsage nameUsage = null;
	int higher = PreferenceManager.getInstance().getHigherCount();
	int lower = PreferenceManager.getInstance().getLowerCount();

	for(int i = 0; i < selected.length; i++) {
	    //	    nameUsage = new NameUsage(((NameUsageSearchListModel)table.getModel()).getOid(selected[i]));
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();

	    //nameUsage = (NameUsage)broker.getNamedObject(((NameUsageSearchListModel)table.getModel()).getOid(selected[i]));
	    nameUsage = 
		broker.getNameUsageTree(((NameUsageSearchListModel)table.getModel()).getOid(selected[i]),
					PreferenceManager.getInstance().getHigherCount(),
					PreferenceManager.getInstance().getLowerCount());
	    if(nameUsage == null) {
		nameUsage = new NameUsage(((NameUsageSearchListModel)table.getModel()).getOid(selected[i]));
		broker.putNamedObject(nameUsage);
	    }

	    NameUsageEditModel nameUsageEditModel =
		broker.getNamedObjectEditModelTree(nameUsage,
						   PreferenceManager.getInstance().getHigherCount(),
						   PreferenceManager.getInstance().getLowerCount());
	    nameUsage = nameUsageEditModel.getNameUsage();
	    /*
	    comparator.addHierarchy(new TreeTable(createTreeNode(nameUsageEditModel), 
						  10, 
						  nameUsageEditModel.getViewName()));
	    */
	    NameTreeModel tree = getTree(nameUsage);
	    comparator.addHierarchy(new TreeTable(tree, 10, tree.getViewName()));

	}
	selected = null;
	nameUsage = null;
    }

    protected NameTreeModel getTree(NameUsage nameUsage)
    {
	NamedObjectBroker broker = NamedObjectBroker.getInstance();
	String name = nameUsage.getName();
	NameUsageNode nameUsageNode = (NameUsageNode)broker.getNode(name);
	NameTreeModel tree = null;
	if(nameUsageNode != null)
	    tree = broker.getTree(((NameUsageNode)(nameUsageNode.getRoot())).getName());
	if(tree== null)
	    tree = broker.getTree(name);
	if(tree == null) {
	    nameUsageNode = (NameUsageNode)broker.getNode(name);
	    if(nameUsageNode == null) {
		NameUsageEditModel model = (NameUsageEditModel)broker.getModel(name);
		if(model == null) {
		    model = new NameUsageEditModel(nameUsage);
		    broker.putModel(model);
		}
		nameUsageNode = new NameUsageNode(model);
		broker.putNode(nameUsageNode);
		createTreeNode(nameUsageNode, model);
	    }
	    tree = new NameTreeModel(nameUsageNode);
	    broker.putTree(tree);
	}
	return tree;
    }

    protected NameUsageNode createTreeNode(NameUsageEditModel nameUsageEditModel)
    {
	NamedObjectBroker broker = NamedObjectBroker.getInstance();
	NameUsageNode nameUsageNode = 
	    (NameUsageNode)broker.getNode(nameUsageEditModel.getName());
	if(nameUsageNode == null) {
	    nameUsageNode = new NameUsageNode(nameUsageEditModel);
	    broker.putNode(nameUsageNode);
	}
	createTreeNode(nameUsageNode, nameUsageEditModel);
	return nameUsageNode;
    }

    protected void createTreeNode(NameUsageNode nameUsageNode, NameUsageEditModel nameUsageEditModel) {
	NamedObjectBroker broker = NamedObjectBroker.getInstance();
	if(nameUsageEditModel.getLowerEditModels() != null) {
	    int n = nameUsageEditModel.getLowerEditModels().size();
	    for(int i = 0; i < n; i++) {
		NameUsageEditModel nuEditModel = (NameUsageEditModel)nameUsageEditModel.getLowerEditModels().elementAt(i);
		NameUsageNode nuNode = 
		    (NameUsageNode)broker.getNode(nuEditModel.getName());
		if(nuNode == null) {
		    nuNode = new NameUsageNode(nuEditModel);
		    broker.putNode(nuNode);
		}
		nameUsageNode.add(nuNode);
		createTreeNode(nuNode, nuEditModel);
	    }
	}
    }

    
    /**
     * @param ItemEvent e
     */
    public void itemStateChanged(ItemEvent e) {
        if(e.getSource() == table) {
	    if(compareButton != null) {
		if(e.getStateChange() == ItemEvent.SELECTED) {
		    if(table.getSelectedIndexes().length > 1) {
			compareButton.setEnabled(true);
			if(comparator != null)
			    addToComparatorButton.setEnabled(true);
		    }
		    else {
			if(compareButton.isEnabled())
			    compareButton.setEnabled(false);
			if(comparator != null)
			    addToComparatorButton.setEnabled(true);
		    }
		}
		else {
		    if(compareButton.isEnabled())
			compareButton.setEnabled(false);
		    if(addToComparatorButton.isEnabled())
			addToComparatorButton.setEnabled(false);
		}
	    }
    	}
    }
    
    /**
     * @param ItemListener l
     */
    public void addTableItemListener(ItemListener l) {
        table.addItemListener(l);
    }
    
    /**
     * @param ItemListener l
     */
    public void removeTableItemListener(ItemListener l) {
        table.removeItemListener(l);
    }
    
    /**
     * @return TableList table
     */
    public TableList getTable() {
        return table;
    }
    
    /**
     * Search NameUsage information
     */
    public void search() {
        ((NameUsageSearchListModel)table.getModel()).removeAll();
	result = null;
        NamedObjectBroker broker = NamedObjectBroker.getInstance();
        Vector rowList = broker.getNameUsageList(getName(), getAuthor(), getYear());

	if(rowList == null || rowList.isEmpty())
	    return;

	result = rowList.toArray();
	redisplayResult();
    }

    protected void redisplayResult()
    {
	if(result == null || result.length == 0)
	    return;
	sorter.quicksort(result, 0, result.length - 1);

	String[][] items = new String[result.length][];
	NameUsageSearchListModel model = 
	    (NameUsageSearchListModel)table.getModel();
	int i = 0;
	for ( ; i < result.length; i++) {
	    NameUsageListRow row = (NameUsageListRow)result[i];
	    items[i] = row.toStringArray();
	    model.addOid(row.getObjectId());
	}
	if(i != 0)
	    model.replaceItems(0, model.getItemCount(), items);
	items = null;
    }
    
    /**
     * get the String in Name TextField
     */
    public String getName() {
	return nameField.getText();
    }
    
    /**
     * get the String in Author TextField
     */
    public String getAuthor() {
	return authorField.getText();
    }
    
    /**
     * get the String in Year TextField
     */
    public String getYear() {
	return yearField.getText();
    }

    /**
     * Get selected objtect ID.
     * @return Object ID
     */
    public String getSelectedOid() {
	String oid = null;
	if (table.getItemCount() > 0) {
	    oid = ((NameUsageSearchListModel)table.getModel()).getOid(table.getSelectedIndex());
	}
	return oid;
    }
    
    /**
     * Get name string.
     * @return name
     */
    public String getSelectedName() {
	return (((NameUsageSearchListModel)table.getModel()).getItem(table.getSelectedIndex(), 0)).toString();
    }
    
    /**
     * Get author string
     * @return author
     */
    public String getSelectedAuthor() {
	return (((NameUsageSearchListModel)table.getModel()).getItem(table.getSelectedIndex(), 1)).toString();
    }
    
    /**
     * Get year string.
     * @return year
     */
    public String getSelectedYear() {
	return (((NameUsageSearchListModel)table.getModel()).getItem(table.getSelectedIndex(), 2)).toString();
    }
    
    /**
     * Sets <CODE>ed</CODE> as <CODE>Editor</CODE> of <CODE>TextComponent</CODE>s
     * to provide <CODE>Text</CODE> handling using GUI.
     *
     * @param ed <CODE>Editor</CODE> to be linked to <CODE>TextComponent</CODE>s
     * of this
     */
    public void setEditor(Editor ed) {
	if (focusedEditor == ed)
	    return;
	if (focusedEditor != null) {
	    focusedEditor.unlisten(nameField);
	    focusedEditor.unlisten(authorField);
	    focusedEditor.unlisten(yearField);
	}
	focusedEditor = ed;
	if (focusedEditor != null) {
	    focusedEditor.listen(nameField);
	    focusedEditor.listen(authorField);
	    focusedEditor.listen(yearField);
	}
    }

    public void setComparator(ComparatorPanel comparator)
    {
	if(this.comparator == comparator)
	    return;

	this.comparator = comparator;
    }

    public int getSelectedIndex()
    {
	return table.getSelectedIndex();
    }

    public int[] getSelectedIndexes()
    {
	return table.getSelectedIndexes();
    }

    public NameUsage getNameUsage(int index)
    {
	if(index < 0)
	    return null;

	NamedObjectBroker broker = NamedObjectBroker.getInstance();

	return (NameUsage)broker.getNamedObject(((NameUsageSearchListModel)table.getModel()).getOid(index));
    }

    public NameUsage getSelectedNameUsage()
    {
	return getNameUsage(table.getSelectedIndex());
    }

    public Vector getSelectedNameUsages()
    {
	int[] indices = table.getSelectedIndexes();
	int nameCount = indices.length;

	if(nameCount == 0)
	    return null;

	Vector names = new Vector(nameCount);
	for(int i = 0; i < nameCount; i++)
	    names.addElement(getNameUsage(indices[i]));

	return names;
    }

    public NameUsageEditModel getNameUsageEditModel(int index)
    {
	if(index < 0)
	    return null;

	NamedObjectBroker broker = NamedObjectBroker.getInstance();

	String name = ((NameUsageSearchListModel)table.getModel()).getOid(index);
	NameUsageEditModel model = 
	    (NameUsageEditModel)broker.getModel(name);
	if(model == null) {
	    model = new NameUsageEditModel((NameUsage)broker.getNamedObject(name));
	    broker.putModel(model);
	}
	return model;
    }

    public NameUsageEditModel getSelectedNameUsageEditModel()
    {
	return getNameUsageEditModel(table.getSelectedIndex());
    }

    public Vector getSelectedNameUsageEditModels()
    {
	int[] indices = table.getSelectedIndexes();
	int nameCount = indices.length;

	if(nameCount == 0)
	    return null;

	Vector names = new Vector(nameCount);
	for(int i = 0; i < nameCount; i++)
	    names.addElement(getNameUsageEditModel(indices[i]));

	return names;
    }

    public void requestFocus()
    {
	nameField.requestFocus();
    }

}
