/*
 * ShoppingListDialog.java:  a Dialg to edit a shopping list
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ShoppingListDialog.java,v 1.3 2002/10/15 17:13:31 nozomi Exp $
 * $Log: ShoppingListDialog.java,v $
 * Revision 1.3  2002/10/15 17:13:31  nozomi
 * change frame name
 *
 * Revision 1.2  2002/10/11 06:41:55  nozomi
 * invalidate/validate in addModel()
 *
 * Revision 1.1  2002/10/11 06:19:39  nozomi
 * introduce a shopping list
 *
 */

package org.nomencurator.editor;

import java.awt.Frame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import jp.kyasu.graphics.Text;

import jp.kyasu.awt.Button;


import org.nomencurator.Annotation;
import org.nomencurator.NamedObject;

import org.nomencurator.awt.Dialog;

import org.nomencurator.editor.model.NamedObjectEditModel;
import org.nomencurator.editor.model.GenericNamedObjectListModel;
import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.AnnotationEditModel;


/**
 * <code>Dialog</code> to edit an <code>Annotation</code>
 *
 * @see org.nomencurator.editor.model.AnnotationEditModel
 * @see org.nomencurator.editor.AnnotationEditPanel
 * @see org.nomencurator.Annotation
 *
 * @version 	15 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class ShoppingListDialog
    extends Dialog
    implements ActionListener
{
    protected List list;

    protected Button upButton;
    protected Button downButton;
    protected Button printButton;
    protected Button clearButton;
    protected Button closeButton;

    protected boolean isOK;
    
    public ShoppingListDialog(Frame frame)
    {
	super(frame, "Notelet", false);
	setSize(getPreferredSize());
    }

    protected void createButtons()
    {
	upButton = new Button("Up");
	upButton.addActionListener(this);
	downButton = new Button("Down");
	downButton.addActionListener(this);
	printButton = new Button("Print");
	printButton.addActionListener(this);
	clearButton = new Button("Clear");
	clearButton.addActionListener(this);
	closeButton = new Button("Close");
	closeButton.addActionListener(this);
    }

    protected void createPanels()
    {
	south = new Panel();
	center = new Panel();
	list = new List(new GenericNamedObjectListModel(false), 10);
	center.add(list);
    }

    protected void addComponents()
    {
	south.add(upButton);
	south.add(downButton);
	south.add(printButton);
	south.add(clearButton);
	south.add(closeButton);
    }

    public void actionPerformed(ActionEvent e)
    {
	Object source = e.getSource();
	int selection = list.getSelectedIndex();
	if(source == upButton) {
	    if(selection != -1)
		list.up(selection);
	}
	else if(source == downButton) {
	    if(selection != -1)
		list.down(selection);
	}
	else if(source == printButton) {

	}
	else if(source == clearButton) {
	    list.removeAllModels();
	}
	else if(source == closeButton) {
	    hide();
	}
    }

    /**
     * Adds <code>model</code> at end of model list
     *
     * @param model <code>NamedObjectEditModel</code> to be added
     */
    public boolean addModel(NamedObjectEditModel model)
    {
	list.invalidate();
	boolean result = list.addModel(model);
	validate();
	return result;
    }

    /**
     * Adds <code>model</code> at end of model list
     *
     * @param model <code>NamedObjectEditModel</code> to be added
     */
    public boolean contains(NamedObjectEditModel model)
    {
	return list.contains(model);
    }

}
