/*
 * TabbedPane.java: TabbedPane to contain NamedObjectEditors
 * for TaxoNote, based on Nomencurator data model
 *
 * Copyright (c) 2002 Hiroyuki Ohkawa
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TabbedPane.java,v 1.9 2002/05/14 10:05:13 ryo Exp $
 * $Log: TabbedPane.java,v $
 * Revision 1.9  2002/05/14 10:05:13  ryo
 * add getSelectedEditPanel()
 *
 * Revision 1.8  2002/05/09 07:14:44  ryo
 * change order of tabs
 *
 * Revision 1.7  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.6  2002/03/01 00:33:50  okawa
 * delete UIController
 *
 * Revision 1.5  2002/02/21 21:03:05  nozomi
 * Fix minor bug
 *
 * Revision 1.4  2002/02/21 20:08:26  nozomi
 * Change event handling order
 *
 * Revision 1.3  2002/02/21 19:40:59  nozomi
 * Name changed from NamedObjectTabbedPane
 *
 * Revision 1.2  2002/02/21 19:34:28  nozomi
 * Change indices numbering
 *
 */

package org.nomencurator.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.Enumeration;

import jp.kyasu.awt.event.ChangeEvent;

import org.nomencurator.editor.command.CommandController;

/**
 * A <code>jp.kyasu.awt.TabbedPane</code> that contains
 * <code>NameUsage</code>, <code>Appearance</code>, <code>Publication</code>, 
 * <code>Author</code> tab
 *
 * @version  	14 Apr 2002
 * @author 	Hiroyuki Ohkawa
 * @author 	Nozomi `James' Ytow
 */
public class TabbedPane
    extends jp.kyasu.awt.TabbedPane
{
    
    //fixed tab indices.... is it right way?  maybe...
    /** Tab index for PublicationEditor */
    static public final int V_TABINDEX_PUBLICATION = 0;

    /** Tab index for AuthorEditor */
    static public final int V_TABINDEX_AUTHOR = V_TABINDEX_PUBLICATION + 1;

    /** Tab index for AppearanceEditor */
    static public final int V_TABINDEX_APPEARANCE = V_TABINDEX_AUTHOR + 1;

    /** Tab index for NameUsageEditor */
    static public final int V_TABINDEX_NAME = V_TABINDEX_APPEARANCE + 1;

    /** The first tab index */
    static public final int V_FIRST_TABINDEX = V_TABINDEX_PUBLICATION;

    /** The last tab index */
    static public final int V_LAST_TABINDEX = V_TABINDEX_NAME;

    /** ActionListener list */
    private Vector actionListenerList = new Vector();
    
    /** value of ActionEvent */
    static public final int V_ACTIONEVENT_VALUE = 0;

    /**
     * Creates a new split panel with default tab placement
     *
     */
    public TabbedPane()
    {
	super();
    }

    /**
     * Creates a new split panel with the specified orientation.
     *
     * @param orientation the split orientation.
     */
    public TabbedPane(int placement)
    {
	super(placement);
    }

    /**
     * Creates a new split panel with the specified orientation and gaps.
     *
     * @param orientation the split orientation.
     * @param gap         the gap between components.
     */
    public TabbedPane(int placement, int gap)
    {
	super(placement, gap);
    }

    /**
     * Creates a new split panel with the specified orientation and gaps.
     *
     * @param orientation the split orientation.
     * @param gap         the gap between components.
     * @param insets      the insets of the panel.
     */
    public TabbedPane(int placement, int gap, Insets insets)
    {
	super(placement, gap, insets);
    }

    /**
     * add ActionListener to this TabbedPane
     *
     * @param ActionListener l
     */
    public void addActionListener(ActionListener l)
    {
	actionListenerList.addElement(l);
    }

    /**
     * Invoked when a tab selected to <code>notify()</code> appropriate panels
     *
     * @param changeEvent <code>ChangeEvent</code> to be handled
     */
    public void stateChanged(ChangeEvent changeEvent)
    {
        switch(getSelectedIndex()) {
            case V_TABINDEX_NAME:
                for (Enumeration e = actionListenerList.elements() ; e.hasMoreElements() ;) {
                    ActionListener l = (ActionListener)e.nextElement();
                    l.actionPerformed(new ActionEvent(this, V_ACTIONEVENT_VALUE, CommandController.A_OPEN_PANEL_NAME));
                }
                break;
            case V_TABINDEX_APPEARANCE:
                for (Enumeration e = actionListenerList.elements() ; e.hasMoreElements() ;) {
                    ActionListener l = (ActionListener)e.nextElement();
                    l.actionPerformed(new ActionEvent(this, V_ACTIONEVENT_VALUE, CommandController.A_OPEN_PANEL_APPEARANCE));
                }
                break;
            case V_TABINDEX_PUBLICATION:
                for (Enumeration e = actionListenerList.elements() ; e.hasMoreElements() ;) {
                    ActionListener l = (ActionListener)e.nextElement();
                    l.actionPerformed(new ActionEvent(this, V_ACTIONEVENT_VALUE, CommandController.A_OPEN_PANEL_PUBLICATION));
                }
                break;
            case V_TABINDEX_AUTHOR:
                for (Enumeration e = actionListenerList.elements() ; e.hasMoreElements() ;) {
                    ActionListener l = (ActionListener)e.nextElement();
                    l.actionPerformed(new ActionEvent(this, V_ACTIONEVENT_VALUE, CommandController.A_OPEN_PANEL_AUTHOR));
                }
                break;
            default:
                break;
        }

        super.stateChanged(changeEvent);
    }

	public NamedObjectEditPanel getSelectedEditPanel() {
		return (NamedObjectEditPanel)this.pane.getComponent(getSelectedIndex());
	}

}
