/*
 * TabbedTable.java: A TabbedPane containing a TableList
 * to compare hierarchies and to show a hisoty of names
 * for TaxoNote, based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TabbedTable.java,v 1.3 2002/08/14 07:48:31 nozomi Exp $
 * $Log: TabbedTable.java,v $
 * Revision 1.3  2002/08/14 07:48:31  nozomi
 * fix ItemEvent handler bug
 *
 * Revision 1.2  2002/08/14 07:44:47  nozomi
 * single click of column title button to switch other TabbedTable
 *
 * Revision 1.1  2002/08/14 07:41:37  nozomi
 * initial import to CVS repository
 *
 */

package org.nomencurator.editor;

import java.awt.Component;
import java.awt.Insets;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.TabbedPane;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.TextListModel;

import jp.kyasu.awt.event.ChangeEvent;

import jp.kyasu.graphics.Icon;

/**
 * A <CODE>TabbedPane</CODE> holding <CODE>TableList</CODE>.
 *
 * @version  	14 Aug 2002
 * @author 	Nozomi `James' Ytow
 */

public class TabbedTable
    extends TabbedPane
    implements // ChangeListener,
	       ItemListener,
	       MouseListener
{
    /**
     * Creates a new split panel with default tab placement
     *
     */
    public TabbedTable()
    {
	super();
    }

    /**
     * Creates a new split panel with the specified orientation.
     *
     * @param orientation the split orientation.
     */
    public TabbedTable(int placement)
    {
	super(placement);
    }

    /**
     * Creates a new split panel with the specified orientation and gaps.
     *
     * @param orientation the split orientation.
     * @param gap         the gap between components.
     */
    public TabbedTable(int placement, int gap)
    {
	super(placement, gap);
    }

    /**
     * Creates a new split panel with the specified orientation and gaps.
     *
     * @param orientation the split orientation.
     * @param gap         the gap between components.
     * @param insets      the insets of the panel.
     */
    public TabbedTable(int placement, int gap, Insets insets)
    {
	super(placement, gap, insets);
    }

    /**
     * Inserts <code>component</code> which is corresponding to either of <code>title</code>
     * or <code>icon</code> (one of them may be null), or both,  at <code>index</code>.
     * It uses <code>java.util.Vector</code> internally.  See <code>insertElementAt</code>
     * for detail of insertion.
     *
     * @param title title to be shown on the tab
     * @param icon icon to be shown on the tab
     * @param component <code>Component</code> to be shown when the tab is clicked
     * @param tip tool hint shown for the tab
     * @param index position where the tab to be inserted
     *
     * @see addTab(String, Icon, Component, String)
     * @see removeTabAt(int)
     */
    public void insertTab(String title,
			  Icon icon,
			  Component component,
			  String tip,
			  int index)
    {
	super.insertTab(title, icon, component, tip, index);
	if(component instanceof TableList) {
	    Button[] buttons = ((TableList)component).getColumnButtons();
	    for(int i = 0; i < buttons.length; i++) {
		buttons[i].addMouseListener(this);
	    }
	}
    }

    /**
     *
     * Removes tab at <code>index</code>.
     * It sets visibility of the removed component true to make sure
     * that the component will be visible when it will be added to
     * other container.
     *
     * @param index of tab to be removed
     *
     * @see addTab(String, Icon, Component, String)
     * @see insertTab(String, Icon, Component, String, int)
     */
    public void removeTabAt(int index)
    {
	Component component = getComponentAt(index);
	super.removeTabAt(index);
	if(component instanceof TableList) {
	    Button[] buttons = ((TableList)component).getColumnButtons();
	    for(int i = 0; i < buttons.length; i++) {
		buttons[i].removeMouseListener(this);
	    }
	}
    }


    /**
     * Invoked when mouse clicked on <code>Button</code>s
     *
     * @param event <code>MouseEvent</code> to be handled
     */
    public void mouseClicked(MouseEvent e)
    {
	Object source = e.getSource();
	if(!(source instanceof Button))
	    return;
	Button button = (Button)source;
	Component component = getSelectedComponent();
	if(!(component instanceof TableList))
	    return;

	Button[] buttons = ((TableList)component).getColumnButtons();
	int index = 0;
	for(; index < buttons.length; index++) {
	    if(button == buttons[index])
		break;
	}
	if(index == buttons.length)
	    return;

	ItemEvent event = 
	    new ItemEvent((TableList)component, ItemEvent.ITEM_STATE_CHANGED,
			  getTitleAt(index), ItemEvent.SELECTED);
	itemListeners.itemStateChanged(event);
    }

    public void itemStateChanged(ItemEvent e)
    {
	if(e.getSource() instanceof TableList) {
	    int index = 0;
	    int tabCount = getTabCount();
	    String title = (String)e.getItem();
	    while(index < tabCount &&
		  ! title.equals(getTitleAt(index)))
		index++;

	    if(index < tabCount)
		setSelectedIndex(index);
	}
    }


    /**
     * Invoked when mouse released on <code>Button</code>s
     *
     * @param event <code>MouseEvent</code> to be handled
     */
    public void mousePressed(MouseEvent event)
    {
	//do nothing
    }

    /**
     * Invoked when mouse released on <code>Button</code>s
     *
     * @param event <code>MouseEvent</code> to be handled
     */
    public void mouseReleased(MouseEvent event)
    {
	//do nothing
    }

    /**
     * Invoked when mouse enters to <code>Button</code>s area
     *
     * @param event <code>MouseEvent</code> to be handled
     */
    public void mouseEntered(MouseEvent event)
    {
	//do nothing
    }

    /**
     * Invoked when mouse exits from <code>Button</code>s area
     *
     * @param event <code>MouseEvent</code> to be handled
     */
    public void mouseExited(MouseEvent event)
    {
	//do nothing
    }

    public void stateChanged(ChangeEvent event)
    {
    }
}
