/*
 * TaxoNote.java:  controlling GUI components
 * for TaxoNote, based on Nomencurator data model
 *
 * Copyright (c) 2001, 2002 Maki Kanbara, Hcc-Network 
 * Copyright (c) 2002 Nozomi `James' Ytow
 * Copyright (c) 2002 Ryo FUJIMOTO
 * Copyright (c) 2002 T Okada
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TaxoNote.java,v 1.92 2002/10/11 03:45:03 nozomi Exp $
 * $Log: TaxoNote.java,v $
 * Revision 1.92  2002/10/11 03:45:03  nozomi
 * add ShoppingList
 *
 * Revision 1.91  2002/10/09 14:47:38  nozomi
 * remove debugging message
 *
 * Revision 1.90  2002/10/07 14:33:54  nozomi
 * EditAdatpor customised for TaxoNote
 *
 * Revision 1.89  2002/09/26 05:14:37  ryo
 * add linkage creation between *EditPanel
 *
 * Revision 1.88  2002/09/25 11:37:57  ryo
 * modify model and panel creation
 *
 * Revision 1.87  2002/09/20 18:57:28  nozomi
 * fix two authors at beginning
 *
 * Revision 1.86  2002/09/17 08:36:51  nozomi
 * modify model and panel cration
 *
 * Revision 1.85  2002/09/07 04:36:28  nozomi
 * returns unsaved Vector
 *
 * Revision 1.84  2002/09/07 03:24:50  nozomi
 * remove debug info
 *
 * Revision 1.82  2002/09/06 16:40:56  nozomi
 * check whether NamedObejcts to be saved is already contained in saving Vector
 *
 * Revision 1.81  2002/09/06 08:52:56  nozomi
 * cope with unusedObjectPool
 *
 * Revision 1.80  2002/09/04 14:15:40  t.okada
 * NameTree PopupMenu corrects a multiplication bug.
 *
 * Revision 1.79  2002/09/03 07:53:38  nozomi
 * modify getting tree
 *
 * Revision 1.78  2002/09/03 01:41:32  nozomi
 * fix multiplicatin of nodes
 *
 * Revision 1.77  2002/09/02 15:54:51  nozomi
 * remove unnecessary character before comment
 *
 * Revision 1.76  2002/09/02 15:45:13  nozomi
 * remove debug code
 *
 * Revision 1.75  2002/09/02 13:28:35  t.okada
 * add copyright dialog menu
 *
 * Revision 1.74  2002/09/01 23:48:10  nozomi
 * use NamedObjectBroker more intensely
 *
 * Revision 1.73  2002/08/28 00:28:56  nozomi
 * *Maintenance* items removed
 *
 * Revision 1.72  2002/08/27 08:50:29  t.okada
 * Modifiable change method is added.
 *
 * Revision 1.71  2002/08/22 08:44:58  ryo
 * set EditAdaptor to SearchView
 *
 * Revision 1.70  2002/08/22 07:32:23  ryo
 * fix NamedObject's linkage bug
 *
 * Revision 1.69  2002/08/13 02:35:30  ryo
 * change call function to PreferenceManager.loadPreference()
 *
 * Revision 1.68  2002/08/12 09:02:04  ryo
 * add the window counter
 *
 * Revision 1.67  2002/08/06 13:48:25  ryo
 * remove unnecessary line
 *
 * Revision 1.66  2002/08/05 05:18:44  nozomi
 * use NativePanel again
 *
 * Revision 1.65  2002/08/03 05:55:27  nozomi
 * extends Frame, as previous; modify look and feel slightly
 *
 * Revision 1.64  2002/08/01 09:34:45  ryo
 * call *EditPanel.setModel() in taxoNote()
 *
 * Revision 1.63  2002/08/01 07:20:19  ryo
 * add linkage process between NamedObjects before DB updated
 *
 * Revision 1.62  2002/07/19 06:07:44  nozomi
 * extends ApplicationApplet, instead of Frame
 *
 * Revision 1.61  2002/07/17 07:34:51  t.okada
 * display fault of Authorty is corrected.
 *
 * Revision 1.60  2002/07/03 13:21:30  t.okada
 * bugfix NamedObject link
 *
 * Revision 1.59  2002/06/23 13:38:42  nozomi
 * aware of FocusController
 *
 * Revision 1.58  2002/06/21 11:36:17  ryo
 * change timing of _init() called
 *
 * Revision 1.57  2002/06/21 08:29:36  nozomi
 * add ToolBar
 *
 * Revision 1.56  2002/06/17 09:49:46  ryo
 * do nothing if nameUsageEditModel is null in openTreeAndAllPanels()
 *
 * Revision 1.55  2002/06/10 12:36:15  ryo
 * move processing of creating NamedObjectEditModel tree to NamedObjectBroker#getNamedObjectEditModelTree() from openTreeAndAllPanels()
 *
 * Revision 1.54  2002/06/09 12:43:28  nozomi
 * change TreeModelEvent handling
 *
 * Revision 1.53  2002/06/06 11:28:39  ryo
 * add menu item for deleting a taxon into the popup menu of hierarchy after searching
 *
 * Revision 1.52  2002/06/06 05:43:42  t.okada
 * addition of a clearModels() method
 *
 * Revision 1.51  2002/06/04 13:47:42  ryo
 * change RegisterController to NamedObjectBroker and comment out unused functions
 *
 * Revision 1.50  2002/06/03 12:17:40  t.okada
 * changes into NamedObjectBroker from SearchController.
 *
 * Revision 1.49  2002/05/29 06:17:22  t.okada
 * remove ModelPoolController class
 *
 * Revision 1.48  2002/05/25 16:55:19  nozomi
 * fix model selection bug
 *
 * Revision 1.47  2002/05/24 15:39:03  t.okada
 * Correction for a NameTree display
 *
 * Revision 1.46  2002/05/23 02:52:15  nozomi
 * make EditPanels editable as default
 *
 * Revision 1.45  2002/05/22 09:15:24  t.okada
 * addition of a createTreeNode() method
 *
 * Revision 1.44  2002/05/21 07:13:04  ryo
 * display the hierarchy tree
 *
 * Revision 1.43  2002/05/17 19:11:04  ryo
 * add link processing for authority and annotation
 *
 * Revision 1.42  2002/05/17 16:01:48  t.okada
 * Since Annotation was not able to be read, processing of openTreeAndAllPanels() was corrected.
 *
 * Revision 1.41  2002/05/17 12:03:45  t.okada
 * modify getSaveNamedObjects()
 *
 * Revision 1.40  2002/05/15 12:55:20  t.okada
 * bugfix openTreeAndAllPanels()
 *
 * Revision 1.39  2002/05/15 08:48:30  t.okada
 * bugfix openTreeAndAllPanels()
 *
 * Revision 1.38  2002/05/15 08:10:08  t.okada
 * modify openTreeAndAllPanels()
 *
 * Revision 1.37  2002/05/14 13:33:17  ryo
 * modify getSaveNamedObjects()
 *
 * Revision 1.36  2002/05/14 10:09:59  ryo
 * add processing when a tab is changed
 *
 * Revision 1.35  2002/05/10 15:49:01  t.okada
 * modify getSaveNamedObjects()
 *
 * Revision 1.34  2002/05/10 13:38:34  ryo
 * set a reference to TabbedPane to *EditPanel
 *
 * Revision 1.33  2002/05/10 12:08:35  t.okada
 * modify getSaveNamedObjects()
 *
 * Revision 1.32  2002/05/09 13:08:35  t.okada
 * comment out NameTree hierarchy
 *
 * Revision 1.31  2002/05/08 11:06:56  ryo
 * bug fix in itemStateChanged()
 *
 * Revision 1.30  2002/04/30 04:53:28  nozomi
 * change order of tabs
 *
 * Revision 1.29  2002/04/16 23:43:51  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.28  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.27  2002/04/08 02:04:13  nozomi
 * minor edtition in source code style
 *
 * Revision 1.26  2002/04/01 08:15:29  nozomi
 * use java.util.Vector
 *
 * Revision 1.25  2002/03/26 04:03:04  nozomi
 * implements Runnable
 *
 * Revision 1.24  2002/03/11 11:02:13  okawa
 * init NameRecordEditModel when a Name is selected
 *
 * Revision 1.23  2002/03/10 12:03:57  nozomi
 * NameRecordEditModel selection by NameTree
 *
 * Revision 1.22  2002/03/10 11:12:19  nozomi
 * change in title of panels
 *
 * Revision 1.21  2002/03/10 09:08:25  okawa
 * use openTreeAndAllPanels() instead dispTree()
 *
 * Revision 1.20  2002/03/10 00:57:32  okawa
 * use openTreeAndAllPanels()
 *
 * Revision 1.19  2002/03/07 16:44:47  okawa
 * use ObjectEditModelListener
 *
 * Revision 1.17  2002/03/07 10:26:44  nozomi
 * use NameTree
 *
 * Revision 1.16  2002/03/06 13:38:10  okawa
 * add openAllPanels()
 *
 * Revision 1.15  2002/03/06 02:39:01  okawa
 * add select tree process
 *
 * Revision 1.14  2002/03/06 00:46:13  okawa
 * add saveDatabase()
 *
 * Revision 1.13  2002/03/06 00:10:40  nozomi
 * change EditPanel construction
 *
 * Revision 1.12  2002/03/01 00:33:32  okawa
 * add tabbedpane.addActionListener()
 *
 * Revision 1.11  2002/02/28 23:56:04  okawa
 * delete UIController function
 *
 * Revision 1.10  2002/02/27 23:56:02  nozomi
 * comment modification
 *
 * Revision 1.9  2002/02/27 09:53:45  okawa
 * modify search Tree function
 *
 * Revision 1.8  2002/02/26 02:54:29  okawa
 * add _initEnv()
 *
 * Revision 1.7  2002/02/24 18:13:36  nozomi
 * re-implementation of setModel() to be used switching between models
 *
 * Revision 1.6  2002/02/21 21:03:49  nozomi
 * Add comments with minor modification of label contents
 *
 */

package org.nomencurator.editor;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import java.util.Enumeration;
import java.util.Observer;
import java.util.Observable;
import java.util.Vector;
import java.util.Hashtable;


import jp.kyasu.awt.BorderedPanel;
import jp.kyasu.awt.Frame;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.NativePanel;
import jp.kyasu.awt.Panel;
import jp.kyasu.awt.SplitPanel;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.ToolBar;
import jp.kyasu.graphics.RichText;
import jp.kyasu.awt.TextField;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextStyle;
import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.NameUsage;
import org.nomencurator.Annotation;
import org.nomencurator.Appearance;
import org.nomencurator.Publication;
import org.nomencurator.Author;
import org.nomencurator.Preference;

import org.nomencurator.awt.event.ChangeListener;
import org.nomencurator.awt.event.ChangeEvent;

import org.nomencurator.awt.tree.DefaultMutableTreeNode;
import org.nomencurator.awt.tree.JTree;
import org.nomencurator.awt.tree.TreeController;
import org.nomencurator.awt.tree.TextTreeModel;
import org.nomencurator.awt.tree.TreeNode;
import org.nomencurator.awt.tree.TreeSelectionModel;
import org.nomencurator.awt.tree.TreeView;
import org.nomencurator.awt.tree.event.ExpandVetoException;
import org.nomencurator.awt.tree.event.TreeExpansionEvent;
import org.nomencurator.awt.tree.event.TreeExpansionListener;
import org.nomencurator.awt.tree.event.TreeSelectionEvent;
import org.nomencurator.awt.tree.event.TreeSelectionListener;
import org.nomencurator.awt.tree.event.TreeWillExpandListener;

import org.nomencurator.broker.NamedObjectBroker;
//import org.nomencurator.controller.SearchController;

import org.nomencurator.controller.PreferenceManager;
//import org.nomencurator.controller.ServletSearchObject;
//import org.nomencurator.controller.ServletRegisterObject;
//import org.nomencurator.controller.RegisterController;

import org.nomencurator.editor.GreekButton;
import org.nomencurator.editor.Latin1Button;

import org.nomencurator.editor.NameUsageEditPanel;
import org.nomencurator.editor.AppearanceEditPanel;
import org.nomencurator.editor.PublicationEditPanel;
import org.nomencurator.editor.AuthorEditPanel;
import org.nomencurator.editor.CopyrightDialog;

import org.nomencurator.editor.command.CommandController;

import org.nomencurator.editor.model.AppearanceEditModel;
import org.nomencurator.editor.model.AnnotationEditModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.PublicationEditModel;
import org.nomencurator.editor.model.AuthorEditModel;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.editor.model.NameTreeModel;

import org.nomencurator.editor.event.ObjectEditModelEvent;
import org.nomencurator.editor.event.ObjectEditModelListener;

import org.nomencurator.util.tree.TreePath;
import org.nomencurator.util.tree.TreeModel;
import org.nomencurator.awt.tree.DefaultTreeModel;

/**
 * <code>Frame</code> orgnizing GUI <code>Components</code> representing
 * Nomencurator data strutucture.
 *
 * @version 11 Oct 2002
 * @author Maki Kanbara, Hcc-Network 
 * @author 	Nozomi `James' Ytow
 * @author Ryo FUJIMOTO
 * @author T. Okada
 */
public class TaxoNote
    extends Frame
    implements ItemListener, ActionListener, Runnable
{
    
    /** <code>SplitPanel</code> providing base <code>Container</code> */ 
    protected SplitPanel mainSplitPane;

    /** <code>SplitPanel</code> represents query panel and
     * its results in both <code>List</code> and <code>Tree</code> */
    protected SplitPanel treeSplitPane;

    /** <code>SearchView</code> providing a query interface */
    protected SearchView searchView;

    /** <code>BorderedPanel</code> representing a query and its result */
    protected BorderedPanel searchBorderedPanel;

    /** <code>BorderedPanel</code> containing <code>Tree</code>
     * representing a taxonomic hierarchy */
    protected BorderedPanel treeBorderedPanel;

    /**
     * <code>NameUsageTreeView</code> containing <code>Tree</code>
     * representing a taxonomic hierarchy
     */
    protected NameUsageTreeView nameUsageTreeView;

    protected NameTree hierarchy;

    /**
     * <code>PublicationEditModel</code>
     */
    protected PublicationEditModel publicationEditModel;

    /**
     * <code>BorderedPanel</code> representing
     * detail of a selected record
     */
    protected BorderedPanel infoBorderedPanel;

    /**
     * <code>TabbedPane</code> used to swith
     * <code>Panel</code>s representing detaild information
     * of the selected record
     */
    protected TabbedPane tabbedPane;

    /**
     * <code>NameUsageEditPanel</code> shown by <code>tabbedPane</code>
     */
    protected NameUsageEditPanel nameUsageEditPanel;

    /**
     * <code>AppearanceEditPanel</code> shown by <code>tabbedPane</code>
     */
    protected AppearanceEditPanel appearanceEditPanel;

    /** <code>PublicationEditPanel</code> shown by <code>tabbedPane</code> */
    protected PublicationEditPanel publicationEditPanel;

	protected NamedObjectEditPanel previousSelectedEditPanel;

    /** <code>AuthorEditPanel</code> shown by <code>tabbedPane</code> */
    protected AuthorEditPanel authorEditPanel;

    protected ShoppingListDialog shoppingList;
    
    static public final String L_TITLE       = "TaxoNote";
    static public final String L_AUTHOR      = "Author";
    static public final String L_PUBLICATION = "Publication";
    static public final String L_APPEARANCE  = "Name Appearance";
    static public final String L_TREE        = "Classification";
    static public final String L_INFO        = "Details";
    static public final String L_SEARCH      = "Search";
    static public final String L_NAME        = "Name";
    static public final String L_CHANGE      = "Change";
    

    static public final int V_SPLITGAP = 2;
    
    private static final int NORMAL = 0;
    private static final int ERROR = -1;

    protected ToolBar toolBar;

    protected NativePanel mainPane;
    
    protected EditAdaptor editor;

	/**
	 * the counter of the window of TaxoNote
	 */
	protected static int windowCounter = 0;

    /**
     * Main Method
     * 
     * @param String args[]
     */
    public static void main(String args[])
    {
	TaxoNote note = new TaxoNote();
	note.setVisible(true);
	Thread t = new Thread(note);
	t.start();
    }

    /**
     * Constructor
     */
    public TaxoNote()
    {
        super(L_TITLE);
    	_initEnv();
        _init();
        windowCounter++;
    }

    public TaxoNote(TaxoNote note)
    {
	super(note.getTitle());
	taxoNote(note.nameUsageEditPanel.getNameUsageEditModel());
	windowCounter++;
    }

    /**
     * Initialize this frame
     */
    protected void _init()
    {
    // create NamedObjects and NamedObjectEditModels
	Publication p = new Publication();
	PublicationEditModel pm = new PublicationEditModel(p);
	Author au = new Author();
	AuthorEditModel aum = new AuthorEditModel(au);
	Appearance ap = new Appearance();
	AppearanceEditModel apm = 
	    new AppearanceEditModel(ap);
	NameUsage n = new NameUsage();
	NameUsageEditModel nm =
	    new NameUsageEditModel(n);
	nm.setRank(NameUsageEditPanel.getDefaultRank());

	// create linkage between NamedObjectEditModels
	pm.addAuthor(aum);
	aum.add(pm);
	pm.addAppearance(apm);
	apm.setPublicationEditModel(pm);
	nm.setAppearanceEditModel(apm);
	apm.addNameUsageEditModel(nm);
	taxoNote(nm);
    }


    protected void taxoNote(NameUsageEditModel model)
    {
    NameUsageEditModel nuem = model;
    AppearanceEditModel apem = model.getAppearanceEditModel();
    PublicationEditModel puem = apem.getPublicationEditModel();
    AuthorEditModel auem = (AuthorEditModel)puem.getAuthorEditModels().elementAt(0);
    
	editor = new EditAdaptor();
	nameUsageEditPanel = new NameUsageEditPanel(nuem);
	nameUsageEditPanel.setEditor(editor);
	nameUsageEditPanel.setTaxoNote(this);
	appearanceEditPanel = new AppearanceEditPanel(apem);
	appearanceEditPanel.setEditor(editor);
	appearanceEditPanel.setTaxoNote(this);
	publicationEditPanel = new PublicationEditPanel(puem);
	publicationEditPanel.setEditor(editor);
	authorEditPanel = new AuthorEditPanel(auem);
	authorEditPanel.setEditor(editor);
	authorEditPanel.setTaxoNote(this);
	nameUsageEditPanel.setAppearanceEditPanel(appearanceEditPanel);
	appearanceEditPanel.setNameUsageEditPanel(nameUsageEditPanel);
	appearanceEditPanel.setPublicationEditPanel(publicationEditPanel);
	publicationEditPanel.setAppearanceEditPanel(appearanceEditPanel);
	publicationEditPanel.setAuthorEditPanel(authorEditPanel);
	authorEditPanel.setPublicationEditPanel(publicationEditPanel);

	authorEditPanel.addItemListener(this);
	publicationEditPanel.setAuthorEditPanel(authorEditPanel);
	
	publicationEditPanel.setTaxoNote(this);
	
	//Create EditModel relation
	appearanceEditPanel.getAppearanceEditModel().addNameUsageEditModel(nameUsageEditPanel.getNameUsageEditModel());
	publicationEditPanel.getPublicationEditModel().addAppearance(appearanceEditPanel.getAppearanceEditModel());
	publicationEditPanel.getPublicationEditModel().addAuthor(authorEditPanel.getAuthorEditModel());
	authorEditPanel.getAuthorEditModel().add(publicationEditPanel.getPublicationEditModel());

	publicationEditModel = publicationEditPanel.getPublicationEditModel();
	

	// create TabbedPane
	tabbedPane = new TabbedPane(TabbedPane.TOP);
	tabbedPane.addTab(L_PUBLICATION, publicationEditPanel);
	tabbedPane.addTab(L_AUTHOR, authorEditPanel);
	tabbedPane.addTab(L_APPEARANCE, appearanceEditPanel);
	tabbedPane.addTab(L_NAME, nameUsageEditPanel);
	tabbedPane.addActionListener(this);
	nameUsageEditPanel.setTabbedPane(tabbedPane);
	appearanceEditPanel.setTabbedPane(tabbedPane);
	publicationEditPanel.setTabbedPane(tabbedPane);
	authorEditPanel.setTabbedPane(tabbedPane);
	previousSelectedEditPanel = publicationEditPanel;

	NameUsageEditModel nameUsageEditModel = nameUsageEditPanel.getNameUsageEditModel();

	hierarchy = new NameTree(new NameUsageNode(nameUsageEditModel));

	nameUsageEditPanel.setNameTree(hierarchy);

	searchView = new SearchView();
	searchView.addTableItemListener(this);
	searchView.setEditor(editor);

	enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	
	setMenuBar(new CommandController().createMenuBar(this));

	mainPane = new NativePanel(new BorderLayout());
	//    	Panel mainPane = new Panel(new BorderLayout());
    	//Panel mainPane = new Panel(new BorderLayout());
	mainPane.add(editor.getToolBar(), BorderLayout.NORTH);
    	add(mainPane, BorderLayout.CENTER);
	BorderedPanel p = new BorderedPanel(new BorderLayout());
	//    	add(p, BorderLayout.CENTER);
	//mainPane.add(p, BorderLayout.CENTER);

	mainSplitPane = new SplitPanel(SplitPanel.HORIZONTAL, V_SPLITGAP);

	p.add(mainSplitPane, BorderLayout.CENTER);
	//	mainPane.add(mainSplitPane, BorderLayout.CENTER);
	mainPane.add(p, BorderLayout.CENTER);
	
	treeBorderedPanel = new BorderedPanel(new VTitledPaneBorder(L_TREE));
	treeBorderedPanel.add(hierarchy);
	infoBorderedPanel = new BorderedPanel(new VTitledPaneBorder(L_INFO));
	searchBorderedPanel = new BorderedPanel(new VTitledPaneBorder(L_SEARCH));
	searchBorderedPanel.add(searchView);
	treeSplitPane = new SplitPanel(SplitPanel.VERTICAL, V_SPLITGAP);
	treeSplitPane.add(searchBorderedPanel);
	treeSplitPane.add(treeBorderedPanel);
	
	mainSplitPane.add(treeSplitPane);
	mainSplitPane.add(infoBorderedPanel);
	
	
	infoBorderedPanel.add(tabbedPane);
	
	pack();
	show();

	resetAllModelsModifiable();
	
    }
    
    /**
     * Clear Taxonote EditModels
     */
    public PublicationEditModel clearModels() {

	publicationEditModel = new PublicationEditModel();
	NameUsageEditModel nuModel = new NameUsageEditModel(new AppearanceEditModel(publicationEditModel));
	AuthorEditModel authorModel = new AuthorEditModel();
	
	//	publicationEditModel = nuModel.getAppearanceEditModel().getPublicationEditModel();
	appearanceEditPanel.setModel(nuModel.getAppearanceEditModel());
	authorEditPanel.setModel(authorModel);
	nameUsageEditPanel.setModel(nuModel);
	
	publicationEditModel.getAuthorList().addModel(authorModel);
	authorModel.getPublicationList().addModel(publicationEditModel);
	
	NameUsageNode topNode = new NameUsageNode(nuModel);
	createTreeNode(topNode, nuModel);
	
	NameTreeModel nameTreeModel = new NameTreeModel(topNode);
	hierarchy.setModel(nameTreeModel);
	
	return publicationEditModel;
    }
    
    
    /**
     * Initialize Taxonote environment, preference
     */
    private void _initEnv() {
	// load user preference
	PreferenceManager.loadPreference();

//        // load servlet url
//        String s = System.getProperty("nomencurator.servleturl");
//        if(s != null) {
//            ServletSearchObject.setServletUrl(s);
//            ServletRegisterObject.setServletUrl(s);
//        }
//        
//        // set data access priority from Preference
//        if(PreferenceManager.getInstance().getSearchPriority() == Preference.V_SERVER) {
//            SearchController.setMethod(SearchController.SEARCH_FROM_SERVLET);
//            RegisterController.setMethod(RegisterController.REGISTER_TO_SERVLET);
//        } else {
//            SearchController.setMethod(SearchController.SEARCH_FROM_CLIENTFILE);
//            RegisterController.setMethod(RegisterController.REGISTER_TO_CLIENTFILE);
//        }
    }

    static long previousUsed = 0;
    
    /**
     * @param ItemEvent e
     */
    public void itemStateChanged(ItemEvent e) {
        TableList table = searchView.getTable();
	Object eventSource = e.getSource();

        if(eventSource == table) {
            // when a row of NameUsages Table is selected
	    if(table.getSelectedIndexes().length > 1)
		return;
            int higher = PreferenceManager.getInstance().getHigherCount();
            int lower = PreferenceManager.getInstance().getLowerCount();

            String oid = ((NameUsageSearchListModel)table.getModel()).getOid(table.getSelectedIndex());
	    
	    if(isAllModelsModifiable()) {
		if(saveDatabase()) {
		    openTreeAndAllPanels(new NameUsage(oid), higher, lower);
		} else {
		    openTreeAndAllPanels(new NameUsage(oid), higher, lower);
		}
            } else {
	           openTreeAndAllPanels(new NameUsage(oid), higher, lower);
            }
	    //	    openTreeAndAllPanels(new NameUsage(oid), higher, lower);
        }
    }
    
    /**
     * chkeck all models editable
     */
    public boolean isAllModelsModifiable()
    {
    	PublicationEditModel publicationEditModel = 
	    (PublicationEditModel)publicationEditPanel.getModel();
    	if(publicationEditModel.isModified())
    		return true;
    		
    	Vector appearanceModels = publicationEditModel.getAppearanceEditModels();
    	for(int i = 0; i < appearanceModels.size(); i++) {
	    AppearanceEditModel appearanceEditModel = (AppearanceEditModel)appearanceModels.elementAt(i);
	    if(appearanceEditModel.isModified())
		return true;
	    
	    Vector nameUsageEditModels = appearanceEditModel.getNameUsageEditModels();
	    for(int j = 0; j < nameUsageEditModels.size(); j++) {
		NameUsageEditModel nameUsageEditModel = (NameUsageEditModel)nameUsageEditModels.elementAt(j);
		if(nameUsageEditModel.isModified())
		    return true;
	    }
    	}
    	
    	Vector authorEditModels = publicationEditModel.getAuthorEditModels();
    	for(int i = 0; i < authorEditModels.size(); i++) {
	    AuthorEditModel authorEditModel = (AuthorEditModel)authorEditModels.elementAt(i);
	    if(authorEditModel.isModified())
		return true;
    	}
    	
    	return false;
    }
    /**
     * 
     */
    public void resetAllModelsModifiable() {
    	PublicationEditModel publicationEditModel = (PublicationEditModel)publicationEditPanel.getModel();
    	publicationEditModel.setModified(false);
    		
    	Vector appearanceModels = publicationEditModel.getAppearanceEditModels();
    	for(int i = 0; i < appearanceModels.size(); i++) {
    		AppearanceEditModel appearanceEditModel = (AppearanceEditModel)appearanceModels.elementAt(i);
    		appearanceEditModel.setModified(false);
    		
    		Vector nameUsageEditModels = appearanceEditModel.getNameUsageEditModels();
    		for(int j = 0; j < nameUsageEditModels.size(); j++) {
    			NameUsageEditModel nameUsageEditModel = (NameUsageEditModel)nameUsageEditModels.elementAt(j);
    			nameUsageEditModel.setModified(false);
    		}
    	}
    	
    	Vector authorEditModels = publicationEditModel.getAuthorEditModels();
    	for(int i = 0; i < authorEditModels.size(); i++) {
    		AuthorEditModel authorEditModel = (AuthorEditModel)authorEditModels.elementAt(i);
    		authorEditModel.setModified(false);
    	}
    }
    
    
    /**
     * open Preference Dialog
     */
    protected void openPreferenceView() {
	PreferenceView view = new PreferenceView();
	view.show((Frame)this);
    }
    
    /**
     * open Copypright
     */
    protected void openCopyrightDialog() {
	CopyrightDialog dialog = new CopyrightDialog(this);
	dialog.show();
    }
    
    /**
     * open New Window
     */
    public void openNewWindow() {
        TaxoNote note = new TaxoNote();
	Thread t = new Thread(note);
        //note.run();
	t.start();
    }

    protected void openTreeAndAllPanels(NameUsage nameUsage, int higher, int lower)
    {
	Runtime r = Runtime.getRuntime();
	System.gc();
	long used = r.totalMemory() - r.freeMemory();

	// get tree of NamedObjectEditModels
	NamedObjectBroker broker = NamedObjectBroker.getInstance();

	String name = nameUsage.getRoot().getName();

	NameTreeModel nameTreeModel = 
	    broker.getTree(name);
	if(nameTreeModel != null) {
	    name = nameUsage.getName();
	    NameUsageEditModel n = (NameUsageEditModel)broker.getModel(name);
	    
	    nameUsageEditPanel.setModel(n);
	    appearanceEditPanel.setModel(n.getAppearanceEditModel());
	    publicationEditPanel.setModel(appearanceEditPanel.getAppearanceEditModel().getPublicationEditModel());
	    authorEditPanel.setModel((AuthorEditModel)publicationEditPanel.getPublicationEditModel().getAuthorEditModels().elementAt(0));
	    hierarchy.setModel(nameTreeModel);
	System.gc();
	long used2 = r.totalMemory() - r.freeMemory();
	if(previousUsed > 0)
	    System.err.println("UsedHeap(kB) " + used/1024 + " " 
			       + used2/1024 + " " 
			       + (used2 - used)/1024 + " "
			       + (used - previousUsed)/1024);
	/*
	else
	    System.err.println("UsedHeap(kB) " + used/1024 + " " + used2/1024 + " " + (used2 - used)/1024);
	*/
	previousUsed = used2;
	    return;
	}

	
	NameUsageEditModel nameUsageEditModel =
	    broker.getNamedObjectEditModelTree(nameUsage, higher, lower);

	if (nameUsageEditModel == null)
	    return;

		// set PublicationEditModel
	publicationEditModel =
	    (PublicationEditModel)nameUsageEditModel.getAppearanceEditModel().getPublicationEditModel();

	// set NameUsage Authority	
	Vector appearanceModels = this.publicationEditModel.getAppearanceEditModels();
	for(int i = 0; i < appearanceModels.size(); i++) {
	    Vector nuModels = ((AppearanceEditModel)appearanceModels.elementAt(i)).getNameUsageEditModels();
	    for(int j = 0; j < nuModels.size(); j++) {
		NameUsageEditModel nuModel = (NameUsageEditModel)nuModels.elementAt(j);
		NameUsageEditModel authorityModel = nuModel.getAuthorityEditModel();
		if(authorityModel != null) {
		    NameUsage nu = new NameUsage();
		    nu.setPersistentID(authorityModel.getPersistentID());
		    NameUsageEditModel authorityNameUsageEditModel =
			broker.getNamedObjectEditModelTree(nu, 1, 1);
		    
		    nuModel.setAuthorityEditModel(authorityNameUsageEditModel);
		    PublicationEditModel authorityPublicationEditModel =
			(PublicationEditModel)authorityNameUsageEditModel.getAppearanceEditModel().getPublicationEditModel();
		    /*
		    Text text = authorityPublicationEditModel.getAuthorsSummaryTextModel().getRichText().getText();
		    text.append(" ");
		    text.append(authorityPublicationEditModel.getYearTextModel().getRichText().getText());
		    RichText richText = new RichText(text, TextField.DEFAULT_FIELD_STYLE);
		    nuModel.setAuthorityRichText(richText);
		    */
		    nuModel.setAuthorityRichText(new RichText(authorityNameUsageEditModel.getViewName(), TextField.DEFAULT_FIELD_STYLE));
		}				
	    }
	}

	// set EditModel to EditPanel

	nameUsageEditPanel.setModel(nameUsageEditModel);
	appearanceEditPanel.setModel(nameUsageEditModel.getAppearanceEditModel());

	Vector authorModels = publicationEditModel.getAuthorEditModels();
	AuthorEditModel authorEditModel = null;
	if(authorModels.isEmpty()) {
	    authorEditModel = new AuthorEditModel();
	    publicationEditModel.addAuthor(authorEditModel);
	}
	else
	    authorEditModel = (AuthorEditModel)authorModels.elementAt(0);

	authorEditPanel.setModel(authorEditModel);
	publicationEditPanel.setModel(publicationEditModel);


	// set NameUsageEditPanels to hierarchy tree.
	NameUsageNode topNode = 
	    (NameUsageNode)broker.getNode(nameUsageEditModel.getName());
	if(topNode == null) {
	    topNode = new NameUsageNode(nameUsageEditModel);
	    createTreeNode(topNode, nameUsageEditModel);
	    broker.putNode(topNode);
	}

	//	createTreeNode(topNode, nameUsageEditModel);
	nameTreeModel = 
	    broker.getTree(((NameUsageNode)(topNode.getRoot())).getName());
	//broker.getTree(topNode.getName());
	if(nameTreeModel == null) {
	    //createTreeNode(topNode, nameUsageEditModel);
	    nameTreeModel = new NameTreeModel(topNode);
	    broker.putTree(nameTreeModel);
	}
	System.err.println(nameTreeModel.getItemCount());

	hierarchy.invalidate();
	hierarchy.setModel(nameTreeModel);
	hierarchy.validate();
	/*	
	resetAllModelsModifiable();
	*/
	System.gc();
	long used2 = r.totalMemory() - r.freeMemory();
	if(previousUsed > 0)
	    System.err.println("UsedHeap(kB) " + used/1024 + " " 
			       + used2/1024 + " " 
			       + (used2 - used)/1024 + " "
			       + (used - previousUsed)/1024);
	/*
	else
	    System.err.println("UsedHeap(kB) " + used/1024 + " " + used2/1024 + " " + (used2 - used)/1024);
	*/
	previousUsed = used2;


    }
    
    /**
     * create TreeNode data
     */
    protected void createTreeNode(NameUsageNode nameUsageNode, NameUsageEditModel nameUsageEditModel)
    {
	if(nameUsageEditModel.getLowerEditModels() != null) {
	    int n = nameUsageEditModel.getLowerEditModels().size();
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    for(int i = 0; i < n; i++) {
		NameUsageEditModel nuEditModel = (NameUsageEditModel)nameUsageEditModel.getLowerEditModels().elementAt(i);
		NameUsageNode nuNode = 
		    (NameUsageNode)broker.getNode(nuEditModel.getName());
		if(nuNode == null) {
		    nuNode = new NameUsageNode(nuEditModel);
		    broker.putNode(nuNode);
		}
		nameUsageNode.add(nuNode);
		createTreeNode(nuNode, nuEditModel);
	    }
	}
    }
    /*
    protected void createTreeNode(NameUsageNode nameUsageNode, NameUsageEditModel nameUsageEditModel) {
	nameUsageEditModel = nameUsageNode.getNameUsageEditModel();
	if(nameUsageEditModel.getLowerEditModels() != null) {
	    int n = nameUsageEditModel.getLowerEditModels().size();
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    for(int i = 0; i < n; i++) {
		NameUsageEditModel nuEditModel = (NameUsageEditModel)nameUsageEditModel.getLowerEditModels().elementAt(i);
		NameUsageNode nuNode = 
		    (NameUsageNode)broker.getNode(nuEditModel.getName());
		if(nuNode == null) {
		    nuNode = new NameUsageNode(nuEditModel);
		    broker.putNode(nuNode);
		}
		nameUsageNode.add(nuNode);
		createTreeNode(nuNode, nuEditModel);
	    }
	}
    }
    */
    
    /**
     * update Name Panel
     */
    protected void openNamePanel()
    {
        
        tabbedPane.setSelectedIndex(tabbedPane.V_TABINDEX_NAME);
    }
    
    /**
     * update Appearance Panel
     */
    protected void openAppearancePanel()
    {
        tabbedPane.setSelectedIndex(tabbedPane.V_TABINDEX_APPEARANCE);
    }
    
    /**
     * update Publication Panel
     */
    protected void openPublicationPanel()
    {
       tabbedPane.setSelectedIndex(tabbedPane.V_TABINDEX_PUBLICATION);
    }
    
    /**
     * update Author Panel
     */
    protected void openAuthorPanel()
    {
        tabbedPane.setSelectedIndex(tabbedPane.V_TABINDEX_AUTHOR);
    }
    
//    /**
//     * search NameUsage for Name Panel
//     */
//    protected void searchNamePanel(NameUsage nameUsage) {
//        NamedObjectBroker broker = NamedObjectBroker.getInstance();
//        NameUsage o = (NameUsage)broker.getNamedObjectForEditPanel(nameUsage);
//    }
//    
//    /**
//     * search Appearance for Appearance Panel
//     */
//    protected void searchAppearancePanel(Appearance appearance) {
//        NamedObjectBroker broker = NamedObjectBroker.getInstance();
//        Appearance o = (Appearance)broker.getNamedObjectForEditPanel(appearance);
//    }
//    
//    /**
//     * search Publication for Publication Panel
//     */
//    protected void searchPublicationPanel(Publication publication) {
//        NamedObjectBroker broker = NamedObjectBroker.getInstance();
//        Publication o = (Publication)broker.getNamedObjectForEditPanel(publication);
//    }
//
//    /**
//     * search Author for Author Panel
//     */
//    protected void searchAuthorPanel(Author author) {
//        NamedObjectBroker broker = NamedObjectBroker.getInstance();
//        Author o = (Author)broker.getNamedObjectForEditPanel(author);
//    }

    /**
     * save the NamedObjects in NamedObjectEditPanel to the nomencurator database
     */
    public boolean saveDatabase() {
    	boolean result = false;

	Vector namedObjectList = getSaveNamedObjects();

        if(namedObjectList != null && namedObjectList.size() > 0) {
	    if(result = Dialog.confirm(this, "Are you sure to save all " + NamedObjectBroker.getInstance().getUnsavedObjects().size() + " unsaved records?")) {

                //NamedObjectBroker.getInstance().saveNamedObject(namedObjectList);
		//NamedObjectBroker.getInstance().clearUnsavedObject(true);
		NamedObjectBroker.getInstance().saveAllUnsavedObject();
            }
        } else {
	    /*
            Dialog.message(this, "There are no modified records.");
	    */
        }

        return result;
    }


    /**
     * get the modified NamedObjects in NamedObjectEditPanel
     */
    private Vector getSaveNamedObjects()
    {
	publicationEditPanel.putUnsavedObject();
	authorEditPanel.putUnsavedObject();
	appearanceEditPanel.putUnsavedObject();
	nameUsageEditPanel.putUnsavedObject();
	return NamedObjectBroker.getInstance().getUnsavedObjects();
	/*
	//	return NamedObjectBroker.getInstance().getUnsavedObjects();
        //Vector namedObjectList = new Vector();
	Vector namedObjectList = NamedObjectBroker.getInstance().getUnsavedObjects();
	if(namedObjectList == null)
	    namedObjectList = new Vector();
		
	//Get Publication NamedObject
	publicationEditModel.saveAttributes();
	Publication publication = (Publication)publicationEditModel.getObject();
	namedObjectList.add(publication);
	
	//Get Appearance NamedObject
	Vector appearanceModels = publicationEditModel.getAppearanceEditModels();
	int appCount = appearanceModels.size();
	for(int i = 0; i < appCount; i++) {
	    ((AppearanceEditModel)appearanceModels.elementAt(i)).saveAttributes();
	    Appearance appearance = (Appearance)((AppearanceEditModel)appearanceModels.elementAt(i)).getObject();
	    publication.addAppearance(appearance); // for localdb
	    appearance.setPublication(publication);
	    if(!namedObjectList.contains(appearance))
		namedObjectList.add(appearance);
	    
	    //Get NameUsage NamedObject
	    Vector nameUsageModels = ((AppearanceEditModel)appearanceModels.elementAt(i)).getNameUsageEditModels();
	    int nameCount = nameUsageModels.size();
	    for(int j = 0; j < nameCount; j++) {
		((NameUsageEditModel)nameUsageModels.elementAt(j)).saveAttributes();
	    }
	    for(int j = 0; j < nameCount; j++) {
		NameUsageEditModel nuem = (NameUsageEditModel)nameUsageModels.elementAt(j);
		NameUsage nameUsage = (NameUsage)nuem.getObject();
		appearance.addNameUsage(nameUsage); // for localdb
		nameUsage.setAppearance(appearance);
		
		Vector lowerEditModels = nuem.getLower().getModels();
		if (lowerEditModels != null && lowerEditModels.size() != 0) {
		    Enumeration e = lowerEditModels.elements();
		    while (e.hasMoreElements()) {
			
			NameUsageEditModel lowernuem = (NameUsageEditModel)e.nextElement();
			NameUsage nu = (NameUsage)lowernuem.getObject();
			
			nameUsage.addLowerTaxon(nu);
		    }
		}
		if(!namedObjectList.contains(nameUsage))
		    namedObjectList.add(nameUsage);
	    }
	    
	    //Get Annotation NamedObject
	    Vector annotationModels = ((AppearanceEditModel)appearanceModels.elementAt(i)).annotationEditModels();
	    int annoNum = annotationModels.size();
	    for(int j = 0; j < annoNum; j++) {
		((AnnotationEditModel)annotationModels.elementAt(j)).saveAttributes();
		Annotation annotation = (Annotation)((AnnotationEditModel)annotationModels.elementAt(j)).getObject();
		annotation.setAppearance(appearance);
		if(appearance.getAnnotations() != null)
		    appearance.getAnnotations().add(annotation);
		if(!namedObjectList.contains(annotation))
		    namedObjectList.add(annotation);
		
		nameUsageModels = ((AnnotationEditModel)annotationModels.elementAt(j)).getAnnotators();
		nameCount = nameUsageModels.size();
		for(int k = 0; k < nameCount; k++) {
		    ((NameUsageEditModel)nameUsageModels.elementAt(k)).saveAttributes();
		    NameUsage nameUsage = (NameUsage)((NameUsageEditModel)nameUsageModels.elementAt(k)).getObject();
		    annotation.getAnnotators().add(nameUsage);
		    if(nameUsage.getAnnotations() == null) {
			nameUsage.setAnnotations(new Vector());
		    }
		    nameUsage.getAnnotations().add(annotation);
		}
		nameUsageModels = ((AnnotationEditModel)annotationModels.elementAt(j)).getAnnotants();
		nameCount = nameUsageModels.size();
		for(int k = 0; k < nameCount; k++) {
		    ((NameUsageEditModel)nameUsageModels.elementAt(k)).saveAttributes();
		    NameUsage nameUsage = (NameUsage)((NameUsageEditModel)nameUsageModels.elementAt(k)).getObject();
		    annotation.getAnnotatants().add(nameUsage);
		}
	    }
	}
	
	//Get Author NamedObject
	Vector authorModels = publicationEditModel.getAuthorEditModels();
	int authCount = authorModels.size();
	for(int i = 0; i < authCount; i++) {
	    ((AuthorEditModel)authorModels.elementAt(i)).saveAttributes();
	    Author author = (Author)((AuthorEditModel)authorModels.elementAt(i)).getObject();
	    publication.addAuthor(author);
	    if(!namedObjectList.contains(author))
		namedObjectList.add(author);
	}
	
        return namedObjectList;
	*/
    }

    /**
     * system closing process
     * @param WindowEvent e
     */
    protected void processWindowEvent(WindowEvent e) {
	int id = e.getID();
	if(id == WindowEvent.WINDOW_CLOSING) {
            exit();
	}
    }
    
    /**
     * system exit process
     * @param WindowEvent e
     */
    private void exit() {
	this.dispose();
	windowCounter--;
	if (windowCounter <= 0)
	    System.exit(NORMAL);
    }
    
    /**
     * @param ActionEvent e
     */
    public void actionPerformed(ActionEvent e) {
	if (e.getSource() == tabbedPane) {
	    //System.out.println("previous = " + previousSelectedEditPanel.toString());
	    previousSelectedEditPanel.getModel().saveAttributes();
	    NamedObjectEditPanel editPanel = tabbedPane.getSelectedEditPanel();
	    editPanel.updateView();
	    previousSelectedEditPanel = editPanel;
	    //System.out.println("current = " + editPanel.toString());
	}
	String command = e.getActionCommand();
        if(command.equals(CommandController.A_PREFERENCE)) {
            openPreferenceView();
        } else if(command.equals(CommandController.A_SAVE_DB)) {
            saveDatabase();
        } else if(command.equals(CommandController.A_OPEN_PANEL_NAME)) {
	    tabbedPane.setSelectedIndex(tabbedPane.V_TABINDEX_NAME);
            //openNamePanel();
        } else if(command.equals(CommandController.A_OPEN_PANEL_APPEARANCE)) {
            openAppearancePanel();
        } else if(command.equals(CommandController.A_OPEN_PANEL_PUBLICATION)) {
            openPublicationPanel();
        } else if(command.equals(CommandController.A_OPEN_PANEL_AUTHOR)) {
            openAuthorPanel();
        } else if(command.equals(CommandController.A_WINDOW_NEW)) {
            openNewWindow();
        } else if(command.equals(CommandController.A_OPEN_COPYRIGHT)) {
        	openCopyrightDialog();
        } else if(command.equals(CommandController.A_EXIT)) {
            exit();
        }
    }

    public void run()
    {
	setVisible(true);
	show();
    }

    /*
    protected Component[][][] createBarComponents()
    {
	Component[] edit   = createEditComponents();
	Component[] find   = createFindComponents(false);
	Component[] charTable = createCharTableComponents();
	Component[] slant  = createFontComponents();
	Component[] script = createScriptComponents();
	//	Component[] attribute = createAttributeComponents();
	//return new Component[][][]{{edit, find, charTable, slant, script, attribute}};
	return new Component[][][]{{edit, find, charTable, slant, script}};
    }

    protected Component[] createCharTableComponents()
    {
	greek = (CharacterSetButton)setupButton(new GreekButton(), "greek", "greek");
	greek.addItemListener(this);

	latin1 = (CharacterSetButton)setupButton(new Latin1Button(), "latin1", "diacritics");
	latin1.addItemListener(this);

	return new Component[]{ greek, latin1 };
    }

    protected Component[] createFontComponents()
    {
	italicButton = createIconToggleButton(I_ITALIC);
	italicButton.addItemListener(this);

	italicButton.setEnabled(false);

	addCaretDisableComp(italicButton);

	return new Component[]{ italicButton };
    }
    */

    public ShoppingListDialog getShoppingListDialog()
    {
	if(shoppingList == null)
	    shoppingList = new ShoppingListDialog(this);

	return shoppingList;
    }
}

