/*
 * TextTreeModel.java:  a TreeNode holding NamedObjectEditModel
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: Tree.java,v 1.1 2002/03/07 01:50:25 nozomi Exp $
 * $Log: Tree.java,v $
 * Revision 1.1  2002/03/07 01:50:25  nozomi
 * Tree implementation for edit models
 *
 */


package org.nomencurator.editor;

import jp.kyasu.awt.ScrollPanel;

import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.V3DBorder;
import jp.kyasu.graphics.VBorder;

import org.nomencurator.editor.model.NamedObjectNode;
import org.nomencurator.editor.model.TextTreeModel;

/**
 * The model interface for an object that acts as a named object edit model
 *
 *
 * @version 	07 Mar 2002
 * @author 	Nozomi `James' Ytow
 */
public class Tree
    extends org.nomencurator.awt.Tree
{
    /**
     * Constructs a scrolling Tree with the specified model and number of rows.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     */
    public Tree(TextTreeModel textTreeModel, int rows)
    {
	this(textTreeModel, rows, false);
    }

    /**
     * Constructs a scrolling Tree with the specified model, number of rows,
     * and multipleMode.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     * @param multipleMode  if <code>true</code>, then multiple selections
     *                      are allowed; otherwise, only one item can be
     */
    public Tree(TextTreeModel textTreeModel, int rows, boolean multipleMode)
    {
	this(textTreeModel, rows, multipleMode, ScrollPanel.SCROLLBARS_BOTH);
    }

    /**
     * Constructs a scrolling Tree with the specified model, number of rows,
     * multipleMode, and scroll bar visibility.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     * @param multipleMode  if <code>true</code>, then multiple selections
     *                      are allowed; otherwise, only one item can be
     * @param scrollbars    a constant that determines what scrollbars are
     *                      created to view the list.
     */
    public Tree(TextTreeModel textTreeModel, int rows, boolean multipleMode,
		int scrollbars)
    {
	this(textTreeModel, rows, multipleMode, scrollbars,
	     new V3DBorder(false));
    }

    /**
     * Constructs a scrolling Tree with the specified model, number of rows,
     * multipleMode, scroll bar visibility, and border visual.
     * @param treeModel the text list model.
     * @param rows          the number of items to show.
     * @param multipleMode  if <code>true</code>, then multiple selections
     *                      are allowed; otherwise, only one item can be
     * @param scrollbars    a constant that determines what scrollbars are
     *                      created to view the list.
     * @param border        the border visual of the list.
     */
    public Tree(TextTreeModel textTreeModel, int rows, boolean multipleMode,
		int scrollbars, VBorder border)
    {
	super(textTreeModel, rows, multipleMode, scrollbars, border);
    }

    /**
     * Constructs a scrolling Tree with the specified model.
     * This constructor is used by the subclasses only.
     */
    protected Tree(TextTreeModel textTreeModel)
    {
	this(textTreeModel, 0);
    }

    /**
     * Returns refenrece to newly constructed Tree having specified <code>node</code> as
     * its root node.  Leaf nodes in the tree are defined as any node witout child node
     * by default.
     *
     * @param node TreeNode object to be the root of constructed Tree
     */
    public Tree(NamedObjectNode node)
    {
	this(node, false);
    }


    /**
     * Returns reference to newly constructed Tree having specified <code>node</code> as
     * its root node.  Leaf nodes in the tree are determined depeding on given
     * <code>asksAllowsChildren</code>.
     *
     * @param node TreeNode object to be the root of constructed Tree
     * @param askedAllowsChildren false if leaf node is any node without child node, 
     * true if leaf node is a node which prohibits having child node.
     */
    public Tree(NamedObjectNode node,
		boolean asksAllowsChildren)
    {
	this(new TextTreeModel(node, asksAllowsChildren));
    }

}
