/*
 * TreeTable.java:  a TableList holding Tree
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TreeTable.java,v 1.2 2002/09/02 20:35:56 nozomi Exp $
 * $Log: TreeTable.java,v $
 * Revision 1.2  2002/09/02 20:35:56  nozomi
 * use constructor with TableListView parameter
 *
 * Revision 1.1  2002/08/29 13:00:01  nozomi
 * initial import into CVS repository
 *
 */


package org.nomencurator.editor;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.TextListModel;
import jp.kyasu.awt.text.TableListView;

import org.nomencurator.awt.tree.TreeView;

import org.nomencurator.editor.model.NamedObjectNode;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.editor.model.NameTreeModel;
import org.nomencurator.editor.model.TextTreeModel;

/**
 * The model interface for an object that acts as a named object edit model
 *
 * @version 	02 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class TreeTable
    extends TableList
{
    /**
     * Returns refenrece to newly constructed Tree having specified <code>node</code> as
     * its root node.  Leaf nodes in the tree are defined as any node witout child node
     * by default.
     *
     * @param node TreeNode object to be the root of constructed Tree
     */
    public TreeTable(NameUsageNode node, int rows, String title)
    {
	this(node, false, rows, title);
    }

    /**
     * Returns reference to newly constructed Tree having specified <code>node</code> as
     * its root node.  Leaf nodes in the tree are determined depeding on given
     * <code>asksAllowsChildren</code>.
     *
     * @param node TreeNode object to be the root of constructed Tree
     * @param askedAllowsChildren false if leaf node is any node without child node, 
     * true if leaf node is a node which prohibits having child node.
     */
    public TreeTable(NameUsageNode node,
		boolean asksAllowsChildren, int rows, String title)
    {
	this(new NameTreeModel(node, asksAllowsChildren), rows, title);
    }

    public TreeTable(TextTreeModel textTreeModel, int rows, String title)
    {
	this(textTreeModel, rows, new Button[]{new Button(title)});
    }

    public TreeTable(TextTreeModel textTreeModel, int rows, Button[] titles)
    {
	// direct all of super constructor is smaller than overriding a method
	// of superclass in this case
	super(new TableListView(new TreeView(textTreeModel), titles), rows);
	//super(textTreeModel, rows, titles);
    }

    public NameTreeModel getNameTreeModel()
    {
	return (NameTreeModel)getModel();
    }

    /*
     * Returns <code>TableListView</code> constructed with <code>model</code>
     * and <code>buttons</code>.  The subclasses may override this method.
     *
     * @param model   the text list model.
     * @param buttons the buttons for column titles.
     *
     * @return TableListView constructed with <code>model</code> and <code>buttons</code>
     *
     */
    /*
    protected TableListView createTableListView(TextListModel model, Button buttons[])
    {
	return new TableListView(new TreeView(model), buttons);
    }
    */

}
