/*
 * CommandController.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: CommandController.java,v 1.9 2002/09/02 13:27:56 t.okada Exp $
 * $Log: CommandController.java,v $
 * Revision 1.9  2002/09/02 13:27:56  t.okada
 * add copyright dialog menu
 *
 * Revision 1.8  2002/08/28 00:28:56  nozomi
 * *Maintenance* items removed
 *
 * Revision 1.7  2002/03/28 06:32:27  okawa
 * add copyright
 *
 * Revision 1.6  2002/03/06 00:49:43  okawa
 * add DB Upload command
 *
 * Revision 1.5  2002/02/28 23:58:16  okawa
 * delete ActionListener implementation
 *
 * Revision 1.4  2002/02/27 09:54:58  okawa
 * modify command package name
 *
 * Revision 1.3  2002/02/22 10:59:41  okawa
 * initial import into CVS(modify Id tag)
 *
 *
 */

package org.nomencurator.editor.command;

import java.util.Vector;
import java.util.Enumeration;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * This class manages client's command object
 */
public class CommandController {

    static public final String L_FILE        = "File";
    static public final String L_OPEN        = "Open";
    static public final String L_SAVE        = "Save";
    static public final String L_SAVE_DB     = "Save As...";
    static public final String L_CLOSE       = "Close";
    static public final String L_EXIT        = "Exit";
    static public final String L_TOOL        = "Tool";
    static public final String L_PREFERENCE  = "Peference";
    static public final String L_WINDOW      = "Window";
    static public final String L_NEW         = "New";
    static public final String L_COPYRIGHT = "Copyright";
    
    static public final String A_OPEN        = "Open";
    static public final String A_SAVE        = "Save";
    static public final String A_SAVE_DB     = "SaveDb";
    static public final String A_CLOSE       = "Close";
    static public final String A_EXIT        = "Exit";
    static public final String A_PREFERENCE  = "preference";
    static public final String A_OPEN_PANEL_NAME = "open_panel_name";
    static public final String A_OPEN_PANEL_APPEARANCE = "open_panel_appearance";
    static public final String A_OPEN_PANEL_PUBLICATION = "open_panel_publication";
    static public final String A_OPEN_PANEL_AUTHOR = "open_panel_author";
    static public final String A_WINDOW_NEW = "window_new";
    static public final String A_OPEN_COPYRIGHT = "open_copyright";

    private ActionListener actionListener;
    
	/**
     * @return MenuBar mbar
	 */
    public MenuBar createMenuBar(ActionListener l) {
        
        actionListener = l;
        
	    MenuBar mbar = new MenuBar();
	    mbar.add(createFileMenu());
	    mbar.add(createToolMenu());
	    mbar.add(createWindowMenu());
	    return mbar;
    }

	/**
     * @return File menu
	 */
    protected Menu createFileMenu() {
	    Menu menu = new Menu(L_FILE);
	    menu.add(createMenuItem(L_OPEN, A_OPEN, actionListener, false));
	    menu.add(createMenuItem(L_SAVE, A_SAVE, actionListener, false));
	    menu.add(createMenuItem(L_SAVE_DB, A_SAVE_DB, actionListener));
	    menu.add(createMenuItem(L_CLOSE, A_CLOSE, actionListener, false));
	    menu.addSeparator();
	    menu.add(createMenuItem(L_EXIT, A_EXIT, actionListener));
	    return menu;
    }

	/**
     * @return Preference menu
	 */
    protected Menu createToolMenu() {
	    Menu menu = new Menu(L_TOOL);
	    menu.add(createMenuItem(L_PREFERENCE, A_PREFERENCE, actionListener));
	    return menu;
    }

	/**
     * @return Window menu
	 */
    protected Menu createWindowMenu() {
	    Menu menu = new Menu(L_WINDOW);
	    menu.add(createMenuItem(L_NEW, A_WINDOW_NEW, actionListener));
	    menu.add(createMenuItem(L_COPYRIGHT, A_OPEN_COPYRIGHT, actionListener));
	    return menu;
    }

	/**
     * @return MenuItem mi
	 */
    protected MenuItem createMenuItem(String label, String action, ActionListener l) {
	    return createMenuItem(label, action, l, true);
    }

	/**
     * @return MenuItem mi
	 */
    protected MenuItem createMenuItem(String label, String action, ActionListener l, boolean enable) {
	    MenuItem mi = new MenuItem(label);
	    mi.setActionCommand(action);
	    mi.addActionListener(l);
	    mi.setEnabled(enable);
	    return mi;
    }
}

