/*
 * AnnotationEditModel.java:  an Annotation editor model 
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: AnnotationEditModel.java,v 1.23 2002/10/18 05:37:55 nozomi Exp $
 * $Log: AnnotationEditModel.java,v $
 * Revision 1.23  2002/10/18 05:37:55  nozomi
 * change getSummaryTextArray()
 *
 * Revision 1.22  2002/10/17 06:19:36  nozomi
 * modify Annotation hanlding
 *
 * Revision 1.21  2002/10/08 00:40:29  nozomi
 * introduce listenSubModels()
 *
 * Revision 1.20  2002/09/27 20:11:57  nozomi
 * getSummaryTextArray() uses isNominal()
 *
 * Revision 1.19  2002/09/17 05:46:02  nozomi
 * re-organise initialisation methods
 *
 * Revision 1.18  2002/09/09 16:41:43  nozomi
 * implement dummy updateSumamry()
 *
 * Revision 1.17  2002/09/07 04:02:56  nozomi
 * automatic put to unsaved pool
 *
 * Revision 1.16  2002/09/06 02:16:09  nozomi
 * implement load/saveAttributes() substantially
 *
 * Revision 1.15  2002/09/05 05:21:53  nozomi
 * null object handling in constructor
 *
 * Revision 1.14  2002/09/04 10:28:37  ryo
 * fix mistakes
 *
 * Revision 1.13  2002/09/04 03:27:32  nozomi
 * add more link types
 *
 * Revision 1.12  2002/09/04 02:40:51  nozomi
 * add nec as a link type
 *
 * Revision 1.11  2002/08/14 05:03:16  ryo
 * add some accessor function
 *
 * Revision 1.10  2002/06/21 23:22:57  nozomi
 * use RichText in TextComponents
 *
 * Revision 1.9  2002/05/17 19:11:34  ryo
 * erase the unnecessary line
 *
 * Revision 1.8  2002/05/17 15:57:54  t.okada
 * Since the argument name in AnnotationEditModel() was wrong, it corrected.
 *
 * Revision 1.7  2002/05/17 09:38:46  ryo
 * modify related to Annotation
 *
 * Revision 1.6  2002/05/16 09:13:38  ryo
 * add getSummaryTextArray() and some functions
 *
 * Revision 1.5  2002/05/14 11:37:03  nozomi
 * add dummy updateList()
 *
 * Revision 1.4  2002/04/16 03:53:38  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.3  2002/02/07 21:01:08  nozomi
 * Use AnnotationListModel
 *
 * Revision 1.2  2002/01/28 06:39:55  nozomi
 * annotator and annotatns are implemented as NameUsageListModel
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */


package org.nomencurator.editor.model;

import java.util.Enumeration;
import java.util.Vector;

import jp.kyasu.awt.TextListModel;
import jp.kyasu.awt.TextModel;
import jp.kyasu.awt.DefaultTextListModel;

import jp.kyasu.awt.event.TextModelEvent;

import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextBuffer;

import org.nomencurator.Annotation;
import org.nomencurator.NamedObject;
import org.nomencurator.NameUsage;

import org.nomencurator.broker.NamedObjectBroker;

/**
 * The model interface for an object that acts as a named object edit model
 *
 * @version 	18 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class AnnotationEditModel
    extends NamedObjectEditModel
{
    /**
     * <CODE>TextListModel</CODE> holding type of this annotation
     * e.g. synonymy, homonymy.....
     */
    protected static TextListModel annotationType
	= new DefaultTextListModel();

    /**
     * Initial contents of <CODE>annotationType</CODE>
     */
    protected static String[][] annotationTypes = {
	{"nov"},        // 1 to zero 
	{"revise"},     // 1 to 1
	{"synonym"}, // 1 to n
	{"homonym"}, // n to n
	{"sensu"},      // 1 to 1
	{"sensu lato"},      // 1 to 1
	{"sensu strict"},      // 1 to 1
	{"part"},       // n to 1
	{"nec"},     // 1 to n
	{"lapsus calami"},     // 1 to 1
	{"assign"},     // 1 to 1
	{"propagate"},     // 1 to 1
	{"combination"},     // 1 to 1
	{"nomen dubium"},     // 1 to 1
	{"nomen novum"},     // 1 to 1
	{"nomen nudum"},     // 1 to 1
	{"nomen oblitum"},     // 1 to 1
	{"nomen protectum"},     // 1 to 1
	{"species inquirenda"},     // 1 to 1
	{"equivate"},   // n to zero 
	{"refer"}      // 1 to 1
    };

    protected int annotationTypeIndex = annotationTypes.length - 1;

    protected String otherAnnotationType = null;

    static {
	annotationType.replaceItems(0, 0, annotationTypes);
    }
    
    /**
     * <CODE>AppearanceEditModel</CODE> of the appearance containing this annotation
     */
    protected AppearanceEditModel appearanceEditModel;

    
    /**
     * <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE>s
     * annotating to previous <CODE>NameUsage</CODE>s
     */
    protected Vector annotators;

    /**
     * <CODE>TextListModel</CODE> holding annotators' summary
     */
    protected NameUsageListModel annotatorListModel;

    /**
     * <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE>s
     * annotated by this object
     */
    protected Vector annotants;

    /** <CODE>TextListModel</CODE> holding annotants' summary */
    protected NameUsageListModel annotatantsListModel;

    protected static AnnotationEditModel template;

    boolean annotatorsModified;

    boolean annotatantsModified;

    /**
     * The constructor of AnnotationEditModel
     *
     */
    public AnnotationEditModel()
    {
	this(null);
    }

    /**
     * The constructor of AnnotationEditModel
     *
     * @param editable boolean determining whether the model is editable
     */
    public AnnotationEditModel(boolean editable)
    {
	this(new Annotation(), editable);
    }

    /**
     * The constructor of AnnotationEditModel
     *
     * @param object <CODE>Annotation</CODE> to be edited
     */
    public AnnotationEditModel(Annotation object)
    {
	this(object, true);
    }

    /**
     * The constructor of AnnotationEditModel
     *
     * @param object <CODE>Object</CODE> to be edited
     * @param editable boolean determining whether the model is editable
     */
    public AnnotationEditModel(Annotation object, boolean editable)
    {
	this(object, editable,
	     null, null, null);
    }

    /**
     * The constructor of AnnotationEditModel
     *
     * @param object <CODE>Object</CODE> to be edited
     * @param editable boolean determining whether the model is editable
     * @param higherEditModel <CODE>NameUsageEditModel</CODE> for higher <CODE>NameUsage</CODE>
     * of the <CODE>NameUsage</CODE> edited by this model
     * @param lowerEditModels <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE> for
     * lower <CODE>NameUsage</CODE>s of the <CODE>NameUsage</CODE> edited by this model
     * @param authority <CODE>NameUsageEditModel</CODE> for authority <CODE>NameUsage</CODE>
     * of the <CODE>NameUsage</CODE> edited by this model
     */
    public AnnotationEditModel(Annotation object, 
			       boolean editable,
			       AppearanceEditModel appearance,
			       Vector annotators,
			       Vector annotants
			       )
    {
	super(object, editable);
	/*
	if(object == null) {
	    object = new Annotation();
	    setObject(object);
	}

	setAnnotationTypeString(object.getLinkType());
	
	setAppearanceEditModel(appearance);
	*/
	//	annotatorListModel = new NameUsageListModel();
	/*
	NamedObjectBroker b = NamedObjectBroker.getInstance();
	Vector v = object.getAnnotators();
	if(v != null)
	    annotators = getModels(v);

	//	this.annotators = new Vector();
	if(annotators != null &&
	   annotators.size() != 0) {
	    annotatorListModel.setModels(annotators);
	*/
	    /*
	    Enumeration e = annotators.elements();
	    while(e.hasMoreElements()) {
		addAnnotatorNameUsageEditModel((NameUsageEditModel)(e.nextElement()));
	    }
	    */
	/*
	}

	//	annotatantsListModel = new NameUsageListModel();

	v = object.getAnnotatants();
	if(v != null)
	    annotants = getModels(v);
	//	this.annotants = new Vector();
	if(annotants != null &&
	   annotants.size() != 0) {

	    annotatantsListModel.setModels(annotants);
	}
	*/

    }

    /**
     * Creates submodles representing the <CODE>Publication</CODE> under edition.
     */
    protected void createSubModels()
    {
	super.createSubModels();

	annotatorListModel = new NameUsageListModel();
	annotatantsListModel = new NameUsageListModel();
    }

    /**
     * Listens submodles
     */
    protected void listenSubModels()
    {
    }

    /**
     * Sets given <CODE>AppearanceEditModel</CODE> as
     * <CODE>Appearance</CODE> encodes this annotation
     */
    public void setAppearanceEditModel(AppearanceEditModel model)
    {
	if(appearanceEditModel == model)
	    return;

	if(appearanceEditModel != null) {
	    appearanceEditModel.removeAnnotationEditModel(this);
	}

	appearanceEditModel = model;

	if(appearanceEditModel == null)
	    return;

	appearanceEditModel.addAnnotationEditModel(this);
    }

    public void addAnnotatorNameUsageEditModel(NameUsageEditModel nameUsageEditModel)
    {
	//annotators.addElement(nameUsageEditModel);
	annotatorListModel.addModel(nameUsageEditModel);
    }

    public void /*boolean*/ removeAnnotatorNameUsageEditModel(NameUsageEditModel nameUsageEditModel)
    {
	//	return annotators.removeElement(nameUsageEditModel);
	annotatorListModel.removeModel(nameUsageEditModel);
    }

    public void addAnnotatedNameUsageEditModel(NameUsageEditModel nameUsageEditModel)
    {
	//	annotants.addElement(nameUsageEditModel);
	annotatantsListModel.addModel(nameUsageEditModel);
    }

    public void /*boolean*/ removeAnnotatedNameUsageEditModel(NameUsageEditModel nameUsageEditModel)
    {
	//return annotants.removeElement(nameUsageEditModel);
	annotatantsListModel.removeModel(nameUsageEditModel);
    }

    /**
     * Gets <CODE>Object</CODE> to be edited by this model.
     *
     */
    public Annotation getAnnotation()
    {
	return (Annotation)getObject();
    }

    /**
     * Gets <CODE>Object</CODE> to be edited by this model.
     *
     */
    public void setAnnotation(Annotation object)
    {
	setObject(object);
    }

    /**
     * Gets <CODE>TextListModel</CODE> holding annotationType
     */
    public TextListModel getAnnotationType()
    {
	return annotationType;
    }

    /**
     * Gets annotation type list.
     */
    public static String[][] getAnnotationTypeList() {
	return annotationTypes;
    }
    
    /**
     * Sets given <CODE>TextListModel</CODE> as type of this annotation
     */
    public void getAnnotationType(TextListModel annotationType)
    {
	if(this.annotationType == annotationType)
	    return;

	this.annotationType = annotationType;
    }

    /**
     * Gets <CODE>TextListModel</CODE> representing annotators
     */
    public TextListModel getAnnotatorListModel()
    {
	return annotatorListModel;
    }

    /**
     * Gets <CODE>TextListModel</CODE> representing annotants
     */
    public TextListModel getAnnotantListModel()
    {
	return annotatantsListModel;
    }

    /**
     * Gets <CODE>AppearanceEditModel</CODE> whose
     * <CODE>Appearance</CODE> encodes this annotation
     */
    public AppearanceEditModel getAppearanceEditModel()
    {
	return appearanceEditModel;
    }

    /**
     * Gets <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE>s
     * annotating to previous <CODE>NameUsage</CODE>s
     */
    public Vector getAnnotators()
    {
	//	return annotators;
	return annotatorListModel.getModels();
    }

    /**
     * Sets given <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE>s
     * as annotors to previous <CODE>NameUsage</CODE>s
     */
    public void setAnnotators(Vector annotators)
    {
	/*
	if(this.annotators == annotators)
	    return;

	this.annotators = annotators;
	*/
	annotatorListModel.setModels(annotators);
    }

    /**
     * Gets <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE>s
     * annotated via the <CODE>Annotation</CODE>
     */
    public Vector getAnnotants()
    {
	//return annotants;
	return annotatantsListModel.getModels();
    }

    /**
     * Sets given <CODE>Vector</CODE> of <CODE>NameUsageEditModel</CODE>s
     * as <CODE>NameUsageEditModel</CODE>s annotated via the <CODE>Annotation</CODE>
     */
    public void setAnnotants(Vector annotants)
    {
	/*
	if(this.annotants == annotants)
	    return;

	this.annotants = annotants;
	*/
	annotatantsListModel.setModels(annotators);
    }

    public void clear()
    {
    }

    public Object clone()
    {
	return new AnnotationEditModel();
    }

    public void updateList()
    {
    }
    
    public int getAnnotationTypeIndex()
    {
	return annotationTypeIndex;
    }
    
    public void setAnnotationTypeIndex(int i)
    {
	annotationTypeIndex = i;
    }
    
    /**
     * Gets an annotation type by <CODE>String</CODE>
     * @return String an annotation type string
     */
    public String getAnnotationTypeString()
    {
	if (0 <= annotationTypeIndex
	    && annotationTypeIndex <= annotationTypes.length) {
	    return annotationTypes[annotationTypeIndex][0];
	}
	return otherAnnotationType;
    }
    
    /**
     * Sets an annotation type by <CODE>String</CODE>
     * @param type an annotation type string
     */
    public void setAnnotationTypeString(String type) {
	int n = annotationTypes.length;
	for (int i = 0; i < n; i++) {
	    if (annotationTypes[i][0].equals(type)) {
		annotationTypeIndex = i;
		otherAnnotationType = null;
		return;
	    }
	}
	annotationTypeIndex = -1;
	otherAnnotationType = type;
    }
    
    /**
     * Gets summary contents in <CODE>Text</CODE>
     *
     * @return Text[] representing summary of the model
     */
    public Text[] getSummaryTextArray()
    {
	if(getAnnotation().isNominal()) {
	    return new Text[] {
		//new Text(),
		new Text(getAnnotation().getLinkType()),
		new Text()
	    };
	}

	return new Text[] {
	    //getNameListText(annotatorListModel.getModels()),
	    new Text(getAnnotationTypeString()),
	    getNameListText(annotatantsListModel.getModels()),
	};
    }

    protected Text getNameListText(Vector names)
    {
	Text text = new Text("");
	if(names == null || names.isEmpty())
	    return text;
	boolean first = true;
	Enumeration e = names.elements();
	while(e.hasMoreElements()){
	    if(!first)
		text.append(", ");
	    NameUsageEditModel n = 
		(NameUsageEditModel)e.nextElement();
	    text.append(n.getUsedName());
	    first = false;
	}

	return text;
    }
    
    /**
     * Loeds attributes of <CODE>Object</CODE> to the model
     */
    public void loadAttributes()
    {
	super.loadAttributes();
	Annotation annotation = getAnnotation();
	
	setAnnotationTypeString(annotation.getLinkType());

	NamedObjectBroker broker = NamedObjectBroker.getInstance();
	annotatorListModel.setObjects(annotation.getAnnotators());
	annotatantsListModel.setObjects(annotation.getAnnotatants());
    }


    /**
     * Saves attributes from the model to <CODE>Object</CODE>
     */
    public void saveAttributes()
    {
	NamedObjectBroker b = NamedObjectBroker.getInstance();

	Annotation annotation = getAnnotation();
	if(isModified()) //? 
	    b.putUnsavedObject(annotation);
	
	/*
	annotation.getAppearance().addAnnotation(annotation);
	if(isModified()) 
	    b.putUnsavedObject(annotation.getAppearance());
	*/

	annotation.setLinkType(getAnnotationTypeString());

	Vector v = annotatorListModel.getNamedObjects();
	annotation.setAnnotators(v);
	Enumeration e = v.elements();
	while(e.hasMoreElements()) {
	    NameUsage n = (NameUsage)e.nextElement();
	    n.addAnnotation(annotation);
	    if(isModified()) //? 
		b.putUnsavedObject(n);
	}

	annotation.setAnnotatants(annotatantsListModel.getNamedObjects());
    }

    public void updateSummary()
    {
	
    }

    /**
     * Creates and returns an instance of <CODE>NamedObjectEditModel</CODE>
     * representing <CODE>object</CODE>.
     * The subclass must provide this method creating its an instance.
     *
     * @param object an instance of <CODE>NamedObject</CODE> to be represened by the model
     *
     * @return NamedObjectEditModel representing <CODE>object</CODE>
     */
    NamedObjectEditModel createEditModel(NamedObject object)
    {
	if(!(object instanceof Annotation))
	    throw new IllegalArgumentException(object.getClass().getName()
						+ " is not an instance of org.nomencurator.Annotation");

	return new AnnotationEditModel((Annotation)object);
    }

    public static NamedObjectEditModel getInstance()
    {
	if(template == null)
	    template = new AnnotationEditModel();
	return template;
    }

    protected boolean isAnnotatorsModified()
    {
	return annotatorsModified;
    }

    protected void setAnnotatorsModified(boolean status)
    {
	annotatorsModified = status;
	if(status)
	    modified = status;
    }

    protected boolean isAnnotatantsModified()
    {
	return annotatantsModified;
    }

    protected void setAnnotatantsModified(boolean status)
    {
	annotatantsModified = status;

	if(status)
	    modified = status;
    }

    /**
     * Invoked when the text model has been changed.
     */
    public void textModelChanged(TextModelEvent event)
    {
	Object source = event.getSource();
	if (source == annotatorListModel) {
	    setAnnotatorsModified(true);
	}
	else if (source == annotatantsListModel) {
	    setAnnotatantsModified(true);
	}
	else {
	    super.textModelChanged(event);
	}
    }

}
