/*
 * AuthorListModel.java:  a TextListModel containing Annotatoins' summary
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AuthorListModel.java,v 1.12 2002/10/17 04:17:03 nozomi Exp $
 * $Log: AuthorListModel.java,v $
 * Revision 1.12  2002/10/17 04:17:03  nozomi
 * implement own getDummyModel()
 *
 * Revision 1.11  2002/10/02 20:03:40  nozomi
 * update() when summary is required
 *
 * Revision 1.10  2002/09/17 08:26:15  nozomi
 * implement getModels()
 *
 * Revision 1.9  2002/09/06 07:44:29  nozomi
 * improved Publication#getAuthorListSummary()
 *
 * Revision 1.8  2002/06/10 12:36:38  ryo
 * call update() before authorsSummary is returned in getAuthorsSummaryModel()
 *
 * Revision 1.7  2002/06/07 14:10:55  ryo
 * use surname only when authorListSummary is created
 *
 * Revision 1.6  2002/05/31 14:07:15  nozomi
 * remove static member initialization from non static method
 *
 * Revision 1.5  2002/05/31 11:35:50  ryo
 * change the rule of creating authors string
 *
 * Revision 1.4  2002/05/31 10:23:04  ryo
 * change the rule of creating authors string
 *
 * Revision 1.3  2002/05/31 06:01:30  nozomi
 * add getAUthorsSummaryModel()
 *
 * Revision 1.2  2002/05/31 05:49:44  nozomi
 * add TextEditModel to hold author summary
 *
 * Revision 1.1  2002/05/21 05:11:57  nozomi
 * initial import to CVS repository
 *
 */


package org.nomencurator.editor.model;

import jp.kyasu.awt.Label;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.TextEditModel;
import jp.kyasu.awt.DefaultTextEditModel;
import jp.kyasu.awt.TextField;

import jp.kyasu.awt.event.TextModelEvent;
import jp.kyasu.awt.event.TextModelListener;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextList;
import jp.kyasu.graphics.TextStyle;
import jp.kyasu.graphics.RichText;
import jp.kyasu.graphics.RichTextStyle;

import java.util.Enumeration;
import java.util.Observer;
import java.util.Observable;
import java.util.Vector;

import org.nomencurator.Author;
import org.nomencurator.NamedObject;
import org.nomencurator.Publication;

/**
 * The model representing list of <code>Author</code>s' summary
 *
 * @version 	17 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class AuthorListModel
    extends NamedObjectListModel
    implements Observer
{
    protected TextEditModel authorsSummary;
    
    private static final Text[][] emptyAuthorSummary = 
	new Text[][]{{EMPTY_TEXT}};

    private static Text etalText =
	new Text(" et al.", TextStyle.DEFAULT_STYLE.deriveItalicStyle());

    protected static final AuthorEditModel dummyModel = new AuthorEditModel();

    /**
     * Returns title of <code>AuthorListModel</code>
     *
     */
    public String[] getTitle()
    {
	//return getDefaultTitle();
	return null;
    }

    /**
     * Sets <code>title</code> as title of <code>AuthorListModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public void setTitle(String[] title)
    {
	//	setDefaultTitle(title);
    }

    /**
     * Returns title of <code>AuthorListModel</code>
     *
     */
    public static String[] getDefaultTitle()
    {
	//	return defaultTitle;
	return null;
    }

    /**
     * Sets <code>title</code> as title of <code>AuthorListModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public static void setDefaultTitle(String[] title)
    {
    }

    /**
     * Returns alignments of title
     *
     */
    public int[] getAlignments()
    {
	//	return getDefaultAlignments();
	return new int[0];
    }

    /**
     * Sets <code>alighnemnts</code> as title alignment of <code>TextListModel</code> implementing this interface
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public void setAlignments(int[] alignments)
    {
	//	setDefaultAlignments(alignments);
    }
    
    /**
     * Returns alignments of title
     *
     */
    public static int[] getDefaultAlignments()
    {
	//	return defaultAlignments;
	return new int[0];
    }

    /**
     * Sets <code>alighnemnts</code> as title alignment of <code>TextListModel</code> implementing this interface
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public static void setDefaultAlignments(int[] alignments)
    {
	//	defaultAlignments = alignments;
    }
    
    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public AuthorListModel()
    {
	this(false);
    }

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public AuthorListModel(boolean enable)
    {
	this(RichTextStyle.DEFAULT_LIST_STYLE, enable);
    }

    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public AuthorListModel(RichTextStyle richTextStyle, boolean enable)
    {
	super(richTextStyle, enable);
    }


    /**
     * Constructs a text list model with the specified <code>textList</code>
     *
     * @param textList      <code>TextList</code> to be used by this object
     */
    public AuthorListModel(TextList textList)
    {
	super(textList);
    }

    /**
     * Initializes additional components of this model.
     * The subclasses may override this method to initialize
     * their own members 
     *
     * @param enable true if automatic dummy addition is enabled
     */
    protected void initialize(boolean enable)
    {
	super.initialize(enable);
	authorsSummary = new DefaultTextEditModel(new RichText(new Text(""), TextField.DEFAULT_FIELD_STYLE));
    }

    /**
     * Returns Text array representing empty summary 
     * can be used to represent a dummy <code>NamedObjectEditModel</code>.
     *
     * @return Text[][] representing a summary of an empty <code>NamedObjectEditModel</code>.
     */
    public Text[][] getEmptySummary()
    {
	return emptyAuthorSummary;
    }

    /**
     * Returns a dummy <code>NamedObjectEditModel</code> instance for double-clicking
     * operation.
     *
     * @return null to be considered as a dummy <code>NamedObjectEditModel</code>
     */
    public NamedObjectEditModel getDummyModel()
    {
	return dummyModel;
    }

    /**
     * Updates summary text of <code>model</code> in the list
     */
    public void update()
    {
	super.update();
	ObjectEditModel.setString(authorsSummary, Publication.getAuthorListSummary(getNamedObjects()));
    }

    /**
     * Returns <CODE>TextEditModel</CODE> representing summary of 
     * <CODE>Author</CODE>s in this model
     *
     * @return TextEditModel representing summary of authors
     */
    public TextEditModel getAuthorsSummaryModel()
    {
	update();
	return authorsSummary;
    }

    /**
     * Creates and returns an instance of <CODE>NamedObjectEditModel</CODE>
     * representing <CODE>object</CODE>.
     * The subclass must provide this method creating its an instance.
     *
     * @param namedObjects <CODE>Vector</CODE> containing <CODE>NamedObject</CODE>s
     * to be represented by <CODE>NamedObjectEditModel</CODE>s
     *
     * @return NamedObjectEditModel representing <CODE>object</CODE>
     */
    protected Vector getModels(Vector namedObjects)
    {
	return getModels(namedObjects, AuthorEditModel.getInstance());
    }

    public void update(Observable observable, Object arg)
    {
	update();
    }

}
