/*
 * ConnectionListModel.java : 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ConnectionListModel.java,v 1.4 2002/09/17 08:26:15 nozomi Exp $
 * $Log: ConnectionListModel.java,v $
 * Revision 1.4  2002/09/17 08:26:15  nozomi
 * implement getModels()
 *
 * Revision 1.3  2002/08/01 08:05:34  ryo
 * rename to "enable" from "valid"
 *
 * Revision 1.2  2002/07/16 07:09:58  ryo
 * extends NamedObjectListModel, instead of DefaultTextListModel
 *
 * Revision 1.1  2002/07/12 16:56:18  ryo
 * initial import into CVS, add connection setting logic
 *
 */

package org.nomencurator.editor.model;

import jp.kyasu.awt.TableList;
import jp.kyasu.awt.DefaultTextListModel;
import jp.kyasu.graphics.Text;

import java.util.Vector;
import java.util.Enumeration;

import org.nomencurator.broker.AbstractConnection;

public class ConnectionListModel
extends NamedObjectListModel
{

	protected static String[] columnTitles = {
		"name",
		"type",
		"driver",
		"url",
		"username",
		"password",
		"path",
		"enable",
		"writable"
	};

	protected static int[] columnWidths =
		TableList.columnWidths(columnTitles);

	public String[] getColumnTitles() {
		return columnTitles;
	}
	
	public int[] getColumnWidths() {
		return columnWidths;
	}

	public ConnectionListModel() {
		super(columnWidths);
	}

	public void setAbstractConnections(Vector v) {
		Vector models = new Vector();
		if (v != null) {
			for (Enumeration e = v.elements(); e.hasMoreElements(); )
				models.addElement(new ConnectionEditModel((AbstractConnection)e.nextElement()));
		}
		setModels(models);
	}

    /**
     * Creates and returns an instance of <CODE>NamedObjectEditModel</CODE>
     * representing <CODE>object</CODE>.
     * The subclass must provide this method creating its an instance.
     *
     * @param namedObjects <CODE>Vector</CODE> containing <CODE>NamedObject</CODE>s
     * to be represented by <CODE>NamedObjectEditModel</CODE>s
     *
     * @return NamedObjectEditModel representing <CODE>object</CODE>
     */
    protected Vector getModels(Vector namedObjects)
    {
	return getModels(namedObjects, ConnectionEditModel.template);
    }

}
