/*
 * DefaultTextListModel.java:  an implementation of TextListModel
 * to be used by TableList of TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 *
 * $Id: DefaultTextListModel.java,v 1.10 2002/10/11 03:42:54 nozomi Exp $
 * $Log: DefaultTextListModel.java,v $
 * Revision 1.10  2002/10/11 03:42:54  nozomi
 * add up(int), down(int) and moveModel(int, int) methods)
 *
 * Revision 1.9  2002/09/17 08:29:56  nozomi
 * add/removeModel() methods return boolean; add removeAll()
 *
 * Revision 1.8  2002/09/06 02:19:16  nozomi
 * use ModelSelctor
 *
 * Revision 1.7  2002/05/16 23:20:18  nozomi
 * model may be null
 *
 * Revision 1.6  2002/05/14 10:15:09  ryo
 * add addModel()
 *
 * Revision 1.5  2002/03/05 01:51:12  nozomi
 * modify update() methods
 *
 * Revision 1.4  2002/03/03 23:50:39  nozomi
 * change in item insertion
 *
 * Revision 1.3  2002/02/28 17:11:22  nozomi
 * use DefaultTextListModel of the package
 *
 * Revision 1.2  2002/02/28 03:19:24  nozomi
 * add update() methods
 *
 * Revision 1.1  2002/02/27 23:43:18  nozomi
 * initial import to CVS
 *
 */

package org.nomencurator.editor.model;

import java.util.Enumeration;
import java.util.Vector;

import jp.kyasu.graphics.RichText;
import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextList;

/**
 * Extention of <code>jp.kyasu.awt.DefaultTextListModel</code>
 * supporting <code>NamedObjectEditModel</code> selection
 * defined by <code>org.nomencurator.editor.model.TextListModel</code>
 *
 * @see 	jp.kyasu.awt.DefaultTextListModel
 *
 * @version 	11 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class DefaultTextListModel
    extends jp.kyasu.awt.DefaultTextListModel
    implements TextListModel, ModelSelector
{
    /** <code>Vector</code> holding <code>NamedObjectEditModel</code>s */
    //    protected Vector models;
    ModelSelector selector;

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public DefaultTextListModel()
    {
	this(false);
    }
    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public DefaultTextListModel(boolean enableDummyModel)
    {
	super();
	selector = new ModelSelectAdaptor(this, enableDummyModel);
    }

    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public DefaultTextListModel(RichTextStyle richTextStyle)
    {
	super(richTextStyle);
    }


    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public DefaultTextListModel(int colWidths[])
    {
	this(colWidths.length, colWidths);
    }

    /**
     * Constructs a text list model with the specified number of columns
     * and column widths.
     *
     * @param columns   the number of columns.
     * @param colWidths the column widths.
     */
    public DefaultTextListModel(int columns, int colWidths[])
    {
	super(columns, colWidths);
    }

    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public DefaultTextListModel(int columns, int colWidths[],
				RichTextStyle richTextStyle)
    {
	super(columns, colWidths, richTextStyle);
    }

    /**
     * Constructs a text list model with the specified <code>textList</code>
     *
     * @param textList      <code>TextList</code> to be used by this object
     */
    public DefaultTextListModel(TextList textList)
    {
	super(textList);
	selector = new ModelSelectAdaptor(this, false);
    }

    /**
     * Constructs a text list model with the specified <code>textList</code>
     *
     * @param textList      <code>TextList</code> to be used by this object
     */
    protected void defaultTextListModel(TextList textList, boolean isTable)
    {
	super.defaultTextListModel(textList, isTable);
	//	models = new Vector();
	selector = new ModelSelectAdaptor(this, false);
    }

    //======== org.nomencurator.editor.ModelSelector APIs ========
    /**
     * Returns <code>TextListModel</code> representing summaries of 
     * <code>NamedObjectEditModel</code> handled by this selector
     *
     * @return TextListModel representing summaries of 
     * <code>NamedObjectEditModel</code> handled by this selector
     */
    public jp.kyasu.awt.TextListModel getModel()
    {
	return this;
    }

    /**
     * Sets <code>list</code> as representation of this selector
     */
    public void setModel(jp.kyasu.awt.TextListModel model)
    {
	//ignore
    }

    /**
     * Enables or desables automatic addition of a dummy
     * <code>NamedObjectEditModel</code> to the list according to
     * value of <code>enable</code>
     *
     * @param enable <code>boolean</code> enables 
     * automatic addition of a dummy <code>NamedObjectEditModel</code>
     * if true or disables if false
     */
    public void enableDummyModel(boolean enable)
    {
	selector.enableDummyModel(enable);
    }

    /**
     * Returns true if automatic addition of a dummy 
     * <code>NamedObjectEditModel</code> is enabled
     * or false if disabled.
     *
     * @return true if automatic addition of a dummy 
     * <code>NamedObjectEditModel</code> is enabled
     * or false if disabled.
     */
    public boolean isDummyModelEnabled()
    {
	return selector.isDummyModelEnabled();
    }

    /**
     * Returns a dummy <code>NamedObjectEditModel</code> instance for double-clicking
     * operation.
     *
     * @return null to be considered as a dummy <code>NamedObjectEditModel</code>
     */
    public NamedObjectEditModel getDummyModel()
    {
	return null;
    }

    /**
     * Returns Text array representing empty summary 
     * can be used to represent a dummy <code>NamedObjectEditModel</code>.
     *
     * @return Text[][] representing a summary of an empty <code>NamedObjectEditModel</code>.
     */
    public Text[][] getEmptySummary()
    {
	return selector.getEmptySummary();
    }


    //======== org.nomencurator.editor.TextListModel APIs ========

    /**
     * Returns <code>Vector</code> of <code>NamedObjectEditModel</code>
     * accompanying to the <code>ListModel</code>
     */
    public Vector getModels()
    {
	//	return models;
	return selector.getModels();
    }

    /**
     * Sets <code>models</code> as <code>NamedObjectEditModel</code> list
     * accompanying to the <code>ListModel</code>
     */
    public void setModels(Vector models)
    {
	selector.setModels(models);
	/*
	if(this.models == models)
	    return;
	this.models = models;
	Text[][] texts = new Text[models.size()][];
	Enumeration e = models.elements();
	int i = 0;
	while(e.hasMoreElements()) {
	    texts[i++] = ((NamedObjectEditModel)e.nextElement()).getSummaryTextArray();
	}
	removeSelection(0, getItemCount() - 1);
	replaceItems(0, getItemCount(), texts);
	*/
    }

    /**
     * Adds <code>model</code> to <code>NamedObjectEditModel</code> list
     *
     * @param model <code>NamedObjectEditModel</code> to be added to this selector
     */
    public boolean addModel(NamedObjectEditModel model)
    {
	//	addModel(-1, model);
	return selector.addModel(model);
    }

    /**
     * Inserts <code>model</code> at <code>index</code> of <code>NamedObjectEditModel</code> list.
     *
     * @param index  where <code>model</code> to be added
     * @param model <code>NamedObjectEditModel</code> to be added
     */
    public boolean addModel(int index, NamedObjectEditModel model)
    {
	//	addModel(index, model, new Text[][] { model.getSummaryTextArray()});
	return selector.addModel(index, model);
    }

    /**
     * Inserts <code>model</code> at <code>index</code> of <code>NamedObjectEditModel</code> list.
     *
     * @param index  where <code>model</code> to be added
     * @param model <CODE>NamedObjectEditModel</CODE> to be added
     * @param items an array of <CODE>Object</CODE>s representing contents of the <CODE>model</CODE>
     */
    public boolean addModel(int index, NamedObjectEditModel model, Object[][] items)
    {
	/*
	int itemCount = getItemCount();
	if (index <= -1 || index >= itemCount)
	    index = itemCount;
	models.insertElementAt(model, index);
	replaceItems(index, index, items);
	*/
	return selector.addModel(index, model, items);
    }

    /**
     * Removes <code>model</code> from <code>NamedObjectEditModel</code> list
     *
     * @param model <code>NamedObjectEditModel</code> to be removed from this selector
     */
    public boolean removeModel(NamedObjectEditModel model)
    {
	/*
	int index = indexOf(model);
	if(index < -1)
	    return;
	models.removeElementAt(index);
	replaceItems(index, index + 1,
			   new String[0][getColumnCount()]);
	*/
	return selector.removeModel(model);
    }

    /**
     * Remove all <code>NamedObjectEditModel</code>s from <code>NamedObjectEditModel</code> list
     *
     */
    public void removeAllModels()
    {
	selector.removeAllModels();
    }


    /**
     * Returns <code>NamedObjectEditModel</code> at <code>index</code>
     *
     * @param index  where <code>model</code> is
     * @return <code>NamedObjectEditModel</code> at  <code>index</code>
     */
    public NamedObjectEditModel getModel(int index)
    {
	/*
	if(index < 0 || index >= models.size()) 
	    return null;
	return (NamedObjectEditModel)models.elementAt(index);
	*/
	return selector.getModel(index);
    }

    /**
     * Selects <code>model</code> from <code>NamedObjectEditModel</code> list
     *
     * @param model <code>NamedObjectEditModel</code> to be selected
     */
    public void selectModel(NamedObjectEditModel model)
    {
	selector.selectModel(model);
    }

    /**
     * Selects an <code>NamedObjectEditModel</code> at <code>index</code> of list
     *
     * @param index of <code>NamedObjectEditModel</code> to be selected
     */
    public void selectModelAt(int index)
    {
	selector.selectModelAt(index);
    }

    /**
     * Returns selected <code>NamedObjectEditModel</code>
     *
     * @return <code>NamedObjectEditModel</code> selected
     */
    public NamedObjectEditModel getSelectedModel()
    {
	/*
	if(models.size() == 0)
	    return null;

	int index = getSelectedIndex();
	if(models.size() <= index)
	    return null;

	if(index == -1)
	    index = 0;

	return (NamedObjectEditModel)models.elementAt(index);
	*/
	return selector.getSelectedModel();
    }

    /**
     * Returns selected <code>NamedObjectEditModel</code>
     *
     * @return <code>NamedObjectEditModel[]</code> selected
     */
    public NamedObjectEditModel[] getSelectedModels()
    {
	/*
	if(getSelectedCount() == 0)
	    return new NamedObjectEditModel[0];

	int[] indices = getSelectedIndexes();
	NamedObjectEditModel[] selectedModels = 
	    new NamedObjectEditModel[indices.length];
	for(int i = 0; i < indices.length; i++)
	    selectedModels[i] = (NamedObjectEditModel)models.elementAt(i);
	return selectedModels;
	*/
	return selector.getSelectedModels();
    }

    /**
     * Returns index of selected <code>NamedObjectEditModel</code>
     *
     * @return int index of selected <code>NamedObjectEditModel</code>
     */
    public int getSelectedIndex()
    {
	/*
	int[] indices = getSelectedIndexes();
	if(indices == null || indices.length < 1)
	    return -1;
	return getSelectedIndexes()[0];
	*/
	return selector.getSelectedIndex();
    }

    /**
     * Returns index of <code>model</code>
     *
     * @param model <code>NamedObjectEditModel</code> to be searched
     * @return int index of <code>model</code>
     */
    public int indexOf(NamedObjectEditModel model)
    {
	/*
	return models.indexOf(model);
	*/
	return selector.indexOf(model);
    }



    /**
     * Updates summary text of all specified <code>model</code> in the list
     *
     * @param model <code>NamedObjectEditModel</code> to be updated
     */
    public void update()
    {
	/*
	for (int i=0; i<models.size(); i++) {
		update(i);
	}
	*/
	selector.update();
    }

    /**
     * Updates summary text of specified <code>model</code> in the list
     *
     * @param model <code>NamedObjectEditModel</code> to be updated
     */
    public void update(NamedObjectEditModel model)
    {
	/*
	int index = indexOf(model);
	if(index == -1)
	    addModel(model);
	update(indexOf(model));
	*/
	selector.update(model);
    }

    /**
     * Updates summary text of model specified by <code>index</code>
     *
     * @param index index of <code>NamedObjectEditModel</code> to be updated
     */
    public void update(int index)
    {
	/*
	int itemCount = getItemCount();
	if (itemCount == 0)
		return;
	if (index <= -1 || index >= itemCount)
	    index = itemCount;

	NamedObjectEditModel model = 
	    (NamedObjectEditModel)models.elementAt(index);
	if(model != null)
	    replaceItems(index, index + 1, new Text[][]{model.getSummaryTextArray()});
	*/
	selector.update(index);
    }

    /**
     * Returns true if this <code>ModelSelector</code> contains <code>model</code>
     * or false if not.
     *
     * @return true if this <code>ModelSelector</code> contains <code>model</code>
     * or false if not.
     */
    public boolean contains(NamedObjectEditModel model)
    {
	return selector.contains(model);
    }

    /**
     * Returns <code>Vector</code> of <code>NamedObjectEditModel</code>
     * accompanying to the <code>ListModel</code>
     */
    public Vector getNamedObjects()
    {
	return selector.getNamedObjects();
    }

    /**
     * Moves position of <CODE>NamedObjectEditModel</CODE> at
     * <CODE>index</CODE> to the place just one above
     */
    public boolean up(int index)
    {
	return selector.up(index);
    }


    /**
     * Moves position of <CODE>NamedObjectEditModel</CODE> at
     * <CODE>index</CODE> to the place just one below
     */
    public boolean down(int index)
    {
	return selector.down(index);
    }

    /**
     * Moves position of <CODE>NamedObjectEditModel</CODE> at
     * <CODE>source</CODE> to <CODE>destination</CODE>
     */
    public boolean moveModel(int source, int destination)
    {
	return selector.moveModel(source, destination);
    }
}

