/*
 * GenericNamedObjectListModel.java:  an implementation of TextListModel
 * to be used by TableList of TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * $Id: GenericNamedObjectListModel.java,v 1.1 2002/10/11 03:45:38 nozomi Exp $
 * $Log: GenericNamedObjectListModel.java,v $
 * Revision 1.1  2002/10/11 03:45:38  nozomi
 * introduced for ShoppingList
 *
 */

package org.nomencurator.editor.model;

import java.util.Enumeration;
import java.util.Vector;

import jp.kyasu.graphics.RichText;
import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextList;

import org.nomencurator.NamedObject;
import org.nomencurator.Annotation;
import org.nomencurator.Appearance;
import org.nomencurator.Author;
import org.nomencurator.NameUsage;
import org.nomencurator.Publication;

import org.nomencurator.broker.NamedObjectBroker;

/**
 * Extention of <CODE>jp.kyasu.awt.DefaultTextListModel</CODE>
 * supporting <CODE>NamedObjectEditModel</CODE> selection
 * defined by <CODE>org.nomencurator.editor.model.TextListModel</CODE>
 *
 * @see 	jp.kyasu.awt.DefaultTextListModel
 *
 * @version 	10 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class GenericNamedObjectListModel
    extends NamedObjectListModel

{
    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public GenericNamedObjectListModel()
    {
	this(false);
    }

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public GenericNamedObjectListModel(boolean enable)
    {
	this(RichTextStyle.DEFAULT_LIST_STYLE, enable);
    }

    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public GenericNamedObjectListModel(RichTextStyle richTextStyle)
    {
	this(richTextStyle, false);
    }


    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public GenericNamedObjectListModel(RichTextStyle richTextStyle, boolean enable)
    {
	super(richTextStyle, enable);
    }

    /**
     * Creates and returns an instance of <CODE>NamedObjectEditModel</CODE>
     * representing <CODE>object</CODE>.
     * The subclass must provide this method creating its an instance.
     *
     * @param namedObjects <CODE>Vector</CODE> containing <CODE>NamedObject</CODE>s
     * to be represented by <CODE>NamedObjectEditModel</CODE>s
     *
     * @return NamedObjectEditModel representing <CODE>object</CODE>
     */
    protected Vector getModels(Vector namedObjects)
    {
	if(namedObjects == null ||
	   namedObjects.isEmpty())
	    return null;

	Vector v = new Vector();

	Enumeration e = namedObjects.elements();
	while(e.hasMoreElements()) {
	    NamedObject obj = (NamedObject)e.nextElement();
	    NamedObjectEditModel model = null;
	    if ( obj instanceof Annotation )
		model = new AnnotationEditModel((Annotation)obj);
	    else if ( obj instanceof Appearance )
		model = new AppearanceEditModel((Appearance)obj);
	    else if ( obj instanceof Author )
		model = new AuthorEditModel((Author)obj);
	    else if ( obj instanceof NameUsage )
		model = new NameUsageEditModel((NameUsage)obj);
	    else if ( obj instanceof Publication )
		model = new PublicationEditModel((Publication)obj);

	    if(model != null)
		v.addElement(model);
	}
	return v;
    }

}
