/*
 * LocaleListModel.java:  a TextListModel handles Rank
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: LocaleListModel.java,v 1.2 2002/10/10 16:08:09 nozomi Exp $
 * $Log: LocaleListModel.java,v $
 * Revision 1.2  2002/10/10 16:08:09  nozomi
 * separtion Code and ordinary locales for the GUI
 *
 * Revision 1.1  2002/08/22 13:26:55  t.okada
 * It corrects for a locale colum addition.
 */	


package org.nomencurator.editor.model;

import java.util.Observable;
import java.util.Observer;
import java.util.Hashtable;

import jp.kyasu.awt.TextListModel;
import jp.kyasu.awt.DefaultTextListModel;

import org.nomencurator.Rank;

/**
 * The TextListModel to handle (extended) locales
 *
 * @see 	jp.kyasu.awt.DefaultTextListModel
 * @see 	org.nomencurator.Rank
 *
 * @version 	10 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class LocaleListModel
    //    extends DefaultTextListModel
    implements Observer
{
    /** Initial contents of <code>LocaleListModel</code> */
    protected static String[][]  codeNames = {{" "}, {"ICBN"}, {"ICNB"}, {"ICZN"}};

    /** Initial contents of <code>LocaleListModel</code> */
    protected static String[][]  localeNames = {{" "},
												{"Arabic(AE)"},
												{"Arabic(BH)"},
												{"Arabic(DZ)"},
												{"Arabic(EG)"},
												{"Arabic(IQ)"},
												{"Arabic(JO)"},
												{"Arabic(KW)"},
												{"Arabic(LB)"},
												{"Arabic(LY)"},
												{"Arabic(MA)"},
												{"Arabic(OM)"},
												{"Arabic(QA)"},
												{"Arabic(SA)"},
												{"Arabic(SD)"},
												{"Arabic(SY)"},
												{"Arabic(TN)"},
												{"Arabic(YE)"},
												{"Byelorussian"},
												{"Bulgarian"},
												{"Catalan"},
												{"Czech"},
												{"Danish"},
												{"German(AT)"},
												{"German(CH)"},
												{"German(DE)"},
												{"German(LU)"},
												{"Greek"},
												{"English(AU)"},
												{"English(CA)"},
												{"English(GB)"},
												{"English(IE)"},
												{"English(NZ)"},
												{"English(US)"},
												{"English(ZA)"},
												{"Spanish(AR)"},
												{"Spanish(BO)"},
												{"Spanish(CL)"},
												{"Spanish(CO)"},
												{"Spanish(CR)"},
												{"Spanish(DO)"},
												{"Spanish(EC)"},
												{"Spanish(ES)"},
												{"Spanish(GT)"},
												{"Spanish(HN)"},
												{"Spanish(MX)"},
												{"Spanish(NI)"},
												{"Spanish(PA)"},
												{"Spanish(PE)"},
												{"Spanish(PR)"},
												{"Spanish(PY)"},
												{"Spanish(SV)"},
												{"Spanish(UY)"},
												{"Spanish(VE)"},
												{"Estonian"},
												{"Finnish"},
												{"French(BE)"},
												{"French(CA)"},
												{"French(CH)"},
												{"French(FR)"},
												{"French(LU)"},
												{"Croatian"},
												{"Hungarian"},
												{"Icelandic"},
												{"Italian(CH)"},
												{"Italian(IT)"},
												{"Hebrew"},
												{"Japanese"},
												{"Korean"},
												{"Lithuanian"},
												{"Latvian, Lettish"},
												{"Macedonian"},
												{"Dutch(BE)"},
												{"Dutch(NL)"},
												{"Norwegian(NO)"},
												{"Polish"},
												{"Portuguese(BR)"},
												{"Portuguese(PT)"},
												{"Romanian"},
												{"Russian"},
												{"Serbo-Croatian"},
												{"Slovak"},
												{"Slovenian"},
												{"Albanian"},
												{"Serbian"},
												{"Swedish"},
												{"Thai"},
												{"Turkish"},
												{"Ukrainian"},
												{"Chinese(CN)"},
												{"Chinese(HK)"},
												{"Chinese(TW)"}
    };
	protected static String[]  languages = {" ",
												"icbn",
												"icnb",
												"iczn",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"ar",
												"be",
												"bg",
												"ca",
												"cs",
												"da",
												"de",
												"de",
												"de",
												"de",
												"el",
												"en",
												"en",
												"en",
												"en",
												"en",
												"en",
												"en",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"es",
												"et",
												"fi",
												"fr",
												"fr",
												"fr",
												"fr",
												"fr",
												"hr",
												"hu",
												"is",
												"it",
												"it",
												"iw",
												"ja",
												"ko",
												"lt",
												"lv",
												"mk",
												"nl",
												"nl",
												"no",
												"pl",
												"pt",
												"pt",
												"ro",
												"ru",
												"sh",
												"sk",
												"sl",
												"sq",
												"sr",
												"sv",
												"th",
												"tr",
												"uk",
												"zh",
												"zh",
												"zh"
	};
	
	protected static String[]  countries = {"",
												"",
												"",
												"",
												"AE",
												"BH",
												"DZ",
												"EG",
												"IQ",
												"JO",
												"KW",
												"LB",
												"LY",
												"MA",
												"OM",
												"QA",
												"SA",
												"SD",
												"SY",
												"TN",
												"YE",
												"BY",
												"BG",
												"ES",
												"CZ",
												"DK",
												"AT",
												"CH",
												"DE",
												"LU",
												"GR",
												"AU",
												"CA",
												"GB",
												"IE",
												"NZ",
												"US",
												"ZA",
												"AR",
												"BO",
												"CL",
												"CO",
												"CR",
												"DO",
												"EC",
												"ES",
												"GT",
												"HN",
												"MX",
												"NI",
												"PA",
												"PE",
												"PR",
												"PY",
												"SV",
												"UY",
												"VE",
												"EE",
												"FI",
												"BE",
												"CA",
												"CH",
												"FR",
												"LU",
												"HR",
												"HU",
												"IS",
												"CH",
												"IT",
												"IL",
												"JP",
												"KR",
												"LT",
												"LV",
												"MK",
												"BE",
												"NL",
												"NO",
												"PL",
												"BR",
												"PT",
												"RO",
												"RU",
												"YU",
												"SK",
												"SL",
												"AL",
												"YU",
												"SE",
												"TH",
												"TR",
												"UA",
												"CN",
												"HK",
												"TW",
	};
	
	private static Hashtable localesHash;
	private static Hashtable languagesHash;
	private static Hashtable countriesHash;
	
    static {
	    localesHash = new Hashtable();
	    for(int i = 0; i < localeNames.length; i++) {
		localesHash.put(languages[i] + countries[i], localeNames[i][0]);
	    }
	    
	    languagesHash = new Hashtable();
	    for(int i = 0; i < localeNames.length; i++) {
		languagesHash.put(localeNames[i][0], languages[i]);
	    }
	    
	    countriesHash = new Hashtable();
	    for(int i = 0; i < localeNames.length; i++) {
		countriesHash.put(localeNames[i][0], countries[i]);
	    }
    }
    
    protected static TextListModel codes = new DefaultTextListModel();
    protected static TextListModel locales = new DefaultTextListModel();

    static {
	codes.replaceItems(0, 0, codeNames);
	locales.replaceItems(0, 0, localeNames);
    }

    private LocaleListModel()
    {
    }

    public static TextListModel getCodes()
    {
	return codes;
    }

    public static TextListModel getLocales()
    {
	return locales;
    }

    public static String[][] getCodeNames()
    {
	return codeNames;
    }

    public static String[][] getLocaleNames()
    {
	return localeNames;
    }

    public static String getLanguage(int index) {		
	return languages[index];
    }
    
    public static String getCountry(int index) {
	return countries[index];
    }
    
    public static String getLocaleName(String localeID) {
	return (String)localesHash.get(localeID);
    }
    
    public static String getLanguage(String localeName) {
	return (String)languagesHash.get(localeName);
    }
    
    public static String getCountry(String localeName) {
	return (String)countriesHash.get(localeName);
    }
    
    public void update(Observable obs, Object arg)
    {
	locales.replaceItems(0, locales.getItemCount() - 1, localeNames);	
    }
}

