/*
 * NameTreeModel.java:  a TreeNode holding NamedObjectEditModel
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameTreeModel.java,v 1.8 2002/09/01 10:53:01 nozomi Exp $
 * $Log: NameTreeModel.java,v $
 * Revision 1.8  2002/09/01 10:53:01  nozomi
 * add getPublicationName()
 *
 * Revision 1.7  2002/08/30 03:14:13  nozomi
 * change definition of get/setName and get/setViewName
 *
 * Revision 1.6  2002/08/29 19:46:39  nozomi
 * implements interface Nameable
 *
 * Revision 1.5  2002/08/27 03:15:51  nozomi
 * support getViewName() methods
 *
 * Revision 1.4  2002/08/23 08:17:55  nozomi
 * support getViewString() method
 *
 * Revision 1.3  2002/06/09 12:44:05  nozomi
 * change TreeModelEvent handling
 *
 * Revision 1.2  2002/04/16 03:53:38  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.1  2002/03/07 10:24:02  nozomi
 * initial import
 *
 */

package org.nomencurator.editor.model;

import jp.kyasu.graphics.RichTextStyle;

import org.nomencurator.Nameable;

import org.nomencurator.util.tree.TreeModel;

import org.nomencurator.awt.tree.DefaultTreeModel;

/**
 * The model interface for an object that acts as a named object edit model
 *
 * @version 	01 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameTreeModel
    extends TextTreeModel
    implements Nameable
{
    protected String viewName;

    //Constructors
    /**
     * Constructs a tree 
     *
     */
    public NameTreeModel(NameUsageEditModel editModel)
    {
	this(new NameUsageNode(editModel));
    }

    /**
     * Constructs a tree of which any node may have child node.
     *
     * @param root TreeNode object to be root of the tree.
     *
     * @see DefaultTreeModel(TreeNode, boolean)
     */
    
    public NameTreeModel(NameUsageNode root)
    {
	this(root, false);
    }

    /**
     * Constructs a tree under the root <code>node</code>
     * specifying whether any node may have children nodes
     * or only specified node may have children nodes. 
     * 
     * @param node root node of the tree
     * @param allowance false if any child node may have 
     * child node, or true if only specified node may have children.
     *
     * @see #asksAllowsChildren
     */

    public NameTreeModel(NameUsageNode node,
		     boolean allowance)
    {
	this(new DefaultTreeModel(node, allowance));
    }
    

    /**
     * Constructs a tree under the root <code>node</code>
     * specifying whether any node may have children nodes
     * or only specified node may have children nodes. 
     * 
     * @param node root node of the tree
     * @param allowance false if any child node may have 
     * child node, or true if only specified node may have children.
     *
     * @see #asksAllowsChildren
     */

    public NameTreeModel(TreeModel model)
    {
	this(model, RichTextStyle.DEFAULT_LIST_STYLE);
    }
    
    /**
     * Constructs a single column text list model with the specified rich text
     * style.
     *
     * @param root TreeNode object to be root of the tree.
     * @param richTextStyle the rich text style.
     */
    public NameTreeModel(TreeModel model,
			 RichTextStyle ritchTextStyle)
    {
	super(model, ritchTextStyle);
    }
    
    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public NameTreeModel(TreeModel model,
			 int columnWidths[])
    {
	this(model, columnWidths.length, columnWidths);
    }

    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public NameTreeModel(TreeModel model,
			 int columnWidths[],
			 RichTextStyle richTextStyle)
    {
	this(model, columnWidths.length, columnWidths, richTextStyle);
    }

    /**
     * Constructs a text list model with the specified number of columns
     * and column widths.
     *
     * @param columns   the number of columns.
     * @param colWidths the column widths.
     */
    public NameTreeModel(TreeModel model,
			 int columns,
			 int colWidths[])
    {
	this(model, columns, colWidths, RichTextStyle.DEFAULT_LIST_STYLE);
    }

    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public NameTreeModel(TreeModel model,
			 int columns, 
			 int colWidths[],
			 RichTextStyle richTextStyle)
    {
	super(model, columns, colWidths, richTextStyle);
    }

    public String getViewName()
    {
	if(viewName == null ||
	   viewName.length() == 0)
	    return getViewName(false);
	else
	    return viewName;
    }

    public String getViewName(boolean toSort)
    {
	return ((NameUsageNode)getRoot()).getNameUsageEditModel().getViewName(toSort);
    }

    /**
     * Gives a name as a <CODE>String</CODE>
     *
     * @param String representing a name
     */
    public void setViewName(String name)
    {
	viewName = name;
    }

    /**
     * Gets name in <CODE>String</CODE>
     *
     * @return String representing a name
     */
    public String getName()
    {
	return ((NameUsageNode)getRoot()).getName();
    }

    /**
     * Gives a name as a <CODE>String</CODE>
     *
     * @param String representing a name
     */
    public void setName(String name)
    {
    }

    public String getPublicationName()
    {
	return ((NameUsageNode)getRoot()).getNameUsageEditModel().getAppearanceEditModel().getPublicationEditModel().getName();
    }
}


