/*
 * NameUsageListModel.java:  a TextListModel containing NameUsages' summary
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * $Id: NameUsageListModel.java,v 1.16 2002/09/17 08:26:15 nozomi Exp $
 * $Log: NameUsageListModel.java,v $
 * Revision 1.16  2002/09/17 08:26:15  nozomi
 * implement getModels()
 *
 * Revision 1.15  2002/06/03 00:14:20  nozomi
 * returns empty NameUsageEditModel as dummy model
 *
 * Revision 1.14  2002/05/26 21:16:25  nozomi
 * show scrollbar of name list always
 *
 * Revision 1.13  2002/05/26 21:06:25  nozomi
 * automatic dummy addition support
 *
 * Revision 1.12  2002/05/21 03:35:29  nozomi
 * emptyText changed to EMPTY_TEXT
 *
 * Revision 1.11  2002/05/16 22:18:16  nozomi
 * fix exceeding comma in emptyNameUsageSummary
 *
 * Revision 1.10  2002/05/16 20:30:31  nozomi
 * extends NamedObjectListModel, instead of DefaultTextListModel
 *
 * Revision 1.9  2002/03/10 09:55:53  nozomi
 * design change
 *
 * Revision 1.8  2002/02/28 17:11:22  nozomi
 * use DefaultTextListModel of the package
 *
 * Revision 1.7  2002/02/27 23:59:15  nozomi
 * extends DefaultTextListModel in the package
 *
 * Revision 1.6  2002/02/16 15:57:19  nozomi
 * Implements TableModel again
 *
 * Revision 1.5  2002/02/13 19:39:58  nozomi
 * Abandon to use TableModel interface
 *
 * Revision 1.4  2002/02/08 01:09:49  nozomi
 * Implements TableModel
 *
 * Revision 1.3  2002/02/07 21:00:21  nozomi
 * add static block
 *
 * Revision 1.2  2002/02/01 22:14:58  nozomi
 * minor change in a comment
 *
 * Revision 1.1  2002/01/28 05:48:53  nozomi
 * initial import into CVS
 *
 */


package org.nomencurator.editor.model;

import java.util.Vector;

import jp.kyasu.awt.TableList;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextList;
import jp.kyasu.graphics.RichTextStyle;

import org.nomencurator.NamedObject;
import org.nomencurator.NameUsage;

/**
 * The model representing list of <code>NameUsage</code>s' summary
 *
 * @version 	17 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameUsageListModel
    extends NamedObjectListModel
    implements TableModel
{
    protected static String[] defaultTitle = {
	"rank", "name", "authority", "year"
    };

    protected static int[] defaultColumnWidths =
 	TableList.columnWidths(defaultTitle);

    protected static int[] defaultAlignments = {
	CENTER, CENTER, CENTER, CENTER  
    };

    private static final Text[][] emptyNameUsageSummary = 
	new Text[][]{{EMPTY_TEXT, EMPTY_TEXT, EMPTY_TEXT, EMPTY_TEXT}};

    protected static final NameUsageEditModel dummyModel = new NameUsageEditModel();

    static {
	defaultColumnWidths[0] *= 3;
	defaultColumnWidths[0] /= 2;
	defaultColumnWidths[1] *= 3;
	defaultColumnWidths[2] *= 3;
	defaultColumnWidths[2] /= 2;
	defaultColumnWidths[3] *= 6;
	defaultColumnWidths[3] /= 5;
    }

    /**
     * Returns title of <code>NameUsageListModel</code>
     *
     */
    public String[] getTitle()
    {
	return getDefaultTitle();
    }

    /**
     * Sets <code>title</code> as title of <code>NameUsageListModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public void setTitle(String[] title)
    {
	setDefaultTitle(title);
    }
    
    /**
     * Returns title of <code>NameUsageListModel</code>
     *
     */
    public static String[] getDefaultTitle()
    {
	return defaultTitle;
    }

    /**
     * Sets <code>title</code> as title of <code>NameUsageListModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public static void setDefaultTitle(String[] title)
    {
	if(defaultTitle == title)
	    return;

	defaultTitle = title;
	defaultColumnWidths = TableList.columnWidths(defaultTitle);
    }
    
    /**
     * Returns alignments of title
     *
     */
    public int[] getAlignments()
    {
	return getDefaultAlignments();
    }

    /**
     * Sets <code>alighnemnts</code> as title alignment
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public void setAlignments(int[] alignments)
    {
	setDefaultAlignments(alignments);
    }

    /**
     * Returns alignments of title
     *
     */
    public static int[] getDefaultAlignments()
    {
	return defaultAlignments;
    }

    /**
     * Sets <code>alighnemnts</code> as title alignment of <code>TextListModel</code> implementing this interface
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public static void setDefaultAlignments(int[] alignments)
    {
	defaultAlignments = alignments;
    }

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public NameUsageListModel()
    {
	this(true);
    }

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public NameUsageListModel(boolean enable)
    {
	this(RichTextStyle.DEFAULT_LIST_STYLE, enable);
    }

    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public NameUsageListModel(RichTextStyle richTextStyle, boolean enable)
    {
	this(defaultColumnWidths.length, defaultColumnWidths, richTextStyle, enable);
    }


    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public NameUsageListModel(int colWidths[])
    {
	this(colWidths.length, colWidths);
    }

    /**
     * Constructs a text list model with the specified number of columns
     * and column widths.
     *
     * @param columns   the number of columns.
     * @param colWidths the column widths.
     */
    public NameUsageListModel(int columns, int colWidths[])
    {
	this(columns, colWidths, RichTextStyle.DEFAULT_LIST_STYLE);
    }

    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public NameUsageListModel(int columns, int colWidths[],
				RichTextStyle richTextStyle)
    {
	super(columns, colWidths, richTextStyle, false);
    }

    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public NameUsageListModel(int columns, int colWidths[],
			      RichTextStyle richTextStyle,
			      boolean enable)
    {
	super(columns, colWidths, richTextStyle, enable);
    }

    /**
     * Constructs a text list model with the specified <code>textList</code>
     *
     * @param textList      <code>TextList</code> to be used by this object
     */
    public NameUsageListModel(TextList textList)
    {
	super(textList);
    }


    /**
     * Returns Text array representing empty summary 
     * can be used to represent a dummy <code>NamedObjectEditModel</code>.
     *
     * @return Text[][] representing a summary of an empty <code>NamedObjectEditModel</code>.
     */
    public Text[][] getEmptySummary()
    {
	return emptyNameUsageSummary;
    }

    /**
     * Returns a dummy <code>NamedObjectEditModel</code> instance for double-clicking
     * operation.
     *
     * @return null to be considered as a dummy <code>NamedObjectEditModel</code>
     */
    public NamedObjectEditModel getDummyModel()
    {
	return dummyModel;
    }

    /**
     * Creates and returns an instance of <CODE>NamedObjectEditModel</CODE>
     * representing <CODE>object</CODE>.
     * The subclass must provide this method creating its an instance.
     *
     * @param namedObjects <CODE>Vector</CODE> containing <CODE>NamedObject</CODE>s
     * to be represented by <CODE>NamedObjectEditModel</CODE>s
     *
     * @return NamedObjectEditModel representing <CODE>object</CODE>
     */
    protected Vector getModels(Vector namedObjects)
    {
	return getModels(namedObjects, NameUsageEditModel.getInstance());
    }
}
