/*
 * NameUsageNode.java:  a TreeNode holding NameUsageEditModel
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameUsageNode.java,v 1.15 2002/09/20 13:14:14 nozomi Exp $
 * $Log: NameUsageNode.java,v $
 * Revision 1.15  2002/09/20 13:14:14  nozomi
 * restrict index range of child nodes
 *
 * Revision 1.14  2002/09/01 10:54:06  nozomi
 * change method name from set/setName to set/getUsedName
 *
 * Revision 1.13  2002/08/28 00:30:15  nozomi
 * support NameUsageNode(NameUsage) constructor
 *
 * Revision 1.12  2002/08/27 03:16:21  nozomi
 * suppot getName() method
 *
 * Revision 1.11  2002/08/09 05:27:04  nozomi
 * fix duplicate insertion bug
 *
 * Revision 1.10  2002/06/09 12:45:40  nozomi
 * change TreeModelEvent handling
 *
 * Revision 1.8  2002/06/03 01:38:43  nozomi
 * fix node insertion/deletion bug
 *
 * Revision 1.7  2002/04/16 00:42:17  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.6  2002/03/10 08:55:17  nozomi
 * fix multiple insertion bug
 *
 * Revision 1.5  2002/03/10 06:56:45  nozomi
 * add update method to NameUsageNode
 *
 * Revision 1.4  2002/03/09 23:38:00  nozomi
 * removed unnecessary update()
 *
 * Revision 1.3  2002/03/08 23:07:47  nozomi
 * add event handling
 *
 * Revision 1.2  2002/03/07 10:24:30  nozomi
 * make concrete class
 *
 * Revision 1.1  2002/03/07 10:03:45  nozomi
 * initial import
 */


package org.nomencurator.editor.model;

import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;

import jp.kyasu.awt.event.ListModelEvent;
import jp.kyasu.awt.event.ListModelListener;

import org.nomencurator.NameUsage;

import org.nomencurator.awt.tree.DefaultMutableTreeNode;

import org.nomencurator.util.tree.TreePath;
import org.nomencurator.util.tree.MutableTreeNode;

import org.nomencurator.util.tree.event.TreeModelEvent;

/**
 * <code>TreeNode</code> wrapping a <code>NameUsageEditModel</code>
 *
 * @version 	20 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameUsageNode
    extends NamedObjectNode
    implements ListModelListener
{
    /**
     * Create a tree node without parent nor child
     * but initialise it with the given object
     */
    public NameUsageNode()
    {
	this(new NameUsageEditModel());
    }

    /**
     * Create a tree node without parent nor child
     * but initialise it with the given object
     */
    public NameUsageNode(NameUsage nameUsage)
    {
	this(new NameUsageEditModel(nameUsage));
    }

    /**
     * Create a tree node without parent nor child
     * but initialise it with the given object
     */
    public NameUsageNode(NameUsageEditModel userObject)
    {
	this(userObject, true);
    }

    /**
     * Create a tree node without parent nor child
     * but initialise it with the given object and
     * given allowance
     * 
     */
    public NameUsageNode(NameUsageEditModel userObject, boolean allowsChildren)
    {
	super(userObject, allowsChildren);
	//	userObject.getLower().addListModelListener(this);
    }

    /**
     * Sets usersObject of this node to <code>object</code>
     *
     * @param object a Object specified by user for this node
     *
     * @see #getUserObject()
     * @see #toString()
     *
     */
    public NameUsageEditModel getNameUsageEditModel()
    {
	return (NameUsageEditModel)getEditModel();
    }

    /**
     * Sets usersObject of this node to <code>object</code>
     *
     * @param object a Object specified by user for this node
     *
     * @see #getUserObject()
     * @see #toString()
     *
     */
    public void setEditModel(NameUsageEditModel object)
    {
	NameUsageEditModel currentModel = 
	    getNameUsageEditModel();
	if(currentModel == object)
	    return;
	
	/*
	if(currentModel != null)
	    currentModel.getLower().removeListModelListener(this);
	*/
	super.setEditModel(object);
	/*
	object.getLower().addListModelListener(this);
	*/
    }

    public String getName()
    {
	return getNameUsageEditModel().getName();
    }

    public String getUsedName()
    {
	return getNameUsageEditModel().getUsedName();
    }

    public void listModelChanged(ListModelEvent event)
    {
	if(event.getID() != ListModelEvent.LIST_MODEL_REPLACED)
	    return;
	int begin = event.getReplaceBegin();
	int end = event.getReplaceEnd();
	int count = event.getItemCountChanged();
	NameUsageListModel lower = getNameUsageEditModel().getLower();
	if(count > 0) {
	    insert(new NameUsageNode((NameUsageEditModel)lower.getModel(begin)), begin);
	}
	else if(count < 0) {
	    remove(begin);
	}
	else { //count == 0
	}
    }

    public synchronized void update(Observable obs, Object arg)
    {
	if(obs != userObject)
	    return;

	if(arg == getNameUsageEditModel().getLower().getDummyModel())
	    return;
	
	if(arg != null) {
	    NameUsageEditModel model = getNameUsageEditModel().getHigherModel();
	    if(arg ==  model) {
		boolean previousExtended = isExpanded();
		NameUsageNode higher = (NameUsageNode)getParent();
		if(higher == null ||
		   higher.getEditModel() != model) {
		    NameUsageNode newParent = new NameUsageNode(model);
		    newParent.add(this);
		}
		return;
	    }
	    else if(arg instanceof NameUsageEditModel) {
		model = (NameUsageEditModel)arg;
		if(containsUserObject(arg)) {
		    if(model != model.getLower().getDummyModel())
			super.update(obs, arg);
		    return;
		}
		int index = getNameUsageEditModel().indexOf(model);
		if(index < 0) {
		    index = indexOf(model);
		    if(index > -1 && index < children.size())
			remove(indexOf(model));
		}
		else {
		    boolean isChild = false;
		    if(children != null &&
		       !children.isEmpty()) {
			Enumeration childNodes = children.elements();
			while(childNodes.hasMoreElements() && !isChild) {
			    NameUsageNode child = (NameUsageNode)(childNodes.nextElement());
			    if(child.getEditModel() == model) {
				isChild = true;
				break;
			    }
			}
		    }
		    if(!isChild)
			insert(new NameUsageNode(model), index);
		}

		return;
	    }
	}

	super.update(obs, arg);
	/*
	NamedObjectNode parentNode = (NamedObjectNode)getParent();
	if(parentNode == null) {
	    fireTreeNodesChanged(new Object[]{this}, null, null);
	    return;
	}

	if(getChildCount() == 0) {
	    super.update(obs, arg);
	    return;
	}

	int[] indices = new int[1];
	indices[0] = parentNode.indexOf(this);
	((MutableTreeNode)getRoot()).fireTreeNodesChanged(getPath(),
	//				    new Object[]{parentNode},
					    indices,
					    new Object[]{this}
					    
	    );
	*/
    }

}
