/*
 * NamedObjectNode.java:  a TreeNode holding NamedObjectEditModel
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NamedObjectNode.java,v 1.11 2002/08/29 19:46:39 nozomi Exp $
 * $Log: NamedObjectNode.java,v $
 * Revision 1.11  2002/08/29 19:46:39  nozomi
 * implements interface Nameable
 *
 * Revision 1.10  2002/08/29 19:02:08  nozomi
 * add String peristentID() method
 *
 * Revision 1.9  2002/06/25 10:31:25  t.okada
 * indexOf() method update
 *
 * Revision 1.8  2002/06/09 12:46:21  nozomi
 * change TreeModelEvent handling
 *
 * Revision 1.7  2002/06/03 01:37:04  nozomi
 * add contains(), containsUserObject(), indexOf()
 *
 * Revision 1.6  2002/04/08 02:05:38  nozomi
 * minor edtition in source code style
 *
 * Revision 1.5  2002/03/10 08:55:17  nozomi
 * fix multiple insertion bug
 *
 * Revision 1.4  2002/03/10 06:56:45  nozomi
 * add update method to NameRecordNode
 *
 * Revision 1.3  2002/03/09 23:38:07  nozomi
 * implement update()
 *
 * Revision 1.2  2002/03/08 23:05:42  nozomi
 * implements Observer
 *
 * Revision 1.1  2002/03/07 01:50:25  nozomi
 * Tree implementation for edit models
 *
 */


package org.nomencurator.editor.model;

import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;

import jp.kyasu.graphics.Text;

import org.nomencurator.Nameable;

import org.nomencurator.awt.tree.DefaultMutableTreeNode;

import org.nomencurator.util.tree.MutableTreeNode;

import org.nomencurator.util.tree.event.TreeModelEvent;

/**
 * <code>TreeNode</code> wrapping a <code>NamedObjectEditModel</code>
 *
 * @version 	29 Aug 2002
 * @author 	Nozomi `James' Ytow
 */
public abstract class NamedObjectNode
    extends DefaultMutableTreeNode
    implements Nameable, Observer
{
    /**
     * Create a tree node without parent nor child
     * but initialise it with the given object
     */
    public NamedObjectNode(NamedObjectEditModel userObject)
    {
	this(userObject, true);
    }

    /**
     * Create a tree node without parent nor child
     * but initialise it with the given object and
     * given allowance
     * 
     */
    public NamedObjectNode(NamedObjectEditModel userObject, boolean allowsChildren)
    {
	super(userObject, allowsChildren);
	userObject.addObserver(this);
    }

    /**
     * Sets usersObject of this node to <code>object</code>
     *
     * @param object a Object specified by user for this node
     *
     * @see #getUserObject()
     * @see #toString()
     *
     */
    public void setUserObject(Object object)
    {
    }

    /**
     * Returns user specified object to this node
     *
     * @return user specified object to this node
     *
     * @see #setUserObject(java.lang.Object)
     * @see #toString()
     *
     */
    public Object getUserObject()
    {
	return getEditModel().getSummaryText();
    }

    /**
     * Sets usersObject of this node to <code>object</code>
     *
     * @param object a Object specified by user for this node
     *
     * @see #getUserObject()
     * @see #toString()
     *
     */
    public void setEditModel(NamedObjectEditModel object)
    {
	NamedObjectEditModel currentModel = getEditModel();
	if(currentModel == object)
	    return;
	if(currentModel != null)
	    currentModel.deleteObserver(this);
	super.setUserObject(object);
	object.addObserver(this);
    }

    /**
     * Returns user specified object to this node
     *
     * @return user specified object to this node
     *
     * @see #setUserObject(java.lang.Object)
     * @see #toString()
     *
     */
    public NamedObjectEditModel getEditModel()
    {
	return (NamedObjectEditModel)super.getUserObject();
    }

    public void update(Observable obs, Object arg)
    {
	if(obs != userObject) {
	    return;
	}
	((MutableTreeNode)getRoot()).fireTreeNodesChanged(getPath(), null, null);
    }

    /**
     * Returns true if <code>node</code> is one of child node
     *
     * @param node <code>Object</code> to be test whether it is contained
     * as a child node
     *
     * @return ture if <code>node</code> is one of child node
     */
    public boolean contains(Object node)
    {
	if(children != null &&
	   children.contains(node))
	    return true;

	return false;
    }

    /**
     * Returns true if <code>object</code> is the user object of
     * one of child node
     *
     * @param object <code>Object</code> to be test whether it is contained
     * as the user object of a child node
     *
     * @return ture if <code>object</code> is contained
     */
    public boolean containsUserObject(Object object)
    {
	if(children != null) {
	    Enumeration e = children.elements();
	    while(e.hasMoreElements()) {
		if(object == ((DefaultMutableTreeNode)e.nextElement()).getUserObject())
		    return true;
	    }
	}

	return false;
    }

    /**
     * Returns index of <CODE>node</CODE>, of -1
     * if it is not a child node of this <CODE>TreeNode</CODE>
     *
     * @param node <CODE>MutableTreeNode</CODE> to be examined
     *
     * @return int representing index of <CODE>node</CODE> or
     * -1 if it is not a child node of this 
     */
    public int indexOf(MutableTreeNode node)
    {
	if(children == null)
	    return -1;

	return children.indexOf(node);
    }

    /**
     * Returns index of <CODE>node</CODE>, of -1
     * if it is not contained in this <CODE>TreeNode</CODE>
     *
     * @param node <CODE>Object</CODE> to be examined
     *
     * @return int representing index of <CODE>node</CODE> or
     * -1 if it is not contained in this
     */
    public int indexOf(Object node)
    {

	if(node instanceof MutableTreeNode) {
	    int asNode = indexOf((MutableTreeNode) node);
	    if(asNode != -1)
		return asNode;
	}

	if(children != null) {
	    int index = 0;
	    Enumeration e = children.elements();
	    while(e.hasMoreElements()) {
	    	NamedObjectNode noNode = (NamedObjectNode)e.nextElement();
	    	Object obj = noNode.getEditModel();
		if(node == obj)
		    return index;
		index++;
	    }
	}
	
	return -1;
    }

    /**
     * Returns peristent ID of wrapped <CODE>NamedObject</CODE> as its name,
     * or result of toString() if no <CODE>NamedObject</CODE> is wrapped
     *
     * @return String rpresenting peristent ID of wrapped <CODE>NamedObject</CODE>
     */
    public String getName()
    {
	NamedObjectEditModel model = getEditModel();
	if(model == null)
	    return toString();
	return model.getName();
    }

    /**
     * Gives a name as a <CODE>String</CODE>
     *
     * @param String representing a name
     */
    public void setName(String name) { }
}
