/*
 * PublicationListModel.java:  a TextListModel containing Publications' summary
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * $Id: PublicationListModel.java,v 1.9 2002/10/17 04:17:03 nozomi Exp $
 * $Log: PublicationListModel.java,v $
 * Revision 1.9  2002/10/17 04:17:03  nozomi
 * implement own getDummyModel()
 *
 * Revision 1.8  2002/09/17 08:26:15  nozomi
 * implement getModels()
 *
 * Revision 1.7  2002/05/21 03:38:46  nozomi
 * emptyText changed to EMPTY_TEXT
 *
 * Revision 1.6  2002/05/16 22:14:37  nozomi
 * extends NamedObjectListModel, instead of DefaultTextListModel
 *
 * Revision 1.5  2002/04/15 00:04:22  nozomi
 * fix minor mistake in the comment
 *
 * Revision 1.4  2002/02/28 17:11:22  nozomi
 * use DefaultTextListModel of the package
 *
 * Revision 1.3  2002/02/27 23:59:15  nozomi
 * extends DefaultTextListModel in the package
 *
 * Revision 1.2  2002/02/24 20:04:16  nozomi
 * modify width of a clumn
 *
 * Revision 1.1  2002/02/18 23:06:51  nozomi
 * initial import to CVS
 *
 */


package org.nomencurator.editor.model;

import java.util.Vector;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextList;
import jp.kyasu.graphics.RichTextStyle;

import org.nomencurator.editor.TableList;

/**
 * The model representing list of <code>Publication</code>s' summary
 *
 * @see 	jp.kyasu.awt.DefaultTextListModel
 * @see 	org.nomencurator.editor.model.TableModel
 *
 * @version 	17 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class PublicationListModel
    extends NamedObjectListModel
    implements TableModel
{
    protected static String[] defaultTitle = {
	"author", "year", "citation detail"
    };

    protected static int[] defaultColumnWidths =
 	TableList.columnWidths(defaultTitle);

    protected static int[] defaultAlignments = {
	CENTER, CENTER, LEFT
    };


    private static final Text[][] emptyPublicationSummary = 
	new Text[][]{{EMPTY_TEXT, EMPTY_TEXT, EMPTY_TEXT}};


    static {
	defaultColumnWidths[0] *= 2;
	//	defaultColumnWidths[2] *= 3;
    }

    protected static final PublicationEditModel dummyModel = new PublicationEditModel();

    /**
     * Returns title of <code>PublicationListModel</code>
     *
     */
    public String[] getTitle()
    {
	return getDefaultTitle();
    }

    /**
     * Sets <code>title</code> as title of <code>PublicationListModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public void setTitle(String[] title)
    {
	setDefaultTitle(title);
    }
    
    /**
     * Returns title of <code>PublicationListModel</code>
     *
     */
    public static String[] getDefaultTitle()
    {
	return defaultTitle;
    }

    /**
     * Sets <code>title</code> as title of <code>PublicationListModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public static void setDefaultTitle(String[] title)
    {
	if(defaultTitle == title)
	    return;

	defaultTitle = title;
	defaultColumnWidths = TableList.columnWidths(defaultTitle);
    }
    
    /**
     * Returns alignments of title
     *
     */
    public int[] getAlignments()
    {
	return getDefaultAlignments();
    }

    /**
     * Sets <code>alighnemnts</code> as title alignment
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public void setAlignments(int[] alignments)
    {
	setDefaultAlignments(alignments);
    }

    /**
     * Returns alignments of title
     *
     */
    public static int[] getDefaultAlignments()
    {
	return defaultAlignments;
    }

    /**
     * Sets <code>alighnemnts</code> as title alignment of <code>TextListModel</code> implementing this interface
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public static void setDefaultAlignments(int[] alignments)
    {
	defaultAlignments = alignments;
    }

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public PublicationListModel()
    {
	this(false);
    }

    /**
     * Constructs a one column text list model with the default rich text
     * style.
     */
    public PublicationListModel(boolean enable)
    {
	this(RichTextStyle.DEFAULT_LIST_STYLE, enable);
    }

    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public PublicationListModel(RichTextStyle richTextStyle)
    {
	this(richTextStyle, false);
    }
    /**
     * Constructs a one column text list model with the specified rich text
     * style.
     *
     * @param richTextStyle the rich text style.
     */
    public PublicationListModel(RichTextStyle richTextStyle, boolean enable)
    {
	this(defaultColumnWidths.length, defaultColumnWidths, richTextStyle, enable);
    }


    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public PublicationListModel(int colWidths[])
    {
	this(colWidths.length, colWidths);
    }

    /**
     * Constructs a text list model with the specified number of columns
     * and column widths.
     *
     * @param columns   the number of columns.
     * @param colWidths the column widths.
     */
    public PublicationListModel(int columns, int colWidths[])
    {
	this(columns, colWidths, RichTextStyle.DEFAULT_LIST_STYLE);
    }

    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public PublicationListModel(int columns, int colWidths[],
				RichTextStyle richTextStyle)
    {
	this(columns, colWidths, richTextStyle, false);
    }
    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public PublicationListModel(int columns, int colWidths[],
				RichTextStyle richTextStyle,
				boolean enable)
    {
	super(columns, colWidths, richTextStyle, enable);
    }

    /**
     * Constructs a text list model with the specified <code>textList</code>
     *
     * @param textList      <code>TextList</code> to be used by this object
     */
    public PublicationListModel(TextList textList)
    {
	super(textList);
    }

    /**
     * Returns Text array representing empty summary 
     * can be used to represent a dummy <code>NamedObjectEditModel</code>.
     *
     * @return Text[][] representing a summary of an empty <code>NamedObjectEditModel</code>.
     */
    public Text[][] getEmptySummary()
    {
	return emptyPublicationSummary;
    }

    /**
     * Returns a dummy <code>NamedObjectEditModel</code> instance for double-clicking
     * operation.
     *
     * @return null to be considered as a dummy <code>NamedObjectEditModel</code>
     */
    public NamedObjectEditModel getDummyModel()
    {
	return dummyModel;
    }

    /**
     * Creates and returns an instance of <CODE>NamedObjectEditModel</CODE>
     * representing <CODE>object</CODE>.
     * The subclass must provide this method creating its an instance.
     *
     * @param namedObjects <CODE>Vector</CODE> containing <CODE>NamedObject</CODE>s
     * to be represented by <CODE>NamedObjectEditModel</CODE>s
     *
     * @return NamedObjectEditModel representing <CODE>object</CODE>
     */
    protected Vector getModels(Vector namedObjects)
    {
	return getModels(namedObjects, PublicationEditModel.getInstance());
    }

}
