/*
 * TableModel.java:  an extension of TextListModel to be used by TableList
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * $Id: TableModel.java,v 1.4 2002/02/28 17:11:02 nozomi Exp $
 * $Log: TableModel.java,v $
 * Revision 1.4  2002/02/28 17:11:02  nozomi
 * use TextListModel of the package
 *
 * Revision 1.3  2002/02/16 15:56:35  nozomi
 * Reimplementation as subinterface of TextListModel
 *
 */

package org.nomencurator.editor.model;

import jp.kyasu.awt.Label;

/**
 * Adds title and alighent interfaces to TextListModel
 *
 * @see 	jp.kyasu.awt.TextListModel
 *
 * @version 	28 Feb 2002
 * @author 	Nozomi `James' Ytow
 */
public interface TableModel
    extends TextListModel
{
    /**
     * Aligns title <code>String</code> to right
     *
     * @see 	jp.kyasu.awt.Lable.RIGHT
     */ 
    public static int RIGHT  = Label.RIGHT;

    /**
     * Aligns title <code>String</code> to center
     *
     * @see 	jp.kyasu.awt.Lable.CENTER
     */ 
    public static int CENTER = Label.CENTER;

    /**
     * Aligns title <code>String</code> to left
     *
     * @see 	jp.kyasu.awt.Lable.LEFT
     */ 
    public static int LEFT   = Label.LEFT;

    /**
     * Returns title of <code>TableModel</code>
     *
     */
    public String[] getTitle();

    /**
     * Sets <code>title</code> as title of <code>TableModel</code>
     *
     * @param title array of <code>String</code> contains title to be used
     */
    public void setTitle(String[] title);
    
    /**
     * Returns alignments of title
     *
     */
    public int[] getAlignments();

    /**
     * Sets <code>alighnemnts</code> as title alignment of <code>TextListModel</code> implementing this interface
     *
     * @param alignments array of <code>int</code> specifys alignment to apply
     */
    public void setAlignments(int[] alignments);

}
