/*
 * TextListModel.java:  an extension of jp.kyasu.awt.TextListModel
 * to be used by TableList of TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
/*
 * $Id: TextListModel.java,v 1.5 2002/09/17 08:29:56 nozomi Exp $
 * $Log: TextListModel.java,v $
 * Revision 1.5  2002/09/17 08:29:56  nozomi
 * add/removeModel() methods return boolean; add removeAll()
 *
 * Revision 1.4  2002/05/14 10:16:08  ryo
 * add addModel() and update()
 *
 * Revision 1.3  2002/02/28 17:13:04  nozomi
 * add getModel(int)
 *
 * Revision 1.2  2002/02/28 03:19:24  nozomi
 * add update() methods
 *
 * Revision 1.1  2002/02/27 23:43:17  nozomi
 * initial import to CVS
 *
 */

package org.nomencurator.editor.model;

import java.util.Vector;

/**
 * Extention of <code>jp.kyasu.awt.TextListModel</code>
 * supporting <code>NamedObjectEditModel</code> selection
 *
 * @see 	jp.kyasu.awt.TextListModel
 *
 * @version 	17 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public interface TextListModel
    extends jp.kyasu.awt.TextListModel
{
    /**
     * Returns <code>Vector</code> of <code>NamedObjectEditModel</code>
     * accompanying to the <code>ListModel</code>
     */
    public Vector getModels();

    /**
     * Sets <code>models</code> as <code>NamedObjectEditModel</code> list
     * accompanying to the <code>ListModel</code>
     */
    public void setModels(Vector models);

    /**
     * Adds <code>model</code> to <code>NamedObjectEditModel</code> list
     *
     * @param model <code>NamedObjectEditModel</code> to be added to this selector
     */
    public boolean addModel(NamedObjectEditModel model);

    /**
     * Inserts <code>model</code> at <code>index</code> of <code>NamedObjectEditModel</code> list.
     *
     * @param index  where <code>model</code> to be added
     * @param model <code>NamedObjectEditModel</code> to be added
     */
    public boolean addModel(int index, NamedObjectEditModel model);

    /**
     * Inserts <code>model</code> at <code>index</code> of <code>NamedObjectEditModel</code> list.
     *
     * @param index  where <code>model</code> to be added
     * @param model <CODE>NamedObjectEditModel</CODE> to be added
     * @param items an array of <CODE>Object</CODE>s representing contents of the <CODE>model</CODE>
     */
    public boolean addModel(int index, NamedObjectEditModel model, Object[][] items);

    /**
     * Removes <code>model</code> from <code>NamedObjectEditModel</code> list
     *
     * @param model <code>NamedObjectEditModel</code> to be removed from this selector
     */
    public boolean removeModel(NamedObjectEditModel model);

    /**
     * Remove all <code>NamedObjectEditModel</code>s from <code>NamedObjectEditModel</code> list
     *
     */
    public void removeAllModels();

    /**
     * Returns <code>NamedObjectEditModel</code> at <code>index</code>
     *
     * @param index  where <code>model</code> is
     * @return <code>NamedObjectEditModel</code> at  <code>index</code>
     */
    public NamedObjectEditModel getModel(int index);

    /**
     * Returns selected <code>NamedObjectEditModel</code>
     *
     * @return <code>NamedObjectEditModel</code> selected
     */
    public NamedObjectEditModel getSelectedModel();

    /**
     * Returns selected <code>NamedObjectEditModel</code>
     *
     * @return <code>NamedObjectEditModel[]</code> selected
     */
    public NamedObjectEditModel[] getSelectedModels();

    /**
     * Returns index of selected <code>NamedObjectEditModel</code>
     *
     * @return int index of selected <code>NamedObjectEditModel</code>
     */
    public int getSelectedIndex();

    /**
     * Returns index of <code>model</code>
     *
     * @param model <code>NamedObjectEditModel</code> to be searched
     * @return int index of <code>model</code>
     */
    public int indexOf(NamedObjectEditModel model);

    /**
     * Updates summary text of all specified <code>model</code> in the list
     *
     * @param model <code>NamedObjectEditModel</code> to be updated
     */
    public void update();

    /**
     * Updates summary text of specified <code>model</code> in the list
     *
     * @param model <code>NamedObjectEditModel</code> to be updated
     */
    public void update(NamedObjectEditModel model);

    /**
     * Updates summary text of model specified by <code>index</code>
     *
     * @param index index of <code>NamedObjectEditModel</code> to be updated
     */
    public void update(int index);

    /**
     * Returns a dummy <code>NamedObjectEditModel</code> instance for double-clicking
     * operation.  The subclasses shall implement it appropriately.
     *
     * @return NamedObjectEditModel to be considered as a dummy model
     */
    //    public NamedObjectEditModel getDummyModel();

}
