/*
 * TextTreeModel.java:  a TreeNode holding NamedObjectEditModel
 * for TaxoNote based on Nomencurator
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TextTreeModel.java,v 1.3 2002/06/09 12:47:01 nozomi Exp $
 * $Log: TextTreeModel.java,v $
 * Revision 1.3  2002/06/09 12:47:01  nozomi
 * change TreeModelEvent handling
 *
 * Revision 1.2  2002/03/10 21:59:19  nozomi
 * remove a constructor
 *
 * Revision 1.1  2002/03/07 01:50:25  nozomi
 * Tree implementation for edit models
 *
 */

package org.nomencurator.editor.model;

import jp.kyasu.graphics.RichTextStyle;

import org.nomencurator.util.tree.TreeModel;
import org.nomencurator.awt.tree.DefaultTreeModel;

/**
 * The model interface for an object that acts as a named object edit model
 *
 *
 * @version 	09 June 2002
 * @author 	Nozomi `James' Ytow
 */
public class TextTreeModel
    extends org.nomencurator.awt.tree.TextTreeModel
{
    //Constructors
    /**
     * Constructs a tree 
     *
     */
    /*
    public TextTreeModel(NamedObjectEditModel editModel)
    {
	this(new NamedObjectNode(editModel));
    }
    */

    /**
     * Constructs a tree of which any node may have child node.
     *
     * @param root TreeNode object to be root of the tree.
     *
     * @see DefaultTreeModel(TreeNode, boolean)
     */
    
    public TextTreeModel(NamedObjectNode root)
    {
	this(root, false);
    }

    /**
     * Constructs a tree under the root <code>node</code>
     * specifying whether any node may have children nodes
     * or only specified node may have children nodes. 
     * 
     * @param node root node of the tree
     * @param allowance false if any child node may have 
     * child node, or true if only specified node may have children.
     *
     * @see #asksAllowsChildren
     */

    public TextTreeModel(NamedObjectNode node,
		     boolean allowance)
    {
	this(new DefaultTreeModel(node, allowance));
    }
    

    /**
     * Constructs a tree under the root <code>node</code>
     * specifying whether any node may have children nodes
     * or only specified node may have children nodes. 
     * 
     * @param node root node of the tree
     * @param allowance false if any child node may have 
     * child node, or true if only specified node may have children.
     *
     * @see #asksAllowsChildren
     */

    public TextTreeModel(TreeModel model)
    {
	this(model, RichTextStyle.DEFAULT_LIST_STYLE);
    }
    
    /**
     * Constructs a single column text list model with the specified rich text
     * style.
     *
     * @param root TreeNode object to be root of the tree.
     * @param richTextStyle the rich text style.
     */
    public TextTreeModel(TreeModel model,
			 RichTextStyle ritchTextStyle)
    {
	super(model, ritchTextStyle);
    }
    
    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public TextTreeModel(TreeModel model,
			 int columnWidths[])
    {
	this(model, columnWidths.length, columnWidths);
    }

    /**
     * Constructs a text list model with the specified column widths.
     *
     * @param colWidths the column widths.
     */
    public TextTreeModel(TreeModel model,
			 int columnWidths[],
			 RichTextStyle richTextStyle)
    {
	this(model, columnWidths.length, columnWidths, richTextStyle);
    }

    /**
     * Constructs a text list model with the specified number of columns
     * and column widths.
     *
     * @param columns   the number of columns.
     * @param colWidths the column widths.
     */
    public TextTreeModel(TreeModel model,
			 int columns,
			 int colWidths[])
    {
	this(model, columns, colWidths, RichTextStyle.DEFAULT_LIST_STYLE);
    }

    /**
     * Constructs a text list model with the specified number of columns,
     * column widths, and rich text style.
     *
     * @param columns       the number of columns.
     * @param colWidths     the column widths.
     * @param richTextStyle the rich text style.
     */
    public TextTreeModel(TreeModel model,
			 int columns, 
			 int colWidths[],
			 RichTextStyle richTextStyle)
    {
	super(model, columns, colWidths, richTextStyle);
    }

}
