/*
 * TableListView.java:  a TableListView 
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TableListView.java,v 1.1 2002/03/05 22:56:41 nozomi Exp $
 * $Log: TableListView.java,v $
 * Revision 1.1  2002/03/05 22:56:41  nozomi
 * initial import
 *
 */

package org.nomencurator.editor.view;

import jp.kyasu.awt.Button;

import jp.kyasu.awt.TextListModel;

import org.nomencurator.editor.controller.TextListController;

/**
 * A <code>TextListView</code> enables slection of editors
 * 
 * @see jp.kyasu.awt.text.TextListView
 *
 * @version 	05 Mar 2002
 * @author 	Nozomi `James' Ytow
 */
public class TableListView
    extends jp.kyasu.awt.text.TableListView
{
    /**
     * Constructs a table list view with the specified model.
     *
     * @param model the text list movel.
     */
    public TableListView(TextListModel model, Button buttons[])
    {
	super(model, buttons);
    }

    protected jp.kyasu.awt.text.TextListView createView(TextListModel textListModel)
    {
	return new TextListView(textListModel);
    }

}
