/*
 * HTMLParser.java
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 *
 * $Id: HTMLParser.java,v 1.1 2002/09/06 16:48:29 nozomi Exp $
 * $Log: HTMLParser.java,v $
 * Revision 1.1  2002/09/06 16:48:29  nozomi
 * exclude TAB from whitespace
 *
 */

package org.nomencurator.graphics.html;

/**
 * A customised <code>HTMLParser</code> to retain tabs and speces
 *
 * @see         jp.kyasu.sgml.SGMLParser
 * @see         jp.kyasu.sgml.HTMLParser
 *
 * @version 	04 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class HTMLParser
    extends jp.kyasu.sgml.HTMLParser
{

    /**
     * Constructs a html parser with HTML 3.2 dtd.
     */
    public HTMLParser() {
	super();
    }

    /**
     * Constructs a html parser with the specified dtd.
     *
     * @param dtd the specified dtd.
     */
    /*
    public HTMLParser(DTD dtd)
    {
	super(dtd);
    }
    */

    /** Tests if the specified character is ISO-LATIN-1 white space. */
    protected boolean isWhitespace(char c)
    {
	return (Character.isSpace(c) && c != '\t');
    }
}
