/*
 * HTMLReader.java
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: HTMLReader.java,v 1.4 2002/09/07 01:41:46 nozomi Exp $
 * $Log: HTMLReader.java,v $
 * Revision 1.4  2002/09/07 01:41:46  nozomi
 * remove debugging println()
 *
 * Revision 1.3  2002/09/06 11:46:14  nozomi
 * use specialised HTMLStyle
 *
 * Revision 1.2  2002/09/05 05:31:00  nozomi
 * exclude TAB from white space tentatively
 *
 * Revision 1.1  2002/09/04 17:55:43  nozomi
 * introduce pseudo HTML support
 *
 */

package org.nomencurator.graphics.html;

import java.awt.Color;
import java.awt.event.ActionListener;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import java.util.Stack;

import jp.kyasu.graphics.BasicTSModifier;
import jp.kyasu.graphics.TextBuffer;

import jp.kyasu.graphics.html.HTMLText;
import jp.kyasu.graphics.html.HTMLStyle;

//import jp.kyasu.sgml.HTMLParser;

/**
 * A <CODE>jp.kyasu.graphics.html.HTMLReader<CODE> specialized to
 * convert <CODE>HTMLText</CODE> into a pseudo HTML document,
 * i.e. contents of BODY part
 *
 * @see jp.kyasu.graphics.html.HTMLReader
 *
 * @version 	07 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class HTMLReader
    extends jp.kyasu.graphics.html.HTMLReader
{
    /**
     * Constructs a html reader with default html style.
     */
    public HTMLReader()
    {
	this(org.nomencurator.graphics.html.HTMLStyle.DEFAULT_HTML_STYLE);
    }

    /**
     * Constructs a html reader with the specified html style.
     *
     * @param htmlStyle the html style for the rendering.
     */
    public HTMLReader(HTMLStyle htmlStyle) {
	this(htmlStyle, null);
    }
 
    /**
     * Constructs a html reader with the specified html style and action
     * listener for the link (<code>A</code>).
     *
     * @param htmlStyle          the html style for the rendering.
     * @param linkActionListener the action listener for the link
     *                           (<code>A</code>). If <code>null</code>,
     *                           the created <code>HTMLText</code> becomes
     *                           non clickable.
     */
    public HTMLReader(HTMLStyle htmlStyle, ActionListener linkActionListener)
    {
	super(htmlStyle, linkActionListener);
    }
   
    public HTMLText toHTMLText(String html)
    {
	HTMLReaderTarget target = new HTMLReaderTarget();
	try{
	    read(new StringReader(html), target);
	}
	catch(IOException e) { }
	HTMLText htmlText = target.getHTMLText();
	target = null;
	return htmlText;
    }

    public void read(Reader reader, HTMLReaderTarget target)
	throws IOException
    {
	super.read(reader, target);

	context = null;
	contextStack.clear();
	contextStack = null;
    }

    /** Checks if the specified character is white space of the HTML. */
    protected boolean isWhitespace(char c)
    {
	return (Character.isSpace(c) && c != '\t');
    }

}

