/*
 * HTMLReader.java
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: HTMLReaderTarget.java,v 1.1 2002/09/04 17:55:20 nozomi Exp $
 * $Log: HTMLReaderTarget.java,v $
 * Revision 1.1  2002/09/04 17:55:20  nozomi
 * introduce pseudo HTML support
 *
 */

package org.nomencurator.graphics.html;

import java.io.IOException;
import java.io.StringReader;

import java.net.URL;

import jp.kyasu.graphics.TextBuffer;

import jp.kyasu.graphics.html.DefaultHTMLReaderTarget;
import jp.kyasu.graphics.html.HTMLText;
import jp.kyasu.graphics.html.HTMLStyle;

/**
 * A <CODE>jp.kyasu.graphics.html.HTMLReader<CODE> specialized to
 * convert <CODE>HTMLText</CODE> into a pseudo HTML document,
 * i.e. contents of BODY part
 *
 * @see jp.kyasu.graphics.html.HTMLReader
 *
 * @version 	04 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class HTMLReaderTarget
    extends DefaultHTMLReaderTarget
{
    /** Constructs a default html reader target */
    public HTMLReaderTarget() { super();}

    /**
     * Opens (Initializes) this target with the specified url and html style.
     */
    public void open(URL url, HTMLStyle htmlStyle)
	throws IOException
    {
	open(htmlStyle);
    }

    /**
     * Opens (Initializes) this target with the specified url and html style.
     */
    public void open(HTMLStyle htmlStyle)
	throws IOException
    {
	this.htmlStyle = htmlStyle;
	buffer = new TextBuffer();
	buffer.setTextStyle(htmlStyle.getDefaultTextStyle());
	buffer.setParagraphStyle(htmlStyle.getDefaultParagraphStyle());
    }

}

