/*
 * HTMLStyle.java
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 *
 * $Id: HTMLStyle.java,v 1.1 2002/09/06 13:28:01 nozomi Exp $
 * $Log: HTMLStyle.java,v $
 * Revision 1.1  2002/09/06 13:28:01  nozomi
 * support specialised HTMLStyle
 *
 */

package org.nomencurator.graphics.html;

import jp.kyasu.graphics.BasicPSModifier;
import jp.kyasu.graphics.BasicTSModifier;
import jp.kyasu.graphics.ModTextStyle;
import jp.kyasu.graphics.ParagraphStyle;
import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.TextStyle;

import java.awt.Font;

/**
 * A <CODE>HTMLStyle</CODE> class with specialized <tt>P</tt> style.
 *
 * @see 	jp.kyasu.graphics.html.HTMLStyle
 *
 * @version 	06 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class HTMLStyle 
    extends jp.kyasu.graphics.html.HTMLStyle 
{
    /**
     * Returns the default rich text style for the HTML documents.
     */
    public RichTextStyle getDefaultRichTextStyle() {
	return new RichTextStyle(
			RichTextStyle.WORD_WRAP,
			RichTextStyle.JAVA_LINE_SEPARATOR_WITH_BREAK,
			true,
			getDefaultTextStyle(),
			getDefaultParagraphStyle());
    }

    public static final jp.kyasu.graphics.html.HTMLStyle DEFAULT_HTML_STYLE = new HTMLStyle(12);


    /**
     * Initializes the paragraph styles associated with the HTML tags;
     * P, H1, H2, H3, H4, H5, H6, LI (LI-UL, LI-OL), DT, DD, ADDRESS and PRE.
     */
    protected void initParagraphStyles()
    {
	super.initParagraphStyles();

	BasicPSModifier pmod = new BasicPSModifier();
	BasicTSModifier mod = new BasicTSModifier();
	ParagraphStyle pStyle;
	ModTextStyle defaultModStyle = new ModTextStyle(baseTextStyle);

	// Paragraph

	pmod.put(BasicPSModifier.STYLE_NAME, "P");
	pmod.put(BasicPSModifier.BASE_STYLE, defaultModStyle);
	pmod.put(BasicPSModifier.PARAGRAPH_SPACE_DIFF, 0);
	pStyle = baseParagraphStyle.deriveStyle(pmod);
	paragraphStyles.put("P", pStyle);
    }

    /**
     * Constructs a html style.
     */
    public HTMLStyle() { super(); }

    /**
     * Constructs a html style with the specified base font size.
     *
     * @param baseSize the base font size.
     */
    public HTMLStyle(int baseSize) { super(baseSize); }

    /**
     * Constructs a html style with the specified base font.
     * The style of the base font must be plain.
     *
     * @param baseFont the base font.
     */
    public HTMLStyle(Font baseFont) { super(baseFont); }

    /**
     * Constructs a html style with the specified base text style.
     * The style of the font of the base text style must be plain.
     *
     * @param textStyle the base text style.
     */
    public HTMLStyle(TextStyle textStyle) { super(textStyle); }

    /**
     * Constructs a html style with the specified base text style and
     * paragraph style.
     * The style of the font of the base text style must be plain.
     *
     * @param textStyle      the base text style.
     * @param paragraphStyle the base paragraph style.
     */
    public HTMLStyle(TextStyle textStyle, ParagraphStyle paragraphStyle)
    {
	super(textStyle, paragraphStyle);
    }

}
