/*
 * DataManager.java: data manager for local database system.
 *
 * Copyright (c) 2001, 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: DataManager.java,v 1.7 2002/07/02 10:42:33 t.okada Exp $
 * $Log: DataManager.java,v $
 * Revision 1.7  2002/07/02 10:42:33  t.okada
 * It changes so that unicode can be used.
 *
 * Revision 1.6  2002/06/04 13:48:39  ryo
 * add path setting function
 *
 * Revision 1.5  2002/04/16 03:53:38  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.4  2002/04/03 12:52:10  ryo
 * CRLF conversion
 *
 * Revision 1.3  2002/03/28 07:13:49  ryo
 * add copyright.
 *
 * Revision 1.2  2002/03/07 13:29:14  ryo
 * fix a bug in addObjectData()
 *
 * Revision 1.1  2002/03/05 07:47:56  ryo
 * initial import into CVS.
 *
 */

package org.nomencurator.localdb;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;

class DataManager
{
	private String _rootDir;
	private String _fileExtention = ".xml";

	/**
	 * Constractor
	 */
	public DataManager(String rootDir) {
		_rootDir = rootDir;
		File dir = new File(_rootDir);
		if (!dir.exists())
			dir.mkdirs();
	}

	/**
	 * get object data.
	 * @param objectID the object id.
	 * @return object data. (XML format)
	 */
	public String getObjectData(String objectID) {
		try {
			StringBuffer s = new StringBuffer();
			File file = new File(_rootDir, objectID + _fileExtention);
//			BufferedReader in = new BufferedReader(new FileReader(file));
			BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF8"));

			String line;
			while ((line = in.readLine()) != null) {
				s.append(line);
			}
			in.close();
			return s.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * add object data.
	 * @param filename the file name.
	 * @param contents the contents.
	 */
	public synchronized void addObjectData(String filename, String contents) {
		Vector v = new Vector();
		v.addElement(contents);
		addObjectData(filename, v);
	}

	/**
	 * add object data.
	 * @param filename the file name.
	 * @param contents the contents.
	 */
	public synchronized void addObjectData(String filename, Vector contents) {
		try {
			File file = new File(_rootDir, filename + _fileExtention);
//			BufferedWriter out = new BufferedWriter(new FileWriter(file));
			BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF8"));
			for (int i=0; i<contents.size(); i++) {
				out.write((String)contents.elementAt(i));
			}
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		DataManager data = new DataManager(new String("/localdb/data"));
	}
}
