/*
 *
 * Mail.java:  a Java implementation of a Mail handler
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Mail.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: Mail.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;

import java.lang.SecurityManager;

import java.net.InetAddress;
import java.net.MalformedURLException; 
import java.net.Socket;
import java.net.SocketPermission;
import java.net.UnknownHostException;
import java.net.URL;
import java.net.URLConnection;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Mail extends Object
{

    public static void sendmail(String from, String to, String subject, String contents)
    throws AccessControlException, UnknownHostException, SecurityException, IOException
    {
	try {
	    sendmailByURL(from, to, subject, contents);
	}
	catch(Throwable t) {
	    sendmailViaSMTP(from, to, subject, contents);
	}
    }

    protected static void sendmailByURL(String from, String to, String subject, String contents)
    throws MalformedURLException, IOException
    {
	sendmailByURL(from, to, subject, contents, "ASCII");
    }

    protected static void sendmailByURL(String from, String to, String subject, String contents,
					String encoding)
    throws MalformedURLException, IOException
    {
	URL mailTo = new URL("mailto:" + to);
	URLConnection mailConnection = mailTo.openConnection();
	mailConnection.setDoInput(false);
	mailConnection.setDoOutput(true);
	mailConnection.connect();

	PrintWriter mail = 
		new PrintWriter(new OutputStreamWriter(mailConnection.getOutputStream(), encoding));
	
	mail.println("From: " + from);
	mail.println("To: "   + to);
	mail.println("Subject: ");
	mail.println();
	mail.write(contents);
	mail.flush();
	mail.close();
    }

    static private final int smtpPort = 25;

    static public void sendmailViaSMTP (String from, String to, String subject, String contents)
    throws AccessControlException, UnknownHostException, SecurityException, IOException
    {
	sendmailViaSMTP (from, to, subject, contents, "ASCII");
    }

    static public void sendmailViaSMTP (String from, String to, String subject, String contents,
					String encoding)
    throws AccessControlException, UnknownHostException, SecurityException, IOException
    {

	String recipient = extractUserName(to);
	String recipientHost = extractHostName(to);

	Socket socket = null;

	socket = new Socket(recipientHost, smtpPort);
	
	BufferedReader server = 
	    new BufferedReader(new InputStreamReader(socket.getInputStream()));

	PrintWriter mail = null;
	try {
	    mail =
		new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), encoding));
	}
	catch(Throwable e) {
	    mail =
		new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
	}

	waitSeverSays(server, "220");
	String localhost = null;

	localhost = InetAddress.getLocalHost().getHostName();

	mail.print("HELO " + extractHostName(from) +"\r\n");
	mail.flush();
	waitSeverSays(server, "250");
	mail.print("MAIL FROM: <" + from +">\r\n");
	mail.flush();
	waitSeverSays(server, "250");
	mail.print("RCPT TO: <" + to +">\r\n");
	mail.flush();
	mail.print("DATA\r\n");
	mail.flush();
	waitSeverSays(server, "354");
	mail.write(contents);
	mail.print("\r\n.\r\n");
	mail.flush();
	waitSeverSays(server, "250");
	mail.print("QUIT\r\n");
	mail.flush();

	socket.close();
    }

    static public String extractUserName(String mailAddress)
    {
	return mailAddress.substring(0, mailAddressSeparatorAt(mailAddress) - 1);
    }

    static public String extractHostName(String mailAddress)
    {
	return mailAddress.substring(mailAddressSeparatorAt(mailAddress));
    }

    static public int mailAddressSeparatorAt(String mailAddress)
    {
	int at = 0;
	char c = mailAddress.charAt(at++);
	for(;at < mailAddress.length() && c != '@'; at++)
	    c = mailAddress.charAt(at);
	return at;
    }

    static protected void waitSeverSays(BufferedReader server, String say)
    {
	try{
	    String serverSays = server.readLine();
	    while(!serverSays.startsWith(say)) {
		serverSays = server.readLine();
	    }
	}
	catch (IOException iox) {
	}
    }

}

