/*
 * SearchNUToAuthoritySql.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: SearchNRToAuthoritySql.java,v 1.5 2002/03/28 06:33:03 okawa Exp $
 * $Log: SearchNRToAuthoritySql.java,v $
 * Revision 1.5  2002/03/28 06:33:03  okawa
 * add copyright
 *
 * Revision 1.4  2002/03/08 14:00:34  okawa
 * no message
 *
 * Revision 1.3  2002/02/22 10:23:01  okawa
 * initial import into CVS
 *
 *
 */
package org.nomencurator.server.db;

import java.sql.ResultSet;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.SQLException;

import org.nomencurator.Appearance;

public class SearchNUToAuthoritySql extends SqlController
{
    /**
     * get sql command string
     * @param String[] parameters
     * @return String sql command
     */
    public String getSql(String[] param) {

        String oid = param[0];

        // constract SQL
        String sql = "SELECT B.id, B.appearance FROM NameUsage A, Appearance B " +
                     "WHERE A.authority = B.id and " + 
                     "A.id = '" + oid + "'";
        
        return sql;
    }
    
    /**
     * get result object
     * @param Connection database connection
     * @param String sql command
     * @return Object <Appearance>  result
     */
    public Object getResult(Connection con, String sql) {
        Appearance appearance = null;
System.out.println("[SearchNUToAuthoritySql::getResult] sql;" + sql);        
        try {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);

            while(rs.next()){
                appearance = new Appearance(rs.getString(1));
                appearance.parseLine("appearance{"+rs.getString(2)+"}");
            }
            rs.close();
            stmt.close();
        } catch (SQLException ex) {
            System.err.println("SQL failed.");
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
System.out.println("[SearchNUToAuthoritySql::getResult] pass 003");
	    return appearance;
    }

}
