/*
 * AbstractXmlFactory.java: abstract class for XML Factory
 *
 * Copyright (c) 2001, 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AbstractXmlFactory.java,v 1.5 2002/07/29 05:01:08 ryo Exp $
 * $Log: AbstractXmlFactory.java,v $
 * Revision 1.5  2002/07/29 05:01:08  ryo
 * change XML file encoding from 'Shift_JIS' to 'UTF-8'
 *
 * Revision 1.4  2002/06/13 13:38:24  ryo
 * add status, message and their accessor
 *
 * Revision 1.3  2002/03/28 06:33:33  okawa
 * add copyright
 *
 * Revision 1.2  2002/02/22 10:53:42  okawa
 * initial import into CVS(modify Id tag)
 *
 *
 */
package org.nomencurator.server.xml;

import java.io.PrintWriter;

public class AbstractXmlFactory
{
    public static final String L_DOCTYPE = "NOM-XML";
    public static final int STATUS_OK = 0;
    protected int _status = STATUS_OK;
    protected String _message = "OK";
    
    /**
     * write hedder
     * @param  PrintWriter out
     */
    protected void writeHead(PrintWriter out)
    {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        out.println("<!DOCTYPE " + L_DOCTYPE + ">");
        out.println("<response status=\"" + _status + "\" text=\"" + _message + "\">");
    }

    /**
     * write tail
     * @param  PrintWriter out
     */
    protected void writeTail(PrintWriter out)
    {
        out.println("</response>");
    }

	/**
	 * 
	 */
	protected void setStatus(int status) {
		_status = status;
	}

	/**
	 * 
	 */
	protected void setStatus(int status, String message) {
		_status = status;
		_message = message;
	}

	/**
	 * 
	 */
	protected void setMessageString(String message) {
		_message = message;
	}

}
