/*
 * NameUsageXmlFactory.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameRecordXmlFactory.java,v 1.5 2002/03/28 06:33:33 okawa Exp $
 * $Log: NameRecordXmlFactory.java,v $
 * Revision 1.5  2002/03/28 06:33:33  okawa
 * add copyright
 *
 * Revision 1.4  2002/03/07 14:40:09  okawa
 * add year
 *
 * Revision 1.3  2002/02/26 02:30:41  okawa
 * modify minor bug
 *
 * Revision 1.2  2002/02/14 08:36:44  okawa
 * inherit from AbstractXmlFactory
 *
 * Revision 1.1  2002/02/01 10:12:09  okawa
 * initial import into CVS
 *
 */
package org.nomencurator.server.xml;

import java.util.Vector;
import java.util.Enumeration;
import java.io.PrintWriter;

import org.nomencurator.editor.NameUsageListRow;

public class NameUsageXmlFactory extends AbstractXmlFactory
{
    /**
     * write NameUsage records
     * @param  PrintWriter out
     * @param  Vector<NameUsageListRow>
     */
    public void write(PrintWriter out, Vector nameUsageList)
    {
        writeHead(out);
        
        if(nameUsageList != null) {
            for (Enumeration e = nameUsageList.elements() ; e.hasMoreElements() ;) {
                NameUsageListRow row = (NameUsageListRow)(e.nextElement());
                writeNameUsage(out, row);
            }
        }
        writeTail(out);
        out.close();
    }

    /**
     * write NameUsage record
     * @param  PrintWriter out
     * @param  NameUsageListRow row
     */
    private void writeNameUsage(PrintWriter out, NameUsageListRow row)
    {
        out.println("<item>");
        out.println("<oid>" + row.getObjectId() + "</oid>");
        out.println("<name>" + row.getName() + "</name>");
        out.println("<author>" + row.getAuthor() + "</author>");
        out.println("<year>" + row.getYear() + "</year>");
        out.println("</item>");
    }

}
