/*
 * NamedObjectListXmlFactory.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NamedObjectListXmlFactory.java,v 1.9 2002/06/17 09:47:43 ryo Exp $
 * $Log: NamedObjectListXmlFactory.java,v $
 * Revision 1.9  2002/06/17 09:47:43  ryo
 * remove writeTree() and writeTreeObject()
 *
 * Revision 1.8  2002/05/08 11:11:16  ryo
 * remove unused import line
 *
 * Revision 1.7  2002/04/16 03:53:38  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.6  2002/03/28 06:33:33  okawa
 * add copyright
 *
 * Revision 1.5  2002/03/10 08:49:54  okawa
 * modify writeTreeObject()
 *
 * Revision 1.4  2002/03/08 13:58:07  okawa
 * add writeTree()
 *
 * Revision 1.3  2002/02/22 10:53:42  okawa
 * initial import into CVS(modify Id tag)
 *
 *
 */
package org.nomencurator.server.xml;

import java.io.PrintWriter;

import org.nomencurator.NamedObject;

public class NamedObjectListXmlFactory extends AbstractXmlFactory
{
    /**
     * write NameUsage records
     * @param  PrintWriter out
     * @param  NamedObject
     */
    public void write(PrintWriter out, NamedObject namedObject)
    {
        writeHead(out);
        writeNamedObjectAndRelatedList(out, namedObject);
        writeTail(out);
        out.close();
    }

    /**
     * write NamedObject
     * @param  PrintWriter out
     * @param  NamedObject o
     */
    private void writeNamedObjectAndRelatedList(PrintWriter out, NamedObject o)
    {
        if(o != null) {
			String objectListXMLString = o.toXMLString();
            out.println(objectListXMLString);
        }
    }

}
