/*
 * Comparer.java:  a class to be used to sort Objects
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: Comparer.java,v 1.4 2002/09/17 08:33:36 nozomi Exp $
 * $Log: Comparer.java,v $
 * Revision 1.4  2002/09/17 08:33:36  nozomi
 * extends NameUsageListRow comparison
 *
 * Revision 1.3  2002/09/09 05:39:54  nozomi
 * mvoe comparison of Object[]s and Strings to the super class
 *
 * Revision 1.2  2002/09/09 00:40:08  nozomi
 * implemnt forward/backward switch
 *
 * Revision 1.1  2002/09/08 14:18:39  nozomi
 * provides a comparator of String and NamedObject
 *
 */
package org.nomencurator.util;

import jp.kyasu.util.CompareAdapter;

import org.nomencurator.Nameable;
//import org.nomencurator.editor.NameUsageListRow;

/**
 * A customized Comparer for the comparison operations.
 *
 * @see 	jp.kyasu.util.Comparer
 * @see 	jp.kyasu.util.CompareAdatpor
 * @see 	jp.kyasu.util.Sorter
 *
 * @version 	17 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class Comparer
    extends CompareAdapter
{
    public final int BY_NAME = 0;
    public final int BY_AUTHOR = 1;
    public final int BY_YEAR = 2;
    //    public final int BY_RANK = 3;
    public final int BY_RANK = 2;

    public final int FORWARD = 1;
    public final int BACKWORD = -1;

    protected int nameUsageListRowCompareMode = BY_NAME;
    protected int[] nameUsageListRowCompareSequence;

    protected int searchDirection = 1;

    /**
     * Constructs a <CODE>CompareAdapter</CODE>
     * which compares arrays sequentially
     */
    public Comparer() { this(null); }

    /**
     * Constructs a <CODE>CompareAdapter</CODE>
     * which compares arrays in specified <CODE>order</CODE>.
     * If arrays to be compared to is longer than <CODE>order</CODE>,
     * sequential comparison will be used for remaining part.
     *
     * @param order an array of <CODE>int</CODE> specifying comparison order
     */
    public Comparer(int[] order)
    {
	super(order);
    }


    public void setNameUsageListRowCompareMode(int mode)
    {
	nameUsageListRowCompareMode = mode;
    }

    public int getNameUsageListRowCompareMode()
    {
	return nameUsageListRowCompareMode;
    }

    public int flipSearchDirection()
    {
	searchDirection *= -1;
	return searchDirection;
    }

    public int getSearchDirection()
    {
	return searchDirection;
    }

    public void setForwardSearch()
    {
	searchDirection = FORWARD;
    }

    public void setBackwardSearch()
    {
	searchDirection = FORWARD;
    }

    /** Returns &lt;0 if x &lt; y, etc. */
    public int compare(String x, String y)
    {
	return super.compare(x, y);
    }

    /** Returns &lt;0 if x &lt; y, etc. */
    public int compare(Object x, Object y)
    {
	if((x instanceof Nameable) &&
	   (y instanceof Nameable))
	    return compare((Nameable)x, (Nameable) y);
	/*
	if((x instanceof NameUsageListRow) &&
	   (y instanceof NameUsageListRow))
	    return compare((NameUsageListRow)x, (NameUsageListRow)y);
	*/
	return super.compare(x, y);
    }

    /** Returns &lt;0 if x &lt; y, etc. */
    public int compare(Nameable x, Nameable y)
    {
	int result = compare(x.getName(), y.getName());
	if(result == 0)
	    result = compare(x.hashCode(), y.hashCode());
	return result;
    }

    /** Returns &lt;0 if x &lt; y, etc. */
    /*
    public int compare(NameUsageListRow x, NameUsageListRow y)
    {
    */
	/*
	switch(nameUsageListRowCompareMode) {
	case BY_AUTHOR:
	    return super.compare(x.getAuthor(), y.getAuthor()) * searchDirection;
	case BY_YEAR:
	    return super.compare(x.getYear(), y.getYear()) * searchDirection;
	case BY_NAME:
	    return super.compare(x.getName(), y.getName()) * searchDirection;
	case BY_RANK:
	default:
	    return super.compare(x.getObjectId(), y.getObjectId()) * searchDirection;
	}
	*/
    /*
	return compare(x, y, 0);
    }
    */

    /** Returns &lt;0 if x &lt; y, etc. */
    /*
    protected int compare(NameUsageListRow x, NameUsageListRow y, int index)
    {
	int result = 0;
	int key = index;
	if(nameUsageListRowCompareSequence != null && 
	   index < nameUsageListRowCompareSequence.length)
	    key = nameUsageListRowCompareSequence[index];
	if (key > BY_RANK)
	    key = BY_RANK;
	if (key < 0)
	    key = 0;

	switch(key) {
	case BY_AUTHOR:
	    result = compare(x.getAuthor(), y.getAuthor()) * searchDirection;
	case BY_YEAR:
	    result = compare(x.getYear(), y.getYear()) * searchDirection;
	case BY_NAME:
	    result = compare(x.getName(), y.getName()) * searchDirection;
	    //case BY_RANK:
	default:
	    result = compare(x.getObjectId(), y.getObjectId()) * searchDirection;
	}
	if(result == 0 && ++index <= BY_RANK) {
	    result = compare(x, y, index);
	}

	return result;
    }
    */
}
